/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EjbExtensionsHelper;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextFactory;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.FinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.FullSelectFinderDescriptor;
import com.ibm.ejs.models.base.extensions.ejbext.UserFinderDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jem.internal.java.adapters.JavaReflectionAdaptor;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;

public class FinderHelperMetaDataConverter {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final String FIND = "find";
    public static final String FIND_BY_PRIMARY_KEY = "findByPrimaryKey";
    public static final String FINDER_HELPER = "FinderHelper";
    public static final String WHERE_CLAUSE = "WhereClause";
    public static final String QUERY_STRING = "QueryString";
    protected EJBJarFile ejbJarFile;
    protected ContainerManagedEntity currentCMP;
    protected JavaClass currentInterface;

    public FinderHelperMetaDataConverter(EJBJarFile anEJBJarFile) {
        this.ejbJarFile = anEJBJarFile;
    }

    protected void addFinderDescriptor(FinderDescriptor desc, MethodElement methodElement) {
        desc.getFinderMethodElements().add(methodElement);
        this.getCurrentExtension().getFinderDescriptors().add(desc);
    }

    protected void addFinderDescriptor(MethodElement methodElement, Field finderField) {
        FinderDescriptor desc = null;
        Block aBlock = finderField.getInitializer();
        String finderString = null;
        if (aBlock == null || (finderString = aBlock.getSource()) == null) {
            return;
        }
        String value = finderString.substring(1, finderString.length() - 1);
        if (this.isWhereClause(finderField)) {
            desc = this.getExtensionsFactory().createWhereClauseFinderDescriptor();
            desc.setWhereClause(value);
        } else {
            desc = this.getExtensionsFactory().createFullSelectFinderDescriptor();
            ((FullSelectFinderDescriptor)desc).setSelectStatement(value);
        }
        this.addFinderDescriptor(desc, methodElement);
    }

    protected void addFinderDescriptor(MethodElement methodElement, Method userMethod) {
        UserFinderDescriptor desc = this.getExtensionsFactory().createUserFinderDescriptor();
        this.addFinderDescriptor(desc, methodElement);
    }

    protected MethodElement createMethodElement(Method aMethod) {
        MethodElement methodElement = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createMethodElementFrom(aMethod);
        methodElement.setEnterpriseBean(this.currentCMP);
        methodElement.setType(MethodElementKind.HOME_LITERAL);
        if (!methodElement.hasMethodParams()) {
            methodElement.applyZeroParams();
        }
        return methodElement;
    }

    protected Field detectFinderFieldFor(Method finderMethod) {
        List extendedFields = this.currentInterface.getFieldsExtended();
        for (int i = 0; i < extendedFields.size(); ++i) {
            Field aField = (Field)extendedFields.get(i);
            String name = aField.getName();
            if (!name.equals(finderMethod.getName().concat(WHERE_CLAUSE)) && !name.equals(finderMethod.getName().concat(QUERY_STRING))) continue;
            return aField;
        }
        return null;
    }

    protected Method detectFinderMethodFor(MethodElement finderMethodElement) {
        List extendedMethods = this.currentInterface.getMethodsExtended();
        for (int i = 0; i < extendedMethods.size(); ++i) {
            Method aMethod = (Method)extendedMethods.get(i);
            if (!finderMethodElement.nameAndParamsEquals(aMethod)) continue;
            return aMethod;
        }
        return null;
    }

    protected ContainerManagedEntityExtension getCurrentExtension() {
        return (ContainerManagedEntityExtension)EjbExtensionsHelper.getEjbExtension(this.currentCMP);
    }

    public EjbextFactory getExtensionsFactory() {
        return ((EjbextPackage)EPackage.Registry.INSTANCE.getEPackage("ejbext.xmi")).getEjbextFactory();
    }

    protected List getFindMethods() {
        ArrayList<Method> filtered = new ArrayList<Method>();
        if (this.currentCMP.getHomeInterface() != null) {
            List methods = this.currentCMP.getHomeInterface().getMethodsExtended();
            for (int i = 0; i < methods.size(); ++i) {
                Method aMethod = (Method)methods.get(i);
                if (!aMethod.getName().startsWith(FIND) || aMethod.getName().equals(FIND_BY_PRIMARY_KEY)) continue;
                filtered.add(aMethod);
            }
        }
        return filtered;
    }

    protected boolean isWhereClause(Field aField) {
        return aField.getName().endsWith(WHERE_CLAUSE);
    }

    protected void primReflectCurrentCMP() {
        this.setCurrentInterface();
        if (this.currentInterface == null) {
            return;
        }
        List methods = this.getFindMethods();
        for (int i = 0; i < methods.size(); ++i) {
            Method aMethod = (Method)methods.get(i);
            MethodElement methodElement = this.createMethodElement(aMethod);
            Field finderField = this.detectFinderFieldFor(aMethod);
            if (finderField != null) {
                this.addFinderDescriptor(methodElement, finderField);
                continue;
            }
            Method userMethod = this.detectFinderMethodFor(methodElement);
            if (userMethod == null) continue;
            this.addFinderDescriptor(methodElement, userMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reflectCurrentCMP() {
        try {
            this.primReflectCurrentCMP();
        }
        finally {
            if (this.currentInterface != null) {
                JavaReflectionAdaptor.releaseSourceType(this.currentInterface);
            }
            if (this.currentCMP != null && this.currentCMP.getHomeInterface() != null) {
                JavaReflectionAdaptor.releaseSourceType(this.currentCMP.getHomeInterface());
            }
        }
    }

    public void reflectMetaData() {
        EList ejbs = this.ejbJarFile.getDeploymentDescriptor().getEnterpriseBeans();
        for (int i = 0; i < ejbs.size(); ++i) {
            EnterpriseBean bean = (EnterpriseBean)ejbs.get(i);
            if (!bean.isContainerManagedEntity()) continue;
            this.currentCMP = (ContainerManagedEntity)bean;
            this.reflectCurrentCMP();
        }
    }

    protected JavaClass setCurrentInterface() {
        String className = this.currentCMP.getEjbClassName().concat(FINDER_HELPER);
        if (!this.ejbJarFile.containsFile(ArchiveUtil.classNameToUri(className))) {
            this.currentInterface = null;
        }
        this.currentInterface = (JavaClass)JavaClassImpl.reflect(className, this.ejbJarFile.getResourceSet());
        return this.currentInterface;
    }
}

