/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.util;

import com.ibm.etools.common.util.TreeIterator;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractTreeIterator
implements TreeIterator {
    boolean includeRoot;
    protected Object object;
    protected LinkedList iteratorStack;
    protected Iterator nextPruneIterator;
    protected Iterator nextRemoveIterator;

    public AbstractTreeIterator(Object object) {
        this.object = object;
        this.includeRoot = true;
    }

    public AbstractTreeIterator(Object object, boolean includeRoot) {
        this.object = object;
        this.includeRoot = includeRoot;
    }

    protected abstract Iterator getChildren(Object var1);

    public boolean hasNext() {
        if (!this.includeRoot && this.iteratorStack == null) {
            this.iteratorStack = new LinkedList();
            this.nextPruneIterator = this.getChildren(this.object);
            this.iteratorStack.addLast(this.nextPruneIterator);
            return this.nextPruneIterator.hasNext();
        }
        return this.iteratorStack == null || !this.iteratorStack.isEmpty() && ((Iterator)this.iteratorStack.getLast()).hasNext();
    }

    public Object next() {
        Object result;
        if (this.iteratorStack == null) {
            result = this.object;
            this.iteratorStack = new LinkedList();
            this.nextPruneIterator = this.getChildren(this.object);
            this.iteratorStack.addLast(this.nextPruneIterator);
        } else {
            Iterator currentIterator = (Iterator)this.iteratorStack.getLast();
            result = currentIterator.next();
            this.nextRemoveIterator = currentIterator;
            Iterator iterator = this.getChildren(result);
            if (iterator.hasNext()) {
                this.nextPruneIterator = iterator;
                this.iteratorStack.addLast(iterator);
            } else {
                this.nextPruneIterator = null;
                while (!currentIterator.hasNext()) {
                    this.iteratorStack.removeLast();
                    if (this.iteratorStack.isEmpty()) break;
                    currentIterator = (Iterator)this.iteratorStack.getLast();
                }
            }
        }
        return result;
    }

    public void prune() {
        if (this.nextPruneIterator != null) {
            if (!this.iteratorStack.isEmpty() && this.iteratorStack.getLast() == this.nextPruneIterator) {
                this.iteratorStack.removeLast();
                while (!this.iteratorStack.isEmpty() && !((Iterator)this.iteratorStack.getLast()).hasNext()) {
                    this.iteratorStack.removeLast();
                }
            }
            this.nextPruneIterator = null;
        }
    }

    public void remove() {
        if (this.nextRemoveIterator == null) {
            throw new RuntimeException("The method " + this.getClass().getName() + ".remove() is not supported.");
        }
        this.nextRemoveIterator.remove();
    }
}

