/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.command;

import com.ibm.etools.common.command.AbstractCommand;
import com.ibm.etools.common.command.Command;
import com.ibm.etools.common.internal.CommonPlugin;
import java.util.Collection;
import java.util.Collections;

public class CommandWrapper
extends AbstractCommand {
    protected Command command;

    protected CommandWrapper() {
    }

    public CommandWrapper(Command command) {
        super(command.getLabel(), command.getDescription());
        this.command = command;
    }

    protected CommandWrapper(String label) {
        super(label);
    }

    protected CommandWrapper(String label, Command command) {
        super(label, command.getDescription());
        this.command = command;
    }

    protected CommandWrapper(String label, String description) {
        super(label, description);
    }

    public CommandWrapper(String label, String description, Command command) {
        super(label, description);
        this.command = command;
    }

    public boolean canUndo() {
        return this.command == null || this.command.canUndo();
    }

    protected Command createCommand() {
        return null;
    }

    public void dispose() {
        if (this.command != null) {
            this.command.dispose();
        }
    }

    public void execute() {
        if (this.command != null) {
            this.command.execute();
        }
    }

    public Collection getAffectedObjects() {
        return this.command == null ? Collections.EMPTY_LIST : this.command.getAffectedObjects();
    }

    public Command getCommand() {
        return this.command;
    }

    public String getDescription() {
        return this.description == null ? (this.command == null ? CommonPlugin.getPlugin().getString("_UI_CommandWrapper_description") : this.command.getDescription()) : this.description;
    }

    public String getLabel() {
        return this.label == null ? (this.command == null ? CommonPlugin.getPlugin().getString("_UI_CommandWrapper_label") : this.command.getLabel()) : this.label;
    }

    public Collection getResult() {
        return this.command == null ? Collections.EMPTY_LIST : this.command.getResult();
    }

    protected boolean prepare() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("CommandWrapper.prepare", this);
        }
        if (this.command == null) {
            this.command = this.createCommand();
        }
        boolean result = this.command.canExecute();
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.leave(result, !result);
        }
        return result;
    }

    public void redo() {
        if (this.command != null) {
            this.command.redo();
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (command: " + this.command + ")");
        return result.toString();
    }

    public void undo() {
        this.command.undo();
    }
}

