/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.command;

import com.ibm.etools.common.command.AbstractCommand;
import com.ibm.etools.common.command.Command;
import com.ibm.etools.common.command.CommandStack;
import com.ibm.etools.common.command.CommandStackListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BasicCommandStack
implements CommandStack {
    protected List commandList = new ArrayList();
    protected int top = -1;
    protected Command mostRecentCommand;
    protected Collection listeners = new ArrayList();
    protected int saveIndex = -1;

    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    public boolean canRedo() {
        return this.top < this.commandList.size() - 1;
    }

    public boolean canUndo() {
        return this.top != -1 && ((Command)this.commandList.get(this.top)).canUndo();
    }

    public void execute(Command command) {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("BasicCommandStack.execute", this);
        }
        if (command == null) {
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.leave("! Cannot execute a null command, so it is ignored.", true);
            }
        } else if (command.canExecute()) {
            ListIterator commands = this.commandList.listIterator(this.top + 1);
            while (commands.hasNext()) {
                Command otherCommand = (Command)commands.next();
                otherCommand.dispose();
                commands.remove();
            }
            try {
                command.execute();
                this.mostRecentCommand = command;
                this.commandList.add(command);
                ++this.top;
            }
            catch (RuntimeException exception) {
                if (AbstractCommand.Trace.isEnabled) {
                    exception.printStackTrace(AbstractCommand.Trace.out);
                }
                exception.printStackTrace();
                this.mostRecentCommand = null;
                command.dispose();
            }
            if (this.saveIndex >= this.top) {
                this.saveIndex = -2;
            }
            this.notifyListeners();
            if (AbstractCommand.Trace.isEnabled) {
                if (this.mostRecentCommand != null) {
                    AbstractCommand.Trace.out.leave();
                } else {
                    AbstractCommand.Trace.out.leave("! An exception was caught and the command disposed.", true);
                }
            }
        } else {
            command.dispose();
            if (AbstractCommand.Trace.isEnabled) {
                AbstractCommand.Trace.out.leave("! Cannot execute the command, so it is ignored.", true);
            }
        }
    }

    public void flush() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            command.dispose();
            commands.remove();
        }
        this.commandList.clear();
        this.top = -1;
        this.notifyListeners();
    }

    public Command getMostRecentCommand() {
        return this.mostRecentCommand;
    }

    public Command getRedoCommand() {
        return this.top + 1 >= this.commandList.size() ? null : (Command)this.commandList.get(this.top + 1);
    }

    public Command getUndoCommand() {
        return this.top == -1 || this.top == this.commandList.size() ? null : (Command)this.commandList.get(this.top);
    }

    public boolean isSaveNeeded() {
        return this.top != this.saveIndex;
    }

    protected void notifyListeners() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((CommandStackListener)i.next()).commandStackChanged(new EventObject(this));
        }
    }

    public void redo() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("BasicCommandStack.redo", this);
        }
        if (this.canRedo()) {
            Command command = (Command)this.commandList.get(++this.top);
            try {
                command.redo();
                this.mostRecentCommand = command;
            }
            catch (RuntimeException exception) {
                if (AbstractCommand.Trace.isEnabled) {
                    exception.printStackTrace(AbstractCommand.Trace.out);
                }
                this.mostRecentCommand = null;
                ListIterator commands = this.commandList.listIterator(this.top--);
                while (commands.hasNext()) {
                    Command otherCommand = (Command)commands.next();
                    otherCommand.dispose();
                    commands.remove();
                }
            }
            this.notifyListeners();
            if (AbstractCommand.Trace.isEnabled) {
                if (this.mostRecentCommand == null) {
                    AbstractCommand.Trace.out.leave();
                } else {
                    AbstractCommand.Trace.out.leave("! An exception was caught and the stack was flushed.", true);
                }
            }
        }
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    public void saveIsDone() {
        this.saveIndex = this.top;
    }

    public void undo() {
        if (AbstractCommand.Trace.isEnabled) {
            AbstractCommand.Trace.out.enter("BasicCommandStack.undo", this);
        }
        if (this.canUndo()) {
            Command command = (Command)this.commandList.get(this.top--);
            try {
                command.undo();
                this.mostRecentCommand = command;
            }
            catch (RuntimeException exception) {
                if (AbstractCommand.Trace.isEnabled) {
                    exception.printStackTrace(AbstractCommand.Trace.out);
                }
                this.mostRecentCommand = null;
                this.flush();
            }
            this.notifyListeners();
            if (AbstractCommand.Trace.isEnabled) {
                if (this.mostRecentCommand != null) {
                    AbstractCommand.Trace.out.leave();
                } else {
                    AbstractCommand.Trace.out.leave("! An exception was caught and the stack was flushed.", true);
                }
            }
        }
    }
}

