/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.common.command;

import com.ibm.etools.common.command.Command;
import com.ibm.etools.common.command.CompoundCommand;
import com.ibm.etools.common.internal.CommonPlugin;
import com.ibm.etools.common.util.TraceStream;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractCommand
implements Command {
    protected boolean isPrepared;
    protected boolean isExecutable;
    protected String description;
    protected String label;

    protected AbstractCommand() {
    }

    protected AbstractCommand(String label) {
        this.label = label;
    }

    protected AbstractCommand(String label, String description) {
        this.label = label;
        this.description = description;
    }

    public boolean canExecute() {
        if (Trace.isEnabled) {
            Trace.out.enter("AbstractCommand.canExecute", this);
        }
        if (!this.isPrepared) {
            this.isExecutable = this.prepare();
            this.isPrepared = true;
        }
        if (Trace.isEnabled) {
            Trace.out.leave(this.isExecutable, !this.isExecutable);
        }
        return this.isExecutable;
    }

    public boolean canUndo() {
        if (Trace.isEnabled) {
            Trace.out.enter("AbstractCommand.canUndo", this);
            Trace.out.leave(true);
        }
        return true;
    }

    public Command chain(Command command) {
        class ChainedCompoundCommand
        extends CompoundCommand {
            public Command chain(Command c) {
                this.append(c);
                return this;
            }
        }
        ChainedCompoundCommand result = new ChainedCompoundCommand();
        result.append(this);
        result.append(command);
        return result;
    }

    public void dispose() {
    }

    public Collection getAffectedObjects() {
        return Collections.EMPTY_LIST;
    }

    public String getDescription() {
        return this.description == null ? CommonPlugin.getPlugin().getString("_UI_AbstractCommand_description") : this.description;
    }

    public String getLabel() {
        return this.label == null ? CommonPlugin.getPlugin().getString("_UI_AbstractCommand_label") : this.label;
    }

    public Collection getResult() {
        return Collections.EMPTY_LIST;
    }

    protected boolean prepare() {
        if (Trace.isEnabled) {
            Trace.out.enter("AbstractCommand.prepare", this);
            Trace.out.leave(false, true);
        }
        return false;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        String className = this.getClass().getName();
        int lastDotIndex = className.lastIndexOf(46);
        StringBuffer result = new StringBuffer(lastDotIndex == -1 ? className : className.substring(lastDotIndex + 1));
        result.append(" (label: " + this.label + ")");
        result.append(" (description: " + this.description + ")");
        result.append(" (isPrepared: " + this.isPrepared + ")");
        result.append(" (isExecutable: " + this.isExecutable + ")");
        return result.toString();
    }

    public void undo() {
        throw new RuntimeException(CommonPlugin.getPlugin().getString("_EXC_Method_not_implemented", this.getClass().getName() + ".undo()"));
    }

    public static class Trace {
        public static TraceStream out = TraceStream.getTraceStream(System.getProperty("EMF_TRACE_COMMAND"));
        public static boolean isEnabled = out != null;
        protected static int enableCount = isEnabled ? 1 : 0;

        public static void enable() {
            if (enableCount == 0) {
                if (out == null) {
                    out = TraceStream.getTraceStream("System.out");
                }
                isEnabled = true;
            }
            ++enableCount;
        }

        public static void disable() {
            if (--enableCount == 0) {
                isEnabled = false;
            }
        }
    }
}

