/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.opool;

import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.opool.DiscardStrategy;
import com.ibm.ejs.util.opool.Pool;
import com.ibm.websphere.pmi.PmiBean;
import java.util.Enumeration;
import java.util.Vector;

public class PoolManager
implements AlarmListener {
    private static final PoolManager poolMgr = new PoolManager();
    private Vector pools = new Vector();
    private static long drainInterval = 30000L;

    private static synchronized long getDrainInterval() {
        return drainInterval;
    }

    public static synchronized void setDrainInterval(long di) {
        drainInterval = di;
    }

    private PoolManager() {
        AlarmManager.create((long)PoolManager.getDrainInterval(), (AlarmListener)this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object alarmContext) {
        Vector vector = this.pools;
        synchronized (vector) {
            Enumeration vEnum = this.pools.elements();
            while (vEnum.hasMoreElements()) {
                Pool p = (Pool)vEnum.nextElement();
                if (p.inactive) {
                    p.drain();
                    continue;
                }
                p.inactive = true;
            }
        }
        AlarmManager.create((long)PoolManager.getDrainInterval(), (AlarmListener)this, null);
    }

    void remove(Pool p) {
        this.pools.removeElement(p);
    }

    public static Pool create(int minimum, int maximum, PmiBean beanPerf, DiscardStrategy d) {
        Pool result = new Pool(minimum, maximum, d, poolMgr, beanPerf);
        PoolManager.poolMgr.pools.addElement(result);
        return result;
    }
}

