/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.opool;

import com.ibm.ejs.util.opool.DiscardStrategy;
import com.ibm.ejs.util.opool.PoolManager;
import com.ibm.websphere.pmi.PmiBean;

public class Pool {
    int minimum;
    int maximum;
    private Object[] elements;
    private int topOfPool;
    boolean inactive;
    DiscardStrategy discardStrategy;
    PoolManager poolMgr;
    private int maxDrainAmount;
    private PmiBean beanPerf = null;

    Pool(int minimum, int maximum, DiscardStrategy d, PoolManager poolMgr, PmiBean beanPerf) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.elements = new Object[maximum];
        this.topOfPool = 0;
        this.inactive = false;
        this.discardStrategy = d;
        this.poolMgr = poolMgr;
        this.beanPerf = beanPerf;
        int drainOpportunity = maximum - minimum;
        this.maxDrainAmount = drainOpportunity <= 0 ? 0 : (drainOpportunity <= 5 ? drainOpportunity : drainOpportunity / 5);
        if (beanPerf != null) {
            beanPerf.poolCreated(this.topOfPool);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get() {
        this.inactive = false;
        Object[] objectArray = this.elements;
        synchronized (this.elements) {
            Object obj;
            if (this.topOfPool > 0) {
                --this.topOfPool;
                obj = this.elements[this.topOfPool];
                this.elements[this.topOfPool] = null;
            } else {
                obj = null;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (this.beanPerf != null) {
                this.beanPerf.objectRetrieve(this.topOfPool, obj != null);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object o) {
        boolean discarded = false;
        Object[] objectArray = this.elements;
        synchronized (this.elements) {
            if (this.topOfPool < this.maximum) {
                this.elements[this.topOfPool] = o;
                ++this.topOfPool;
            } else {
                discarded = true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (discarded) {
                this.discardStrategy.discard(o);
            }
            if (this.beanPerf != null) {
                this.beanPerf.objectReturn(this.topOfPool, discarded);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void drain() {
        int numDiscarded = 0;
        Object o = null;
        while (this.inactive && this.topOfPool > this.minimum && numDiscarded < this.maxDrainAmount) {
            o = null;
            Object[] objectArray = this.elements;
            // MONITORENTER : this.elements
            int numElements = this.topOfPool--;
            if (numElements > 0 && numElements > this.minimum) {
                o = this.elements[this.topOfPool];
                this.elements[this.topOfPool] = null;
                ++numDiscarded;
            }
            // MONITOREXIT : objectArray
            if (o == null) continue;
            this.discardStrategy.discard(o);
        }
        if (this.beanPerf == null) return;
        this.beanPerf.poolDrained(this.topOfPool, numDiscarded);
    }

    public void destroy() {
        this.poolMgr.remove(this);
        this.minimum = 0;
        this.maxDrainAmount = this.maximum;
        this.inactive = true;
        this.drain();
    }

    public void discard() {
        this.poolMgr.remove(this);
        this.minimum = 0;
        this.maximum = 0;
    }
}

