/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.utilities;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class UtilsReflection {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String defaultFieldToDelete = "serialVersionUID";

    public static final boolean compareMethods(Method method1, Method method2) {
        Class<?>[] parms2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] parms1 = method1.getParameterTypes();
        int num = parms1.length;
        if (num != (parms2 = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < num; ++i) {
            if (parms1[i] == parms2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean compareMethodsWithoutName(Method method1, Method method2) {
        Class<?>[] parms2;
        if (method1 == null || method2 == null) {
            return false;
        }
        Class<?>[] parms1 = method1.getParameterTypes();
        int num = parms1.length;
        if (num != (parms2 = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < num; ++i) {
            if (parms1[i] == parms2[i]) continue;
            return false;
        }
        return true;
    }

    public static final String getClassDisplayName(Class clazz) {
        Class<?> tmpClass = clazz;
        String trailer = "";
        while (tmpClass.isArray()) {
            trailer = trailer + "[]";
            tmpClass = tmpClass.getComponentType();
        }
        return tmpClass.getName() + trailer;
    }

    public static final String getClassShortName(Class clazz) {
        String name = UtilsReflection.getClassDisplayName(clazz);
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            try {
                name = name.substring(lastDot + 1);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return name;
    }

    public static final String getConstructorDisplayString(Constructor constr) {
        Class<?>[] parms = constr.getParameterTypes();
        Class decl = constr.getDeclaringClass();
        String result = UtilsReflection.getClassShortName(decl) + "(";
        for (int i = 0; i < parms.length; ++i) {
            result = result + UtilsReflection.getClassShortName(parms[i]);
            if (i >= parms.length - 1) continue;
            result = result + ", ";
        }
        result = result + ")";
        return result;
    }

    public static final Method[] getMatchingMethods(Class class1, Class class2) {
        int i;
        Method[] methods1 = class1.getDeclaredMethods();
        int tempIndex = 0;
        int num = methods1.length;
        Method[] tempMethods = new Method[num];
        for (i = 0; i < num; ++i) {
            Method method;
            try {
                method = class2.getDeclaredMethod(methods1[i].getName(), methods1[i].getParameterTypes());
            }
            catch (NoSuchMethodException noMeth) {
                continue;
            }
            catch (SecurityException sec) {
                continue;
            }
            if (!UtilsReflection.compareMethods(methods1[i], method)) continue;
            tempMethods[tempIndex++] = method;
        }
        Method[] result = new Method[tempIndex];
        for (i = 0; i < tempIndex; ++i) {
            result[i] = tempMethods[i];
        }
        return result;
    }

    public static final String getMethodDisplayString(Method method) {
        Class<?>[] parms = method.getParameterTypes();
        String result = method.getName() + "(";
        for (int i = 0; i < parms.length; ++i) {
            result = result + UtilsReflection.getClassShortName(parms[i]);
            if (i >= parms.length - 1) continue;
            result = result + ", ";
        }
        result = result + ")";
        return result;
    }

    public static final Method[] getMethods(Class start, Class end) {
        int i;
        Vector<Method> methodsVector = new Vector<Method>();
        Method[] tempMethods = end.getMethods();
        int len = tempMethods.length;
        if (end == null || end == Object.class || !start.isAssignableFrom(end)) {
            return tempMethods;
        }
        for (i = 0; i < len; ++i) {
            Method currentMethod = tempMethods[i];
            Class<?> declaring = currentMethod.getDeclaringClass();
            if (declaring.isAssignableFrom(start)) continue;
            methodsVector.addElement(currentMethod);
        }
        tempMethods = new Method[methodsVector.size()];
        for (i = 0; i < tempMethods.length; ++i) {
            tempMethods[i] = (Method)methodsVector.elementAt(i);
        }
        return tempMethods;
    }

    public static final String getMethodSelector(Method method) {
        StringBuffer buff = new StringBuffer();
        buff.append(method.getReturnType().getName());
        buff.append(" ");
        buff.append(method.getName());
        buff.append("(");
        Class<?>[] parms = method.getParameterTypes();
        for (int i = 0; i < parms.length; ++i) {
            buff.append(parms[i].getName());
            if (i >= parms.length - 1) continue;
            buff.append(",");
        }
        buff.append(")");
        return buff.toString();
    }

    public static final Method[] getPublicMemberMethods(Class aClass) {
        Vector<Method> methodsVector = new Vector<Method>();
        for (Method currentMethod : aClass.getDeclaredMethods()) {
            int modifier = currentMethod.getModifiers();
            if (!Modifier.isPublic(modifier) || Modifier.isStatic(modifier)) continue;
            methodsVector.addElement(currentMethod);
        }
        Method[] tempMethods = new Method[methodsVector.size()];
        for (int i = 0; i < tempMethods.length; ++i) {
            tempMethods[i] = (Method)methodsVector.elementAt(i);
        }
        return tempMethods;
    }

    public static final boolean isWrapper(Class aClass) {
        if (aClass == Integer.class) {
            return true;
        }
        if (aClass == String.class) {
            return true;
        }
        if (aClass == Boolean.class) {
            return true;
        }
        if (aClass == Character.class) {
            return true;
        }
        if (aClass == Byte.class) {
            return true;
        }
        if (aClass == Short.class) {
            return true;
        }
        if (aClass == Long.class) {
            return true;
        }
        if (aClass == Float.class) {
            return true;
        }
        if (aClass == Double.class) {
            return true;
        }
        return aClass == Void.class;
    }

    public static final Field[] stripField(Field[] fields) {
        return UtilsReflection.stripField(fields, defaultFieldToDelete);
    }

    public static final Field[] stripField(Field[] fields, String fieldToDelete) {
        int pos = -1;
        Field[] dest = null;
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(fieldToDelete)) continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return fields;
        }
        dest = new Field[fields.length - 1];
        System.arraycopy(fields, 0, dest, 0, pos);
        System.arraycopy(fields, pos + 1, dest, pos, fields.length - (pos + 1));
        return dest;
    }
}

