/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.deploywrapper;

import com.ibm.ejs.container.util.NameUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ejs.util.deployment.deploywrapper.DeployOptions;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.ModuleFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.ejbdeploy.Database;
import com.ibm.etools.ejbdeploy.EJBDeploy;
import com.ibm.etools.ejbdeploy.EJBDeploymentException;
import com.ibm.etools.ejbdeploy.IStatusMonitor;
import com.ibm.etools.ejbdeploy.Options;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

public class DeployUtil {
    private static TraceComponent tc = Tr.register(DeployUtil.class);
    private static NLS messagesNLS = new NLS("messages");

    protected static String getMessage(String key, String defaultMessage) {
        return messagesNLS.getString(key, defaultMessage);
    }

    protected static String getMessage(String key, Object arg, String defaultMessage) {
        return messagesNLS.getFormattedMessage(key, new Object[]{arg}, defaultMessage);
    }

    protected static void statusMessage(IStatusMonitor statusMonitor, String key, Object arg, String defaultMessage) {
        statusMonitor.taskMessage(DeployUtil.getMessage(key, arg, defaultMessage));
    }

    public static void deploy(Archive archive, DeployOptions options, IStatusMonitor statusMonitor) throws EJBDeploymentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deploy", archive + "," + options);
        }
        String expandedDir = null;
        try {
            String workingDirectory = options.getWorkingDirectory();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "workingDirectory:" + workingDirectory);
            }
            EJBDeploy deployer = new EJBDeploy(workingDirectory);
            options.setInputModuleName(archive.getURI());
            DeployUtil.deployModule(deployer, (ModuleFile)archive, options, statusMonitor);
        }
        catch (EJBDeploymentException ex) {
            throw ex;
        }
        catch (Exception ex2) {
            String message = DeployUtil.getMessage("deployexception.ExceptionThrownDuringDeployment", "exception is thrown during deployment process");
            throw new EJBDeploymentException(message, (Throwable)ex2, false);
        }
        finally {
            if (expandedDir != null) {
                DeployUtil.deleteAll(expandedDir);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deploy");
            }
        }
    }

    public static void deploy(String archiveURL, DeployOptions options, IStatusMonitor statusMonitor) throws EJBDeploymentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deploy", archiveURL + ',' + options);
        }
        Archive archive = null;
        try {
            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
            archive = factory.openArchive(archiveURL);
        }
        catch (Exception ex) {
            String message = DeployUtil.getMessage("deployexception.UnableToOpenArchive", "Unable to open the archive file");
            throw new EJBDeploymentException(message, (Throwable)ex, false);
        }
        DeployUtil.deploy(archive, options, statusMonitor);
        archive.close();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deploy");
        }
    }

    public static boolean isDeployed(String fileName) throws EJBDeploymentException {
        Archive file;
        try {
            CommonarchiveFactory factory = CommonarchiveFactoryImpl.getActiveFactory();
            file = factory.openArchive(fileName);
        }
        catch (Exception ex) {
            String message = DeployUtil.getMessage("deployexception.CannotOpenArchive", fileName, "Cannot open archive file: {0}");
            throw new EJBDeploymentException(message, (Throwable)ex, false);
        }
        if (file instanceof EJBJarFile) {
            boolean deployed = DeployUtil.isEJBJarDeployed((EJBJarFile)file);
            ((EJBJarFile)file).close();
            return deployed;
        }
        if (file instanceof EARFile) {
            boolean deployed = true;
            List jars = ((EARFile)file).getEJBJarFiles();
            for (int jarNo = 0; deployed && jarNo < jars.size(); ++jarNo) {
                EJBJarFile ejbJar = (EJBJarFile)jars.get(jarNo);
                deployed = DeployUtil.isEJBJarDeployed(ejbJar);
            }
            ((EARFile)file).close();
            return deployed;
        }
        return false;
    }

    public static boolean isEJBJarDeployed(EJBJarFile ejbJarFile) {
        EJBJar ejbJar = ejbJarFile.getDeploymentDescriptor();
        Iterator ejbs = ejbJar.getEnterpriseBeans().iterator();
        boolean deployed = true;
        while (deployed && ejbs.hasNext()) {
            EnterpriseBean ejb = (EnterpriseBean)ejbs.next();
            if (ejb.isMessageDriven()) continue;
            String interfaceName = NameUtil.getRemoteImplClassName(ejb, ejbJar.getVersionID() >= 20);
            if (interfaceName == null) {
                interfaceName = NameUtil.getLocalImplClassName(ejb, ejbJar.getVersionID() >= 20);
            }
            if (interfaceName != null) {
                interfaceName = interfaceName.replace('.', '/') + ".class";
                deployed = ejbJarFile.containsFile(interfaceName);
                continue;
            }
            System.out.println("EJB is not an MDB but the remote and local interfaces are null. This should not happen");
        }
        return deployed;
    }

    private static void deployModule(final EJBDeploy deployer, ModuleFile module, DeployOptions options, final IStatusMonitor statusMonitor) throws EJBDeploymentException {
        Properties sysProps;
        String itp_loc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deployModule", module);
        }
        if (module instanceof EJBJarFile) {
            EJBJar dd = ((EJBJarFile)module).getDeploymentDescriptor();
            String clientJar = dd.getEjbClientJar();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "clientJar:" + clientJar);
            }
            options.setClientJarName(clientJar);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "options:" + options);
        }
        if ((itp_loc = (String)(sysProps = System.getProperties()).get("com.ibm.itp.location")) == null || itp_loc.equals("")) {
            String message = DeployUtil.getMessage("deployexception.com.ibm.itp.locationNotSet", "com.ibm.itp.location needs to be set");
            throw new EJBDeploymentException(message, new Throwable(), false);
        }
        final Options newOptions = DeployUtil.convert(options);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling deployer.execute() in doPrivileged()");
                    }
                    deployer.execute(newOptions, statusMonitor, itp_loc);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (EJBDeploymentException)((Object)pae.getException());
        }
    }

    private static Options convert(DeployOptions options) throws EJBDeploymentException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "convert", options);
        }
        Options newOptions = new Options();
        if (options.getClasspath() != null) {
            newOptions.setClasspath(options.getClasspath());
        }
        newOptions.setCodegenOnly(options.isCodegenOnly());
        if (options.getDeployedModuleName() != null) {
            newOptions.setDeployedModuleName(options.getDeployedModuleName());
        }
        if (options.getInputModuleName() != null) {
            newOptions.setInputModuleName(options.getInputModuleName());
        }
        newOptions.setValidation(options.isValidation());
        newOptions.setRMICOptions(options.getRMICOptions());
        newOptions.setDatabaseVendor(DeployUtil.convertToDatabase(options.getDatabaseType()));
        newOptions.setDatabaseName(options.getDatabaseName());
        newOptions.setDatabaseSchemaName(options.getSchemaName());
        newOptions.setComplianceLevel(options.getComplianceLevel());
        newOptions.setSQLJGeneration(options.isSQLJDeploy());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "newOptions:" + newOptions);
        }
        return newOptions;
    }

    private static Database convertToDatabase(String dbType) {
        Database vendor = null;
        if (dbType == null) {
            return vendor;
        }
        if (dbType.equals("DB2UDB_V81")) {
            vendor = Database.DB2UDB_V81;
        } else if (dbType.equals("DB2UDB_V82")) {
            vendor = Database.DB2UDB_V82;
        } else if (dbType.equals("DB2UDB_V91")) {
            vendor = Database.DB2UDB_V91;
        } else if (dbType.equals("DB2UDB_V95")) {
            vendor = Database.DB2UDB_V95;
        } else if (dbType.equals("DB2UDBOS390_V8")) {
            vendor = Database.DB2UDBOS390_V8;
        } else if (dbType.equals("DB2UDBOS390_NEWFN_V8")) {
            vendor = Database.DB2UDBOS390_NEWFN_V8;
        } else if (dbType.equals("DB2UDBOS390_V9")) {
            vendor = Database.DB2UDBOS390_V9;
        } else if (dbType.equals("DB2UDBISERIES_V53")) {
            vendor = Database.DB2UDBISERIES_V53;
        } else if (dbType.equals("DB2UDBISERIES_V54")) {
            vendor = Database.DB2UDBISERIES_V54;
        } else if (dbType.equals("DERBY_V10")) {
            vendor = Database.DERBY_V10;
        } else if (dbType.equals("DERBY_V101")) {
            vendor = Database.DERBY_V101;
        } else if (dbType.equals("INFORMIX_V100")) {
            vendor = Database.INFORMIX_V10;
        } else if (dbType.equals("INFORMIX_V110")) {
            vendor = Database.INFORMIX_V110;
        } else if (dbType.equals("MSSQLSERVER_2005")) {
            vendor = Database.MSSQLSERVER_2005;
        } else if (dbType.equals("ORACLE_V10G")) {
            vendor = Database.ORACLE_V10G;
        } else if (dbType.equals("ORACLE_V11G")) {
            vendor = Database.ORACLE_V11G;
        } else if (dbType.equals("SYBASE_V1250")) {
            vendor = Database.SYBASE_V1250;
        } else if (dbType.equals("SYBASE_V15")) {
            vendor = Database.SYBASE_V15;
        }
        return vendor;
    }

    private static void deleteAll(String target) {
        File targetFile = new File(target);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAll", targetFile.getAbsolutePath());
        }
        if (targetFile.exists()) {
            if (!targetFile.isFile()) {
                String[] subTargets = targetFile.list();
                for (int subNo = 0; subNo < subTargets.length; ++subNo) {
                    DeployUtil.deleteAll(target + File.separator + subTargets[subNo]);
                }
            }
            if (!targetFile.delete()) {
                // empty if block
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAll");
        }
    }

    private static File renameSource(String name) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "renameSource", name);
        }
        StringBuffer newName = new StringBuffer();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            newName.append(name.substring(0, index));
            newName.append("_source");
            newName.append(name.substring(index));
        } else {
            newName.append(name).append("_source");
        }
        File file = new File(name);
        File newFile = new File(newName.toString());
        file.renameTo(newFile);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "renameSource", newFile);
        }
        return newFile;
    }
}

