/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.cache.Bucket;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.IllegalOperationException;
import java.util.HashMap;

public final class WrapperBucket
implements Bucket {
    private static final TraceComponent tc = Tr.register(WrapperBucket.class, "EJBCache", "com.ibm.ejs.container.container");
    private static final int DEFAULT_BUCKET_SIZE = 3;
    public final Cache ivWrapperCache;
    private HashMap<Object, EJSWrapperCommon> ivWrappers = null;
    private long hitCount = 0L;

    WrapperBucket(Cache cache) {
        this.ivWrapperCache = cache;
    }

    public Element findByKey(Object key) {
        Element element = null;
        if (this.ivWrappers != null && (element = (Element)this.ivWrappers.get(key)) != null) {
            ++this.hitCount;
        }
        return element;
    }

    public Element insertByKey(Object key, Object object) {
        EJSWrapperCommon duplicate;
        EJSWrapperCommon element = (EJSWrapperCommon)object;
        if (this.ivWrappers == null) {
            this.ivWrappers = new HashMap(3);
        }
        if ((duplicate = this.ivWrappers.put(key, element)) != null) {
            if (duplicate == element) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "insertByKey : same object again : " + object);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "insertByKey : attempt to insert duplicate : " + key + " : " + object + " : " + duplicate);
                }
                throw new IllegalArgumentException("Attempt to insert duplicate element into EJB Wrapper Cache");
            }
        }
        element.ivWrapperCacheBucket = this;
        element.pinned = 0;
        ++this.hitCount;
        return element;
    }

    public Element discardByKey(Object key) {
        EJSWrapperCommon element;
        EJSWrapperCommon eJSWrapperCommon = element = this.ivWrappers != null ? this.ivWrappers.get(key) : null;
        if (element != null) {
            if (element.pinned > 0) {
                return null;
            }
            this.remove(key);
            ++this.hitCount;
        }
        return element;
    }

    public Element removeByKey(Object key) {
        return this.removeByKey(key, false);
    }

    public Element removeByKey(Object key, boolean dropRef) {
        EJSWrapperCommon element;
        EJSWrapperCommon eJSWrapperCommon = element = this.ivWrappers != null ? this.ivWrappers.get(key) : null;
        if (element != null) {
            if (!dropRef && element.pinned > 0 || dropRef && element.pinned > 1) {
                throw new IllegalOperationException(key, element.pinned);
            }
            this.remove(key);
            ++this.hitCount;
        }
        return element;
    }

    public boolean isEmpty() {
        return this.ivWrappers == null || this.ivWrappers.isEmpty();
    }

    public int size() {
        return this.ivWrappers != null ? this.ivWrappers.size() : 0;
    }

    public Object[] toArray(Object[] array) {
        if (this.ivWrappers != null) {
            return this.ivWrappers.values().toArray(array);
        }
        if (array != null && array.length > 0) {
            array[0] = null;
        }
        return array;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    private EJSWrapperCommon remove(Object key) {
        EJSWrapperCommon removed = this.ivWrappers.remove(key);
        removed.pinned = -1;
        return removed;
    }
}

