/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.MessageEvent6;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class WrappingFileOutputStream
extends OutputStream {
    private static final TraceComponent svTc = Tr.register(WrappingFileOutputStream.class, null, "com.ibm.ejs.resources.RasMessages");
    private static Timer svTimer = null;
    private static final String svSepChar = "_";
    private boolean ivSizeRollover = false;
    private boolean ivTimeRollover = false;
    private long ivMaxFileSize;
    private long ivCurFileSize = 0L;
    private int ivBaseTime;
    private int ivRolloverPeriod;
    private String ivMainFileName = null;
    private File ivMainFile = null;
    private String ivDirectory = null;
    private String ivNamePrefix = null;
    private String ivNameSuffix = null;
    private String ivBackupFilePrefix = null;
    private int ivMaxBackups;
    private String[] ivBackupFiles = null;
    private String ivPreviousTime = "";
    private SimpleDateFormat ivDateFormatter = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
    private FileOutputStream ivFileStream = null;
    private LogRolloverListener ivLRL = null;

    private static synchronized Timer getTimer() {
        if (svTimer == null) {
            svTimer = new Timer(true);
        }
        return svTimer;
    }

    public WrappingFileOutputStream(String fileName, int maxBackups) throws RasException, IOException {
        this(fileName, 0, maxBackups, 0x1400000L, 24, 24);
    }

    public WrappingFileOutputStream(String fileName, int maxBackups, long rolloverSize) throws RasException, IOException {
        this(fileName, 1, maxBackups, rolloverSize, 24, 24);
    }

    public WrappingFileOutputStream(String fileName, int maxBackups, int baseHour, int rolloverPeriod) throws RasException, IOException {
        this(fileName, 2, maxBackups, 0x1400000L, baseHour, rolloverPeriod);
    }

    public WrappingFileOutputStream(String fileName, int rolloverType, int maxBackups, long rolloverSize, int baseHour, int rolloverPeriod) throws RasException, IOException {
        this.ivMainFileName = fileName;
        this.ivMainFile = new File(fileName);
        this.ivMaxFileSize = rolloverSize < 1L ? 0x1400000L : rolloverSize;
        this.ivMaxBackups = maxBackups < 1 ? 1 : maxBackups;
        this.ivBaseTime = baseHour < 1 || baseHour > 24 ? 0 : baseHour - 1;
        this.ivRolloverPeriod = rolloverPeriod < 1 || rolloverPeriod > 24 ? 24 : rolloverPeriod;
        this.ivBackupFiles = new String[this.ivMaxBackups];
        this.doBasicRolloverSetup();
        if (rolloverType != 0) {
            this.doCommonRolloverSetup();
            if ((rolloverType & 1) != 0) {
                this.doSizeBasedRolloverSetup();
            }
            if ((rolloverType & 2) != 0) {
                try {
                    this.doTimeBasedRolloverSetup();
                }
                catch (RasException re) {
                    this.forceSizeBasedRollover(re);
                }
            }
        }
        this.ivFileStream = RasHelper.createFileOutputStream(this.ivMainFileName, true);
    }

    public synchronized void write(int b) throws IOException {
        if (this.ivSizeRollover) {
            this.incrementCount(1);
        }
        this.ivFileStream.write(b);
    }

    public synchronized void write(byte[] bytes) throws IOException {
        if (this.ivSizeRollover) {
            this.incrementCount(bytes.length);
        }
        this.ivFileStream.write(bytes);
    }

    public synchronized void write(byte[] bytes, int offset, int len) throws IOException {
        if (this.ivSizeRollover) {
            this.incrementCount(len);
        }
        this.ivFileStream.write(bytes, offset, len);
    }

    public synchronized void flush() throws IOException {
        this.ivFileStream.flush();
    }

    public synchronized void close() throws IOException {
        this.ivFileStream.close();
    }

    public synchronized void addRolloverListener(LogRolloverListener lrl) {
        this.ivLRL = lrl;
    }

    String rolloverImmediate(String fileName) throws IOException {
        if (fileName == null) {
            return this.switchFiles();
        }
        return this.switchFiles(fileName);
    }

    void rolloverImmediate() throws RasException {
        try {
            this.switchFiles();
        }
        catch (IOException ioe) {
            throw new RasException("Request to roll log file " + this.ivMainFileName + " failed", ioe);
        }
        try {
            this.scheduleTimeBasedRollover();
        }
        catch (RasException re) {
            this.forceSizeBasedRollover(re);
        }
    }

    private void incrementCount(int count) throws IOException {
        this.ivCurFileSize += (long)count;
        if (this.ivCurFileSize >= this.ivMaxFileSize) {
            long fileLength = RasHelper.getFileLength(this.ivMainFile);
            if (fileLength >= this.ivMaxFileSize) {
                this.switchFiles();
                this.ivCurFileSize = count;
            } else {
                this.ivCurFileSize = fileLength + (long)count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String switchFiles() throws IOException {
        Class<Tr> clazz = Tr.class;
        synchronized (Tr.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.switchFiles2();
        }
    }

    private synchronized String switchFiles2() throws IOException {
        this.ivFileStream.flush();
        this.ivFileStream.close();
        try {
            String backupFileName = null;
            File backup = null;
            boolean exists = true;
            for (int counter = 0; exists && counter < 3; ++counter) {
                String ts = this.generateTimeStampQualifier();
                backupFileName = this.ivBackupFilePrefix + ts + this.ivNameSuffix;
                backup = new File(backupFileName);
                exists = RasHelper.fileExists(backup);
            }
            if (exists) {
                return null;
            }
            return this.switchFiles(backupFileName);
        }
        catch (Throwable t) {
            Object[] parms = new Object[]{this.ivMainFileName, t};
            MessageEvent6 me = new MessageEvent6(4, svTc, "archiveCurrentFile", "MSG_ROLLOVER_FAILED_EXCEPTION", parms);
            Tr.queueInternalEvent(me);
            return null;
        }
    }

    private synchronized String switchFiles(String fileName) throws IOException {
        this.ivFileStream.flush();
        this.ivFileStream.close();
        File backup = new File(fileName);
        if (RasHelper.fileExists(backup)) {
            throw new IOException("file " + fileName + " already exists");
        }
        boolean renameSucceeded = RasHelper.renameFile(this.ivMainFile, backup);
        boolean append = true;
        IOException rolloverException = null;
        if (!renameSucceeded) {
            Object[] parms = new Object[]{this.ivMainFileName, fileName};
            MessageEvent6 me = new MessageEvent6(10, svTc, "switchFiles", "MSG_ROLLOVER_RENAME_FAILED", parms);
            Tr.queueInternalEvent(me);
            try {
                RasHelper.copyFile(this.ivMainFile, backup);
                append = false;
            }
            catch (IOException ex) {
                rolloverException = ex;
            }
        }
        this.ivCurFileSize = 0L;
        try {
            this.ivFileStream = RasHelper.createFileOutputStream(this.ivMainFileName, append);
            if (this.ivLRL != null) {
                this.ivLRL.logRolled();
            }
        }
        catch (RasException re) {
            throw new IOException("Unable to open log file " + this.ivMainFileName);
        }
        if (rolloverException != null) {
            throw rolloverException;
        }
        int lastIndex = this.ivBackupFiles.length - 1;
        String oldName = this.ivBackupFiles[lastIndex];
        if (oldName != null) {
            RasHelper.deleteFile(new File(oldName));
        }
        int i = lastIndex;
        int j = lastIndex - 1;
        while (i > 0) {
            this.ivBackupFiles[i] = this.ivBackupFiles[j];
            --i;
            --j;
        }
        this.ivBackupFiles[0] = fileName;
        return fileName;
    }

    private String generateTimeStampQualifier() {
        Date date = new Date(System.currentTimeMillis());
        String current = this.ivDateFormatter.format(date);
        int maxTries = 20;
        while (current.equals(this.ivPreviousTime)) {
            if (--maxTries <= 0) {
                return current;
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            date = new Date(System.currentTimeMillis());
            current = this.ivDateFormatter.format(date);
        }
        this.ivPreviousTime = current;
        return current;
    }

    private void scheduleTimeBasedRollover() throws RasException {
        try {
            Calendar cal = Calendar.getInstance();
            int curHours = cal.get(11);
            if (this.ivBaseTime > curHours) {
                cal.add(5, -1);
            }
            cal.set(11, this.ivBaseTime);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            Date baseDate = cal.getTime();
            Calendar current = Calendar.getInstance();
            while (cal.before(current)) {
                cal.add(11, this.ivRolloverPeriod);
            }
            if (cal.equals(current)) {
                cal.add(11, this.ivRolloverPeriod);
            }
            Date rollover = cal.getTime();
            Timer timer = WrappingFileOutputStream.getTimer();
            WrappingFileRoller wfr = new WrappingFileRoller(this);
            timer.schedule((TimerTask)wfr, rollover);
        }
        catch (Throwable t) {
            throw new RasException("Scheduling a timer rollover event failed", t);
        }
    }

    private void forceSizeBasedRollover(RasException re) {
        if (!this.ivSizeRollover) {
            this.ivSizeRollover = true;
            boolean exists = RasHelper.fileExists(this.ivMainFile);
            this.ivCurFileSize = !exists ? 0L : RasHelper.getFileLength(this.ivMainFile);
        }
        Object[] parms = new Object[]{this.ivMainFileName, re};
        MessageEvent6 me = new MessageEvent6(4, svTc, "forceSizeBasedRollover", "MSG_SCHEDULE_TIME_ROLLOVER_FAILED", parms);
        Tr.queueInternalEvent(me);
    }

    private void doBasicRolloverSetup() throws RasException {
        int index = this.ivMainFileName.lastIndexOf(File.separator);
        if (index == -1) {
            throw new RasException(this.ivMainFileName + " does not contain a path separator character");
        }
        this.ivDirectory = this.ivMainFileName.substring(0, index);
        String fName = this.ivMainFileName.substring(index + 1, this.ivMainFileName.length());
        if (fName == null || fName.equals("")) {
            throw new RasException(this.ivMainFileName + " is not a proper fully qualified file name");
        }
        index = fName.lastIndexOf(46);
        if (index == -1) {
            this.ivNamePrefix = fName;
            this.ivNameSuffix = null;
        } else {
            this.ivNamePrefix = fName.substring(0, index);
            this.ivNameSuffix = fName.substring(index, fName.length());
        }
        this.ivBackupFilePrefix = this.ivDirectory + File.separator + this.ivNamePrefix + svSepChar;
    }

    private void doCommonRolloverSetup() {
        this.generateBackupFileList();
    }

    private void doSizeBasedRolloverSetup() {
        this.ivSizeRollover = true;
        boolean exists = RasHelper.fileExists(this.ivMainFile);
        this.ivCurFileSize = !exists ? 0L : RasHelper.getFileLength(this.ivMainFile);
    }

    private void doTimeBasedRolloverSetup() throws RasException {
        this.ivTimeRollover = true;
        try {
            this.scheduleTimeBasedRollover();
        }
        catch (RasException re) {
            this.scheduleTimeBasedRollover();
        }
    }

    private void generateBackupFileList() {
        try {
            for (int i = 0; i < this.ivMaxBackups; ++i) {
                this.ivBackupFiles[i] = null;
            }
            String[] files = RasHelper.listFileNames(new File(this.ivDirectory));
            if (files == null || files.length == 0) {
                return;
            }
            String dir = this.ivDirectory + File.separator;
            int size = files.length;
            Vector<String> fileNames = new Vector<String>(size);
            Vector<Long> timestamps = new Vector<Long>(size);
            int arrayIndex = 0;
            for (int i = 0; i < size; ++i) {
                long time;
                File candidate;
                String fqFileName = dir + files[i];
                if (!fqFileName.startsWith(this.ivBackupFilePrefix) || !RasHelper.isFile(candidate = new File(fqFileName)) || (time = this.getFileTimestamp(files[i])) == 0L) continue;
                fileNames.addElement(fqFileName);
                timestamps.addElement(new Long(time));
                ++arrayIndex;
            }
            if (!fileNames.isEmpty()) {
                this.sortAndDeleteFiles(fileNames, timestamps);
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private long getFileTimestamp(String fileName) {
        long retValue = 0L;
        String time = null;
        try {
            if (fileName.startsWith(this.ivNamePrefix)) {
                time = fileName.substring(this.ivNamePrefix.length() + 1);
                if (this.ivNameSuffix != null) {
                    if (time.endsWith(this.ivNameSuffix)) {
                        time = time.substring(0, time.length() - this.ivNameSuffix.length());
                    } else {
                        return retValue;
                    }
                }
                Date date = this.ivDateFormatter.parse(time);
                retValue = date.getTime();
            }
            return retValue;
        }
        catch (Throwable t) {
            return retValue;
        }
    }

    private void sortAndDeleteFiles(Vector fileNameVector, Vector timestampsVector) {
        String[] fileNames = null;
        try {
            int i;
            int size = fileNameVector.size();
            fileNames = new String[size];
            long[] timestamps = new long[size];
            for (int i2 = 0; i2 < size; ++i2) {
                fileNames[i2] = (String)fileNameVector.elementAt(i2);
                timestamps[i2] = (Long)timestampsVector.elementAt(i2);
            }
            int length = fileNames.length;
            boolean changed = true;
            while (changed) {
                changed = false;
                i = 0;
                for (int j = 1; j < length; ++j) {
                    if (timestamps[i] < timestamps[j]) {
                        long temp = timestamps[i];
                        String tempS = fileNames[i];
                        timestamps[i] = timestamps[j];
                        timestamps[j] = temp;
                        fileNames[i] = fileNames[j];
                        fileNames[j] = tempS;
                        changed = true;
                    }
                    ++i;
                }
            }
            if (length <= this.ivMaxBackups) {
                System.arraycopy(fileNames, 0, this.ivBackupFiles, 0, length);
            } else {
                System.arraycopy(fileNames, 0, this.ivBackupFiles, 0, this.ivMaxBackups);
                for (i = this.ivMaxBackups; i < length; ++i) {
                    if (fileNames[i] == null) continue;
                    RasHelper.deleteFile(new File(fileNames[i]));
                }
            }
            return;
        }
        catch (Throwable t) {
            return;
        }
    }

    String[] getBackupFileList() {
        if (this.ivBackupFiles == null || this.ivBackupFiles.length == 0) {
            return null;
        }
        int len = this.ivBackupFiles.length;
        String[] copy = new String[len];
        for (int i = 0; i < len; ++i) {
            copy[i] = this.ivBackupFiles[i];
        }
        return copy;
    }

    public synchronized long getCurrentFileSize() {
        return this.ivCurFileSize;
    }

    class WrappingFileRoller
    extends TimerTask {
        private WrappingFileOutputStream ivFile;

        WrappingFileRoller(WrappingFileOutputStream file) {
            this.ivFile = file;
        }

        public void run() {
            try {
                this.ivFile.rolloverImmediate();
            }
            catch (RasException rasException) {
                // empty catch block
            }
        }
    }
}

