/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.BundleResolver;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.logging.MessageConverter;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class TraceNLS {
    private static TraceComponent tc = Tr.register(TraceNLS.class);
    private static final String nullKey = "null Key";
    private static final String svNullBundleName = "Resource Bundle name is null, key = {0}";
    private static final String svBundleNotLoaded = "Unable to load ResourceBundle {0}";
    private static final String svNullKeyMessage = "Null key passed while using ResourceBundle {0}";
    private static final String svMalformedMessage = "No message text associated with key {0} in bundle {1}";
    private static boolean sbConvertMessageIds = false;
    private static final String svMessageIdPropertyName = "com.ibm.websphere.logging.messageId.version";
    private static BundleResolver svResolver;
    private String ivBundleName = null;

    public static TraceNLS getTraceNLS(String bundleName) {
        return new TraceNLS(bundleName);
    }

    private TraceNLS(String bundleName) {
        this.ivBundleName = bundleName;
    }

    public String getString(String key) {
        return TraceNLS.worker(null, this.ivBundleName, key, null, null, false, null, false);
    }

    public String getString(String key, String defaultString) {
        return TraceNLS.worker(null, this.ivBundleName, key, null, defaultString, false, null, false);
    }

    public String getFormattedMessage(String key, Object[] args, String defaultString) {
        return TraceNLS.worker(null, this.ivBundleName, key, args, defaultString, true, null, false);
    }

    public String getFormattedMessage(String key, Object[] args, String defaultString, boolean quiet) {
        return TraceNLS.worker(null, this.ivBundleName, key, args, defaultString, true, null, quiet);
    }

    public static String getStringFromBundle(String bundleName, String key) {
        return TraceNLS.worker(null, bundleName, key, null, null, false, null, false);
    }

    public static String getStringFromBundle(String bundleName, String key, String defaultString) {
        return TraceNLS.worker(null, bundleName, key, null, defaultString, false, null, false);
    }

    public static String getFormattedMessage(String bundleName, String key, Object[] args, String defaultString) {
        return TraceNLS.worker(null, bundleName, key, args, defaultString, true, null, false);
    }

    public static String getFormattedMessage(String bundleName, String key, Object[] args, String defaultString, boolean quiet) {
        return TraceNLS.worker(null, bundleName, key, args, defaultString, true, null, quiet);
    }

    public static String getStringFromBundle(String bundleName, String key, Locale locale) {
        return TraceNLS.worker(null, bundleName, key, null, null, false, locale, false);
    }

    public static String getStringFromBundle(String bundleName, String key, Locale locale, String defaultString) {
        return TraceNLS.worker(null, bundleName, key, null, defaultString, false, locale, false);
    }

    public static String getStringFromBundle(ResourceBundle bundle, String bundleName, String key, Locale locale) {
        return TraceNLS.worker(bundle, bundleName, key, null, null, false, locale, false);
    }

    public static String getStringFromBundle(ResourceBundle bundle, String bundleName, String key, Locale locale, String defaultString) {
        return TraceNLS.worker(bundle, bundleName, key, null, defaultString, false, locale, false);
    }

    public static String getFormattedMessage(String bundleName, String key, Locale locale, Object[] args, String defaultString) {
        return TraceNLS.worker(null, bundleName, key, args, defaultString, true, locale, false);
    }

    public static String getFormattedMessage(String bundleName, String key, Locale locale, Object[] args, String defaultString, boolean quiet) {
        return TraceNLS.worker(null, bundleName, key, args, defaultString, true, locale, quiet);
    }

    public static String getFormattedMessageFromLocalizedMessage(String localizedMessage, Object[] args, boolean quiet) {
        return TraceNLS.workerFormatLocalizedMessage(localizedMessage, args);
    }

    private static String worker(ResourceBundle bundle, String bundleName, String key, Object[] args, String defaultString, boolean format, Locale locale, boolean quiet) {
        String returnValue = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            if (bundle == null) {
                bundle = TraceNLS.getResourceBundle(bundleName, locale);
            }
            if ((returnValue = bundle.getString(key)).equals("")) {
                if (!quiet) {
                    Tr.debug(tc, MessageFormat.format(svMalformedMessage, key, bundleName));
                }
                returnValue = defaultString == null ? key : defaultString;
            } else if (sbConvertMessageIds) {
                returnValue = MessageConverter.convert(returnValue, MessageConverter.CONVERSION_TYPE_WASV5_TO_WASV6);
            }
            if (!format) {
                return returnValue;
            }
            return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
        }
        catch (RuntimeException re) {
            if (bundleName == null) {
                if (key == null && defaultString == null) {
                    if (!quiet) {
                        Tr.event(tc, MessageFormat.format(svNullBundleName, nullKey));
                    }
                    return MessageFormat.format(svNullBundleName, nullKey);
                }
                if (defaultString == null) {
                    if (!quiet) {
                        Tr.event(tc, MessageFormat.format(svNullBundleName, defaultString));
                    }
                    returnValue = key;
                } else {
                    if (!quiet) {
                        Tr.event(tc, MessageFormat.format(svNullBundleName, key));
                    }
                    returnValue = defaultString;
                }
                if (!format) {
                    return returnValue;
                }
                return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
            }
            if (bundle == null) {
                if (!quiet) {
                    Tr.event(tc, MessageFormat.format(svBundleNotLoaded, bundleName));
                }
                if (key == null && defaultString == null) {
                    return MessageFormat.format(svBundleNotLoaded, bundleName);
                }
                returnValue = defaultString == null ? key : defaultString;
                if (!format) {
                    return returnValue;
                }
                return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
            }
            if (key == null) {
                if (!quiet) {
                    Tr.event(tc, MessageFormat.format(svNullKeyMessage, bundleName));
                }
                if (defaultString == null) {
                    return MessageFormat.format(svNullKeyMessage, bundleName);
                }
                returnValue = defaultString;
                if (!format) {
                    return returnValue;
                }
                return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
            }
            if (!quiet) {
                Tr.event(tc, MessageFormat.format(svMalformedMessage, key, bundleName));
            }
            returnValue = defaultString == null ? key : defaultString;
            if (!format) {
                return returnValue;
            }
            return TraceNLS.workerFormatLocalizedMessage(returnValue, args);
        }
    }

    private static String workerFormatLocalizedMessage(String message, Object[] args) {
        if (args == null) {
            return message;
        }
        String formattedMessage = null;
        try {
            formattedMessage = MessageFormat.format(message, args);
        }
        catch (IllegalArgumentException e) {
            return message;
        }
        return formattedMessage;
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale) {
        ResourceBundle resourceBundle = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            if (svResolver != null) {
                resourceBundle = svResolver.resolve(bundleName, locale);
            }
        }
        catch (Exception e) {
            Tr.event(tc, "Exception resolving bundleName via svResolver.resolve: " + e.getMessage());
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(bundleName, locale);
            }
            catch (RuntimeException re) {
                Tr.event(tc, "Runtime exception from ResourceBundle.getBundle: " + re.getMessage());
            }
        }
        ClassLoader classLoader = null;
        if (resourceBundle == null) {
            try {
                classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Tr.event(tc, "Unable to get context class loader: " + e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
            resourceBundle = ResourceBundle.getBundle(bundleName, locale, classLoader);
        }
        return resourceBundle;
    }

    public static boolean isMessageIdConversionEnabled() {
        return sbConvertMessageIds;
    }

    static {
        String s = System.getProperty(svMessageIdPropertyName);
        sbConvertMessageIds = s != null && s.equals("6");
        try {
            Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
            Class<?> clazz = Class.forName("com.ibm.ejs.ras.BundleResolverImpl");
            svResolver = (BundleResolver)clazz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

