/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.LogRolloverListener;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasHeader;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.logging.LogRecord;

public class TraceLogger
implements WsHandler,
LogRolloverListener {
    private boolean ivBasicFormat;
    private ByteArrayOutputStream ivHeaderBaos;
    private PrintStream ivHeaderPs;
    private boolean ivAddCustomHeaderOutsideHeaderLine = false;
    private String ivCustomHeader;
    OutputStream ivOs;
    PrintStream ivOut;
    String ivCharEncoding = null;

    public TraceLogger(OutputStream stream) {
        this.ivOs = stream;
        this.ivOut = new PrintStream(stream, true);
        this.ivCharEncoding = null;
        this.ivHeaderBaos = new ByteArrayOutputStream();
        this.ivHeaderPs = new PrintStream(this.ivHeaderBaos, false);
    }

    public TraceLogger(OutputStream stream, String charEncoding) throws UnsupportedEncodingException {
        this.ivOs = stream;
        this.ivOut = new PrintStream(stream, true, charEncoding);
        this.ivCharEncoding = charEncoding;
        this.ivHeaderBaos = new ByteArrayOutputStream();
        this.ivHeaderPs = new PrintStream((OutputStream)this.ivHeaderBaos, false, charEncoding);
    }

    public TraceLogger(OutputStream stream, boolean isBasicFormat) {
        this(stream);
        this.ivBasicFormat = isBasicFormat;
    }

    public TraceLogger(OutputStream stream, boolean isBasicFormat, boolean addCustomHeaderOutsideHeaderLine, String customHeader) {
        this(stream, isBasicFormat);
        this.ivAddCustomHeaderOutsideHeaderLine = addCustomHeaderOutsideHeaderLine;
        this.ivCustomHeader = customHeader;
    }

    public TraceLogger(OutputStream stream, boolean isBasicFormat, String charEncoding) throws UnsupportedEncodingException {
        this(stream, charEncoding);
        this.ivBasicFormat = isBasicFormat;
    }

    public synchronized void logRolled() {
        this.printHeader();
    }

    public void processEvent(LogRecord event2) {
        if (event2 == null) {
            return;
        }
        WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(event2);
        if (wsLogRecord != null && wsLogRecord.getExtension("service_log_only") != null) {
            return;
        }
        this.doLog(event2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doLog(LogRecord event2) {
        String s = this.ivBasicFormat ? TraceLogFormatter.formatBasic(event2) : TraceLogFormatter.formatAdvanced(event2);
        TraceLogger traceLogger = this;
        synchronized (traceLogger) {
            this.ivOut.println(s);
        }
    }

    synchronized void printHeader() {
        String javaVersion;
        String verboseVersion;
        this.ivHeaderBaos.reset();
        this.ivHeaderPs.println("************ Start Display Current Environment ************");
        String version = RasHelper.getVersionId();
        if (version != null && !version.equals("")) {
            this.ivHeaderPs.println(MessageFormat.format(RasHeader.server, version, RasHelper.getServerName(), RasHelper.getProcessId()));
        }
        if ((verboseVersion = RasHelper.getVerboseVersion()) != null && !verboseVersion.equals("")) {
            this.ivHeaderPs.println(MessageFormat.format("Detailed IFix information: {0}", verboseVersion));
        }
        if ((javaVersion = RasHelper.getSystemProperty("java.fullversion")) == null) {
            javaVersion = RasHelper.getSystemProperty("java.version");
        }
        String a = RasHelper.getSystemProperty("os.name");
        String b = RasHelper.getSystemProperty("os.version");
        this.ivHeaderPs.println(MessageFormat.format("Host Operating System is {0}, version {1}", a, b));
        a = RasHelper.getSystemProperty("java.compiler");
        b = RasHelper.getSystemProperty("java.vm.name");
        this.ivHeaderPs.println(MessageFormat.format("Java version = {0}, Java Compiler = {1}, Java VM name = {2}", javaVersion, a, b));
        this.ivHeaderPs.println(MessageFormat.format("was.install.root = {0}", RasHelper.getSystemProperty("was.install.root")));
        this.ivHeaderPs.println(MessageFormat.format("user.install.root = {0}", RasHelper.getSystemProperty("user.install.root")));
        this.ivHeaderPs.println(MessageFormat.format("Java Home = {0}", RasHelper.getSystemProperty("java.home")));
        this.ivHeaderPs.println(MessageFormat.format("ws.ext.dirs = {0}", RasHelper.getSystemProperty("ws.ext.dirs")));
        this.ivHeaderPs.println(MessageFormat.format("Classpath = {0}", RasHelper.getSystemProperty("java.class.path")));
        this.ivHeaderPs.println(MessageFormat.format("Java Library path = {0}", RasHelper.getSystemProperty("java.library.path")));
        this.ivHeaderPs.println(MessageFormat.format("Current trace specification = {0}", ManagerAdmin.getTraceSpecification()));
        if (this.ivAddCustomHeaderOutsideHeaderLine) {
            this.ivHeaderPs.println("************* End Display Current Environment *************");
            if (this.ivCustomHeader != null) {
                this.ivHeaderPs.println(this.ivCustomHeader);
            }
        } else {
            if (this.ivCustomHeader != null) {
                this.ivHeaderPs.println(this.ivCustomHeader);
            }
            this.ivHeaderPs.println("************* End Display Current Environment *************");
        }
        this.ivHeaderPs.flush();
        byte[] bytes = this.ivHeaderBaos.toByteArray();
        try {
            this.ivOs.write(bytes);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    synchronized void printFooter(int numberOfMessages) {
    }
}

