/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent6;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ejs.ras.Untraceable;
import com.ibm.ws.bootstrap.WSLauncher;

public class TraceEvent6
extends RasEvent6 {
    public String[] ivStrings;

    public TraceEvent6(int type, TraceComponent tc, String text, Object parms, String organization, String product2, String component2, String className, String methodName, String extendedMessage) {
        super(type, tc, className, methodName, text, organization, product2, component2, extendedMessage, true);
        this.convertParameters(parms);
    }

    TraceEvent6(int type, TraceComponent tc, String methodName, String msgKey, Object parms) {
        super(type, tc, null, methodName, msgKey, "IBM", "WebSphere", "Application Server", null, false);
        this.convertParameters(parms);
    }

    private void convertParameters(Object parms) {
        if (parms == null) {
            String[] x = new String[]{this.ivMsgKey};
            this.ivStrings = x;
        } else {
            Object[] objs = null;
            Class<?> objectClass = parms.getClass();
            if (objectClass.isArray()) {
                if (Object.class.isAssignableFrom(objectClass.getComponentType())) {
                    objs = (Object[])parms;
                } else if (WSLauncher.isZOS()) {
                    boolean noBuffer = Boolean.getBoolean("com.ibm.ws390.ras.NoBufferContents");
                    if (Byte.TYPE.equals(parms.getClass().getComponentType()) && (noBuffer || Tr.zWASTraceHandlerRegistered)) {
                        this.ivRawData = (byte[])parms;
                        objs = new String[]{parms.toString()};
                    } else {
                        objs = RasHelper.primitiveArrayToString(parms);
                    }
                } else {
                    objs = RasHelper.primitiveArrayToString(parms);
                    if (Byte.TYPE.equals(parms.getClass().getComponentType())) {
                        this.ivRawData = (byte[])parms;
                    }
                }
            } else {
                objs = new Object[]{parms};
            }
            int numObjs = objs.length;
            this.ivStrings = new String[numObjs + 1];
            this.ivStrings[0] = this.ivMsgKey;
            String param = null;
            for (int i = numObjs - 1; i >= 0; --i) {
                if (objs[i] == null) {
                    this.ivStrings[i + 1] = "<null>";
                    continue;
                }
                if (objs[i] instanceof String) {
                    this.ivStrings[i + 1] = (String)objs[i];
                    continue;
                }
                try {
                    param = objs[i] instanceof Untraceable ? objs[i].getClass().getName() : (objs[i] instanceof Traceable ? ((Traceable)objs[i]).toTraceString() : (objs[i] instanceof Throwable ? RasHelper.throwableToString((Throwable)objs[i]) : objs[i].toString()));
                    if (param == null) {
                        param = "<malformed parameter>";
                    }
                    this.ivStrings[i + 1] = param;
                    continue;
                }
                catch (Throwable t) {
                    this.ivStrings[i + 1] = "<malformed parameter>";
                }
            }
        }
    }

    final String[] getStrs() {
        return this.ivStrings;
    }
}

