/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBETraceLogger;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.SharedLogReader;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.ras.ZOSSharedLogReader;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class ShowLog {
    private static String svBundle = "com.ibm.ejs.resources.RasMessages";
    private static final int STATE_ERR_UNRECOGNIZED_SWITCH = 1000;
    private static final int STATE_ERR_EXIT = 1001;
    private static long svMinStartDate = new Date(0L).getTime();
    private static final String[] sDateTimeFormats = new String[]{"yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ss"};

    public static void main(String[] args) {
        boolean bDebug = false;
        boolean outputXml = false;
        boolean languageSpecified = false;
        String languageArg = null;
        boolean countrySpecified = false;
        String countryArg = null;
        boolean formatSpecified = false;
        String formatArg = null;
        boolean outputCBE101 = false;
        String inputFilename = null;
        String outputFilename = null;
        Date startDate = null;
        boolean startParamSpecified = false;
        Date endDate = null;
        boolean endParamSpecified = false;
        String fileEncoding = null;
        boolean fileEncodingSpecified = false;
        long interval = 0L;
        boolean intervalSpecified = false;
        boolean isZOS = false;
        if (WSLauncher.isZOS()) {
            isZOS = true;
        }
        if (args.length < 1) {
            ShowLog.usage(isZOS);
            return;
        }
        boolean done = false;
        int state = 0;
        int argToProcess = 0;
        int numberOfArgs = args.length;
        String arg = null;
        if (args[argToProcess].equalsIgnoreCase("-help")) {
            ShowLog.usage(isZOS);
            return;
        }
        while (!done) {
            switch (state) {
                case 0: {
                    if (argToProcess >= numberOfArgs) {
                        ShowLog.printMissingRequiredArgumentsDetected();
                        state = 1001;
                        break;
                    }
                    if ((arg = args[argToProcess++]).equalsIgnoreCase("-xml")) {
                        state = 1;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-language")) {
                        state = 2;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-country")) {
                        state = 3;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-format")) {
                        state = 4;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-debug")) {
                        state = 100;
                        break;
                    }
                    if (!isZOS && arg.startsWith("-")) {
                        state = 1000;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-start")) {
                        state = 5;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-end")) {
                        state = 6;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-encoding")) {
                        state = 7;
                        break;
                    }
                    if (arg.equalsIgnoreCase("-interval")) {
                        state = 8;
                        break;
                    }
                    if (arg.startsWith("-")) {
                        state = 1000;
                        break;
                    }
                    state = 99;
                    break;
                }
                case 1: {
                    if (outputXml) {
                        ShowLog.printDuplicateSwitchDetected("-xml");
                        state = 1001;
                        break;
                    }
                    outputXml = true;
                    state = 0;
                    break;
                }
                case 2: {
                    languageArg = ShowLog.consumeSpecifier(args, argToProcess, languageSpecified, "language", "-language");
                    if (languageArg == null) {
                        state = 1001;
                        break;
                    }
                    ++argToProcess;
                    languageSpecified = true;
                    state = 0;
                    break;
                }
                case 3: {
                    countryArg = ShowLog.consumeSpecifier(args, argToProcess, countrySpecified, "country", "-country");
                    if (countryArg == null) {
                        state = 1001;
                        break;
                    }
                    ++argToProcess;
                    countrySpecified = true;
                    state = 0;
                    break;
                }
                case 4: {
                    formatArg = ShowLog.consumeSpecifier(args, argToProcess, formatSpecified, "format", "-format");
                    if (formatArg == null) {
                        state = 1001;
                        break;
                    }
                    ++argToProcess;
                    formatSpecified = true;
                    if (!formatArg.equalsIgnoreCase("CBE-XML-1.0.1")) {
                        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG111", "Invalid format specifier.  Valid values include CBE-XML-1.0.1"));
                        state = 1001;
                        break;
                    }
                    state = 0;
                    outputCBE101 = true;
                    break;
                }
                case 5: {
                    startDate = ShowLog.consumeDateSpecifier(args, argToProcess, startParamSpecified, "start", "-start");
                    if (startDate == null) {
                        state = 1001;
                        break;
                    }
                    ++argToProcess;
                    startParamSpecified = true;
                    state = 0;
                    break;
                }
                case 6: {
                    endDate = ShowLog.consumeDateSpecifier(args, argToProcess, endParamSpecified, "end", "-end");
                    if (endDate == null) {
                        state = 1001;
                        break;
                    }
                    ++argToProcess;
                    endParamSpecified = true;
                    state = 0;
                    break;
                }
                case 7: {
                    fileEncoding = ShowLog.consumeSpecifier(args, argToProcess, fileEncodingSpecified, "encoding", "-encoding");
                    if (fileEncoding == null) {
                        state = 1001;
                        break;
                    }
                    ++argToProcess;
                    fileEncodingSpecified = true;
                    state = 0;
                    break;
                }
                case 8: {
                    interval = ShowLog.consumePositiveIntSpecifier(args, argToProcess, intervalSpecified, "interval", "-interval");
                    if (interval < 0L) {
                        state = 1001;
                        break;
                    }
                    ++argToProcess;
                    intervalSpecified = true;
                    state = 0;
                    break;
                }
                case 99: {
                    inputFilename = arg;
                    if (isZOS) {
                        inputFilename = inputFilename.toUpperCase();
                    }
                    if (argToProcess < numberOfArgs) {
                        if ((outputFilename = args[argToProcess++]).startsWith("-")) {
                            System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG114", new Object[]{outputFilename}, "Switch " + outputFilename + " is not allowed at the present position."));
                            state = 1001;
                            break;
                        }
                        if (argToProcess < numberOfArgs) {
                            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG115", "Invalid parameters.  Output filename must be the last parameter specified."));
                            state = 1001;
                            break;
                        }
                        done = true;
                        break;
                    }
                    done = true;
                    break;
                }
                case 100: {
                    if (bDebug) {
                        ShowLog.printDuplicateSwitchDetected("-debug");
                        state = 1001;
                        break;
                    }
                    bDebug = true;
                    state = 0;
                    break;
                }
                case 1000: {
                    System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG113", new Object[]{arg}, "Unrecognized switch " + arg + " specified."));
                    state = 1001;
                    break;
                }
                case 1001: {
                    ShowLog.usage(isZOS);
                    System.exit(-1);
                }
            }
        }
        if (isZOS) {
            boolean isValid = true;
            if (intervalSpecified) {
                if (startParamSpecified || endParamSpecified) {
                    System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG118", "Invalid parameters.  Neither start nor end can be specified when an interval is specified."));
                    isValid = false;
                } else {
                    long currentDate = System.currentTimeMillis();
                    startDate = new Date(currentDate - interval);
                    endDate = new Date(currentDate);
                }
            } else if (!startParamSpecified) {
                System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG119", "Invalid parameters.  Valid sets include either interval or start."));
                isValid = false;
            } else {
                if (!endParamSpecified) {
                    endDate = new Date();
                }
                if (startDate.getTime() > endDate.getTime()) {
                    System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG121", "Invalid parameters.  Date and time of end must be later than date and time of start."));
                    isValid = false;
                }
            }
            if (startDate.getTime() < svMinStartDate) {
                System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG122", "Invalid parameters.  Start date must not be earlier than 1970-01-01T00:00:00GMT."));
                isValid = false;
            }
            if (!isValid) {
                ShowLog.usage(isZOS);
                System.exit(-1);
            }
        }
        if (fileEncoding == null) {
            fileEncoding = System.getProperty("file.encoding");
        }
        if (bDebug) {
            System.err.println("outputXML\t\t\t\t: " + outputXml);
            System.err.println("languageSpecified\t\t: " + languageSpecified);
            System.err.println("languageArg\t\t\t\t: " + languageArg);
            System.err.println("countrySpecified\t\t: " + countrySpecified);
            System.err.println("countryArg\t\t\t\t: " + countryArg);
            System.err.println("formatSpecified\t\t\t: " + formatSpecified);
            System.err.println("formatArg\t\t\t\t: " + formatArg);
            System.err.println("outputCBE101\t\t\t: " + outputCBE101);
            System.err.println("inputFilename\t\t\t: " + inputFilename);
            System.err.println("outputFilename\t\t\t: " + outputFilename);
            System.err.println("startDate\t\t\t\t: " + startDate);
            System.err.println("startParamSpecified\t\t: " + startParamSpecified);
            System.err.println("endDate\t\t\t\t\t: " + endDate);
            System.err.println("endParamSpecified\t\t: " + endParamSpecified);
            System.err.println("fileEncoding\t\t\t: " + fileEncoding);
            System.err.println("fileEncodingSpecified\t: " + fileEncodingSpecified);
            System.err.println("interval\t\t\t\t: " + interval);
            System.err.println("intervalSpecified\t\t: " + intervalSpecified);
        }
        PrintStream ps = null;
        int numRecords = 0;
        if (isZOS && outputFilename == null) {
            outputFilename = "showlog.out";
        }
        if (outputFilename == null) {
            ps = (PrintStream)Tr.getSystemOut();
        } else {
            try {
                RasHelper.validateFileName(outputFilename.trim());
                FileOutputStream fos = RasHelper.createFileOutputStream(outputFilename, false);
                ps = new PrintStream(fos);
            }
            catch (Throwable t) {
                System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG116", new Object[]{outputFilename}, "Unable to open output file " + outputFilename + "."));
                System.exit(-1);
            }
        }
        Locale locale = Locale.getDefault();
        if (countryArg == null) {
            countryArg = "";
        }
        if (languageArg != null) {
            try {
                locale = new Locale(languageArg, countryArg);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        TraceLogger tl = null;
        try {
            tl = outputCBE101 ? new CBETraceLogger((OutputStream)ps, locale, fileEncoding) : new ExtendedTraceLogger((OutputStream)ps, outputXml, locale, fileEncoding);
            tl.printHeader();
            if (isZOS) {
                ZOSSharedLogReader zslr = new ZOSSharedLogReader(inputFilename, startDate, endDate);
                WsLogRecord zevent = zslr.getNextMessage();
                while (zevent != null) {
                    if (bDebug) {
                        ShowLog.checkPreviousMessageLocale(tl, zevent.getImpl(), locale, "zOS");
                    }
                    tl.doLog(zevent.getImpl());
                    zevent = zslr.getNextMessage();
                    ++numRecords;
                }
            } else {
                SharedLogReader slr = new SharedLogReader(inputFilename, false);
                WsLogRecord event2 = slr.getNextMessage();
                while (event2 != null) {
                    if (bDebug) {
                        ShowLog.checkPreviousMessageLocale(tl, event2.getImpl(), locale, "distributed");
                    }
                    tl.doLog(event2.getImpl());
                    event2 = slr.getNextMessage();
                    ++numRecords;
                }
            }
        }
        catch (UnsupportedEncodingException use) {
            ShowLog.supportedEncodings();
            ShowLog.usage(isZOS);
            System.exit(-1);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!outputXml && !outputCBE101) {
            ps.println();
        }
        tl.printFooter(numRecords);
        ps.close();
    }

    private static long consumePositiveIntSpecifier(String[] args, int index, boolean duplicate, String specifierName, String switchName) {
        String specifier = ShowLog.consumeSpecifier(args, index, duplicate, specifierName, switchName);
        if (specifier == null) {
            return -1L;
        }
        boolean valueValid = true;
        long value = -1L;
        try {
            value = Long.parseLong(specifier);
            if (value < 1L) {
                valueValid = false;
            }
        }
        catch (NumberFormatException e) {
            valueValid = false;
        }
        if (!valueValid) {
            System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG112", new Object[]{switchName}, "Invalid value specified after " + switchName + " switch.  Valid values are integers greater than 0."));
            return -1L;
        }
        return value;
    }

    private static Date consumeDateSpecifier(String[] args, int index, boolean duplicate, String specifierName, String switchName) {
        String specifier = ShowLog.consumeSpecifier(args, index, duplicate, specifierName, switchName);
        if (specifier == null) {
            return null;
        }
        Date date = ShowLog.parseDateTime(specifier);
        if (date == null) {
            System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG120", new Object[]{switchName}, "Invalid date or time specified after " + switchName + " switch.  Date and time must be specified in yyyy-MM-ddTHH:mm:ss.SSSZ format.  Milliseconds and time zone are optional."));
            return null;
        }
        return date;
    }

    private static String consumeSpecifier(String[] args, int index, boolean duplicate, String specifierName, String switchName) {
        String specifier = null;
        if (duplicate) {
            ShowLog.printDuplicateSwitchDetected(switchName);
            return null;
        }
        if (index >= args.length) {
            ShowLog.printMissingSpecifierDetected(specifierName, switchName);
            return null;
        }
        specifier = args[index];
        if (specifier.startsWith("-")) {
            ShowLog.printMissingSpecifierDetected(specifierName, switchName);
            return null;
        }
        return specifier;
    }

    private static void printMissingRequiredArgumentsDetected() {
        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG108", "Missing required arguments."));
    }

    private static void printDuplicateSwitchDetected(String name) {
        System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG109", new Object[]{name}, name + " switch specified more than once."));
    }

    private static void printMissingSpecifierDetected(String specifierName, String switchName) {
        System.err.println(TraceNLS.getFormattedMessage(svBundle, "SHOWLOG_MSG110", new Object[]{specifierName, switchName}, "Missing " + specifierName + " specifier after " + switchName + " switch."));
    }

    private static void usage(boolean isZOS) {
        if (!isZOS) {
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG001", "This program dumps a Websphere binary log file to standard out or a file."));
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG002", "Usage: showlog [-format CBE-XML-1.0.1] binaryFilename [outputFilename]"));
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG003", "where:"));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG007", "-format specifies the output format.  Currently only CBE-XML-1.0.1 format is supported (this complies with the Common Base Event specification version 1.0.1).  If no format is given, showlog outputs in a tabular format."));
            System.err.println();
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG004", "binaryFilename should be a binary log filename in the WASHOME/logs directory or a fully-qualified binary log filename.  showlog will not look in the current directory."));
            System.err.println();
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG005", "outputFilename is optional.  If no filename is given, showlog dumps binaryFilename to standard out.  Otherwise, outputFilename will be created in the current directory unless it is a fully-qualified filename."));
            System.err.println();
        } else {
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG020", "This program dumps a Websphere binary log file to an output file."));
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG021", "Usage: showlog {-start startDateTime [-end endDateTime] | -interval interval} [-format CBE-XML-1.0.1] [-encoding encoding] logStreamName [outputFilename]"));
            System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG003", "where:"));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG024", "-start specifies the start date and time, in yyyy-MM-ddTHH:mm:ss.SSSZ format.  Milliseconds and time zone are optional."));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG026", "-end specifies the end date and time, in yyyy-MM-ddTHH:mm:ss.SSSZ format.  Milliseconds and time zone are optional."));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG028", "-interval specifies the start date as the system date and time minus interval milliseconds, and end date as the system date and time.  Valid values are integers greater than 0."));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG029", "-format specifies the output format.  Currently only CBE-XML-1.0.1 format is supported (this complies with the Common Base Event specification version 1.0.1).  If no format is given, showlog outputs in a tabular format."));
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG030", "-encoding specifies the output file encoding, a character encoding supported by the local Java Virtual Machine ."));
            System.err.println();
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG022", "logStream a log filename."));
            System.err.println();
            System.err.println("\t" + TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG023", "outputFilename is optional.  If no filename is given, showlog creates a default showlog.out filename, outputFilename will be created in the current directory unless it is a fully-qualified filename."));
            System.err.println();
        }
    }

    private static void supportedEncodings() {
        SortedMap<String, Charset> sm = Charset.availableCharsets();
        Set<String> c = sm.keySet();
        Iterator i = c.iterator();
        System.err.println(TraceNLS.getStringFromBundle(svBundle, "SHOWLOG_MSG117", "Unsupported encoding specified.  The supported encodings are:"));
        int index = 0;
        while (i.hasNext()) {
            String str = (String)i.next();
            if (str.length() < 8) {
                System.err.print(str + "\t\t");
            } else {
                System.err.print(str + "\t");
            }
            if (index++ % 8 != 0) continue;
            System.err.println();
        }
    }

    private static Date parseDateTime(String s) {
        if (s == null) {
            return null;
        }
        int tPos = s.indexOf("T");
        if (tPos < 0 || tPos + 1 >= s.length()) {
            return null;
        }
        String dateString = s.substring(0, tPos);
        String timeString = s.substring(tPos + 1, s.length());
        String dateTimeString = dateString + " " + timeString;
        for (int i = 0; i < sDateTimeFormats.length; ++i) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(sDateTimeFormats[i]);
                return sdf.parse(dateTimeString);
            }
            catch (ParseException e) {
                continue;
            }
        }
        return null;
    }

    private static void checkPreviousMessageLocale(TraceLogger logger, LogRecord logRecord, Locale locale, String platform) {
        if (logger instanceof CBETraceLogger) {
            CommonBaseEventLogRecord cbeLogRecord = WsLogRecordFactory.convertToCBELogRecord(logRecord);
            CommonBaseEvent cbe = cbeLogRecord.getCommonBaseEvent();
            String previousMessageLocale = CBEHelper.getMessageLocale(cbe);
            if (previousMessageLocale != null) {
                String previousFormattedMessage;
                String currentMessageLocale = locale.toString();
                String previousLanguage = previousMessageLocale.substring(0, 2);
                String currentLanguage = locale.getLanguage();
                if ((previousMessageLocale.equals(currentMessageLocale) || previousLanguage.equals(currentLanguage)) && (previousFormattedMessage = CBEHelper.getFormattedMessage(cbe)) != null) {
                    System.err.println("CBETraceLogger on " + platform + " using CBEHelper.getAlreadyFormattedMessage(): Using previous message locale " + previousMessageLocale + " instead of current message locale " + currentMessageLocale);
                }
            }
        } else if (logger instanceof ExtendedTraceLogger) {
            CommonBaseEvent cbe;
            Locale logFormatterLocale = locale;
            if (logFormatterLocale == null) {
                logFormatterLocale = Locale.getDefault();
            }
            CommonBaseEventLogRecord cbeLR = logRecord instanceof CommonBaseEventLogRecord ? (CommonBaseEventLogRecord)logRecord : null;
            CommonBaseEvent commonBaseEvent = cbe = cbeLR != null ? cbeLR.getCommonBaseEvent() : null;
            if (cbe != null) {
                String previousMessageLocale = CBEHelper.getMessageLocale(cbe);
                if (previousMessageLocale != null) {
                    String previousFormattedMessage;
                    String currentMessageLocale = logFormatterLocale.toString();
                    String previousLanguage = previousMessageLocale.substring(0, 2);
                    String currentLanguage = locale.getLanguage();
                    if ((previousMessageLocale.equals(currentMessageLocale) || previousLanguage.equals(currentLanguage)) && (previousFormattedMessage = CBEHelper.getFormattedMessage(cbe)) != null) {
                        System.err.println("ExtendedTraceLogger on " + platform + " using CBEHelper.getAlreadyFormattedMessage(): Using previous message locale " + previousMessageLocale + " instead of current message locale " + currentMessageLocale);
                    }
                }
            } else {
                String previousMessageLocale;
                WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(logRecord);
                if (wsLogRecord != null && wsLogRecord.getLocalizable() != 2 && (previousMessageLocale = wsLogRecord.getMessageLocale()) != null) {
                    String previousFormattedMessage;
                    String currentMessageLocale = logFormatterLocale.toString();
                    String previousLanguage = previousMessageLocale.substring(0, 2);
                    String currentLanguage = locale.getLanguage();
                    if ((previousMessageLocale.equals(currentMessageLocale) || previousLanguage.equals(currentLanguage)) && (previousFormattedMessage = wsLogRecord.getFormattedMessage()) != null) {
                        System.err.println("ExtendedTraceLogger on " + platform + " using TraceLogFormatter.formatMessageWSLR(): Using previous message locale " + previousMessageLocale + " instead of current message locale " + currentMessageLocale);
                    }
                }
            }
        }
    }
}

