/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasContextManager;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.logging.ZRasHelper;

public abstract class RasEvent6 {
    public static final int AUDIT = 1;
    public static final int DEBUG = 2;
    public static final int DUMP = 3;
    public static final int ERROR = 4;
    public static final int EVENT = 5;
    public static final int ENTRY = 6;
    public static final int EXIT = 7;
    public static final int FATAL = 8;
    public static final int SERVICE = 9;
    public static final int WARNING = 10;
    public static final int INFO = 11;
    public static final int UNCOND = 12;
    public static final int SYSOUT = 13;
    public static final int SYSERR = 14;
    public static final int UNKNOWN = 15;
    public static final int FIRST_EVENT = 1;
    public static final int LAST_EVENT = 15;
    static final String[] svTypePrefixes = new String[]{" A ", " d ", " m ", " E ", " e ", " > ", " < ", " F ", " S ", " W ", " I ", " u ", " O ", " R ", " Z "};
    static final String[] typeNames = new String[]{"AUDIT", "DEBUG", "DUMP", "ERROR", "EVENT", "ENTRY", "EXIT", "FATAL", "SERVICE", "WARNING", "INFO", "UNCOND", "SYSTEMOUT", "SYSTEMERR", "UNKNOWN"};
    static final String ibm = "IBM";
    static final String webSphere = "WebSphere";
    static final String appServer = "Application Server";
    static final String emptyString = "";
    static final String nullParamString = "<null>";
    static final String badParamString = "<malformed parameter>";
    private static ThreadLocal sThreadId = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return RasHelper.getThreadId();
        }
    };
    public String ivOrganization;
    public String ivProduct;
    public String ivComponent;
    public String ivVersion;
    public String ivEventSource;
    public String ivClassName;
    public String ivMethodName;
    public String ivThreadId;
    public String ivProcessId;
    public String ivServerName;
    public String ivThreadName;
    public long ivTimeStamp;
    public int ivType;
    public String ivMsgKey;
    public byte[] ivRawData = null;
    public String ivExtendedMessage;
    public String ivUnitOfWork;
    transient boolean tivIsJras = false;

    static String getTypeString(int type) {
        if (type < 1 || type > 15) {
            return new String("unknown Type");
        }
        return typeNames[type - 1];
    }

    RasEvent6() {
    }

    RasEvent6(int type, TraceComponent tc, String className, String methodName, String msgKey, String organization, String product2, String component2, String extendedMessage, boolean fromJras) {
        this.ivType = type < 1 || type > 15 ? 15 : type;
        this.ivEventSource = tc.getName();
        this.tivIsJras = fromJras;
        this.ivOrganization = organization;
        this.ivProduct = product2;
        this.ivComponent = component2;
        this.ivExtendedMessage = extendedMessage;
        this.ivClassName = className;
        this.ivMethodName = methodName;
        this.ivMsgKey = msgKey == null ? "NULL_MESSAGE_KEY_PASSED" : msgKey;
        this.ivVersion = RasHelper.getVersionId();
        this.ivProcessId = !WSLauncher.isZOS() || ManagerAdmin.isThinClient() ? RasHelper.getProcessId() : ZRasHelper.ProcessInfo.getPId();
        this.ivServerName = RasHelper.getServerName();
        this.ivThreadName = Thread.currentThread().getName();
        this.ivTimeStamp = System.currentTimeMillis();
        Thread myThread = Thread.currentThread();
        this.ivThreadId = (String)sThreadId.get();
        this.ivUnitOfWork = RasContextManager.getUnitOfWork();
    }

    public final long getTimeStamp() {
        return this.ivTimeStamp;
    }

    public String getThreadId() {
        return this.ivThreadId;
    }
}

