/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.RasContextManager;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class RasContextSupport
extends LocalObject
implements ORBInitializer,
ClientRequestInterceptor,
ServerRequestInterceptor {
    private static final long serialVersionUID = -8316581876169651371L;
    private static final TraceComponent tc = Tr.register(RasContextSupport.class);
    private static final int RasServiceId = 1229081858;
    private static String serverNameSuffix = null;
    private static String hostNameSuffix = null;
    private static long serverCounter = 1L;
    private static Object serverCounterMutex = new Object();
    private static final int millisecondsInAYear = 31536000;
    private static int uowBufferSize = 16;

    public void pre_init(ORBInitInfo initInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pre_init", initInfo);
        }
        if (RasProperties.isUnitOfWorkEnabled()) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Installing RAS request interceptor");
            }
            if (!RasContextManager.initialized) {
                try {
                    ((ExtendedORBInitInfo)initInfo).add_client_request_interceptor((ClientRequestInterceptor)this, false);
                    ((ExtendedORBInitInfo)initInfo).add_server_request_interceptor((ServerRequestInterceptor)this, false);
                }
                catch (DuplicateName dn) {
                    return;
                }
            }
            if (RasHelper.isServer()) {
                if (serverNameSuffix == null) {
                    StringBuffer serverBuff = new StringBuffer();
                    serverBuff.append('-');
                    serverBuff.append(RasHelper.getProcessId());
                    serverBuff.append(':');
                    serverBuff.append(RasHelper.getServerName());
                    serverNameSuffix = new String(serverBuff);
                    uowBufferSize = serverNameSuffix.length() + 8;
                }
            } else if (hostNameSuffix == null) {
                StringBuffer clientBuff = new StringBuffer();
                try {
                    long time = System.currentTimeMillis();
                    clientBuff.append('-');
                    clientBuff.append(time % 31536000L);
                    clientBuff.append(':');
                    String hostName = RasHelper.getHostName();
                    clientBuff.append(hostName);
                }
                catch (RasException re) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Hostname cannot be determined");
                    }
                    clientBuff.append("Unknown");
                }
                hostNameSuffix = new String(clientBuff);
                uowBufferSize = hostNameSuffix.length() + 16;
            }
            RasContextManager.initialized = true;
        } else if (tc.isEventEnabled()) {
            Tr.event(tc, "Not installing RAS request interceptor");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pre_init");
        }
    }

    public void send_request(ClientRequestInfo requestInfo) {
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "send_request", requestInfo);
            }
            String unitOfWork = null;
            byte[] data = null;
            try {
                if (RasHelper.isServer()) {
                    unitOfWork = RasContextManager.getUnitOfWork();
                } else {
                    StringBuffer newUOWBuff = new StringBuffer(uowBufferSize);
                    newUOWBuff.append(requestInfo.request_id());
                    newUOWBuff.append('-');
                    newUOWBuff.append(Integer.toHexString(Thread.currentThread().hashCode()));
                    newUOWBuff.append(hostNameSuffix);
                    unitOfWork = new String(newUOWBuff);
                    RasContextManager.setUnitOfWork(unitOfWork);
                }
                if (unitOfWork != null) {
                    ORB theORB = (ORB)((LocalObject)requestInfo)._orb();
                    CDROutputStream cos = ORB.createCDROutputStream((ORB)theORB);
                    cos.putEndian();
                    cos.write_string(unitOfWork);
                    cos.write_ulong(0);
                    data = cos.toByteArray();
                    ServiceContext sc = new ServiceContext(1229081858, data);
                    requestInfo.add_request_service_context(sc, true);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception during client request ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "send_request");
        }
    }

    public void receive_reply(ClientRequestInfo requestInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive_request(ServerRequestInfo requestInfo) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "receive_request", requestInfo);
            }
            ServiceContext sc = null;
            sc = ((ExtendedServerRequestInfo)requestInfo).getRequestServiceContext(1229081858);
            try {
                if (sc != null) {
                    byte[] data = sc.context_data;
                    ORB theORB = (ORB)((LocalObject)requestInfo)._orb();
                    CDRInputStream cis = ORB.createCDRInputStream((ORB)theORB, (byte[])data, (int)data.length);
                    cis.consumeEndian();
                    RasContextManager.setUnitOfWork(cis.read_string());
                    break block8;
                }
                if (!RasHelper.isServer()) break block8;
                StringBuffer newUOWBuff = new StringBuffer(uowBufferSize);
                Object object = serverCounterMutex;
                synchronized (object) {
                    newUOWBuff.append(serverCounter++);
                }
                newUOWBuff.append(serverNameSuffix);
                RasContextManager.setUnitOfWork(new String(newUOWBuff));
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Exception during server request ", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receive_request");
        }
    }

    public void send_reply(ServerRequestInfo requestInfo) {
        RasContextManager.setUnitOfWork(null);
    }

    public void send_exception(ServerRequestInfo requestInfo) {
        RasContextManager.setUnitOfWork(null);
    }

    public void post_init(ORBInitInfo initInfo) {
    }

    public void receive_request_service_contexts(ServerRequestInfo requestInfo) {
    }

    public void send_other(ServerRequestInfo requestInfo) {
    }

    public String name() {
        return "com.ibm.ejs.ras.RasContextSupport";
    }

    public void destroy() {
    }

    public void send_poll(ClientRequestInfo requestInfo) {
    }

    public void receive_exception(ClientRequestInfo requestInfo) {
    }

    public void receive_other(ClientRequestInfo requestInfo) {
    }
}

