/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasEvent6;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.Traceable;
import com.ibm.ejs.ras.Untraceable;
import java.util.Date;
import java.util.ResourceBundle;

public class MessageEvent6
extends RasEvent6 {
    private static final int svClassVersion = 2;
    private static int svMaxStringSize = 1000;
    private int ivClassVersion = 2;
    public String ivBundleName;
    public Object[] ivMsgParms;
    public transient String tivFormattedMessage = null;
    public ResourceBundle ivBundle = null;
    public String ivDiagnosticProviderID = null;

    public MessageEvent6(int type, TraceComponent tc, String msgKey, String msgFile, Object msgParms, String organization, String product2, String component2, String className, String methodName, String extendedMessage) {
        super(type, tc, className, methodName, msgKey, organization, product2, component2, extendedMessage, true);
        this.ivBundleName = msgFile;
        this.convertParameters(msgParms);
        if (tc.getDiagnosticProviderID() != null) {
            this.ivDiagnosticProviderID = tc.getDiagnosticProviderID();
        }
        if (this.ivBundleName == null) {
            if (this.ivMsgParms != null) {
                StringBuffer sb = new StringBuffer(this.ivMsgKey);
                int length = this.ivMsgParms.length;
                for (int i = 0; i < length; ++i) {
                    sb.append(" ");
                    sb.append(this.ivMsgParms[i].toString());
                }
                this.ivMsgKey = new String(sb);
                this.ivMsgParms = null;
            }
            this.tivFormattedMessage = this.ivMsgKey;
        }
    }

    MessageEvent6(int type, TraceComponent tc, String methodName, String msgKey, Object msgParms) {
        super(type, tc, null, methodName, msgKey, "IBM", "WebSphere", "Application Server", null, false);
        this.ivBundleName = tc.getResourceBundleName();
        if (tc.getDiagnosticProviderID() != null) {
            this.ivDiagnosticProviderID = tc.getDiagnosticProviderID();
        }
        this.convertParameters(msgParms);
    }

    MessageEvent6() {
    }

    final Object[] getMessageInserts() {
        return this.ivMsgParms;
    }

    private void convertParameters(Object msgParms) {
        if (msgParms == null) {
            this.ivMsgParms = null;
            return;
        }
        Object[] objs = null;
        Class<?> objectClass = msgParms.getClass();
        objs = objectClass.isArray() ? (Object.class.isAssignableFrom(objectClass.getComponentType()) ? (Object[])msgParms : RasHelper.primitiveArrayToString(msgParms)) : new Object[]{msgParms};
        int numObjs = objs.length;
        this.ivMsgParms = new Object[numObjs];
        String param = null;
        for (int i = numObjs - 1; i >= 0; --i) {
            if (objs[i] == null) {
                this.ivMsgParms[i] = "<null>";
                continue;
            }
            if (objs[i] instanceof String) {
                String dPidCk;
                this.ivMsgParms[i] = objs[i];
                if (i != 0 || (dPidCk = (String)objs[i]) == null || dPidCk.length() <= 5 || !dPidCk.substring(0, 5).equalsIgnoreCase("DPID:")) continue;
                this.ivDiagnosticProviderID = dPidCk.substring(5);
                continue;
            }
            if (objs[i] instanceof Number || objs[i] instanceof Date) {
                this.ivMsgParms[i] = objs[i];
                continue;
            }
            try {
                param = objs[i] instanceof Untraceable ? objs[i].getClass().getName() : (objs[i] instanceof Traceable ? ((Traceable)objs[i]).toTraceString() : (objs[i] instanceof Throwable ? RasHelper.throwableToString((Throwable)objs[i]) : objs[i].toString()));
                if (param == null) {
                    param = "<malformed parameter>";
                }
                this.ivMsgParms[i] = param;
                continue;
            }
            catch (Throwable t) {
                this.ivMsgParms[i] = "<malformed parameter>";
            }
        }
    }

    static {
        try {
            String x = RasHelper.getSystemProperty("com.ibm.ws.ras.MessageElementSize");
            if (x == null) {
                svMaxStringSize = 1000;
            } else {
                svMaxStringSize = Integer.parseInt(x);
                if (svMaxStringSize < 100) {
                    svMaxStringSize = 100;
                }
            }
        }
        catch (Throwable t) {
            svMaxStringSize = 1000;
        }
    }
}

