/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import java.util.Enumeration;
import java.util.NoSuchElementException;

class CBuff {
    private int ivSize;
    private Object[] ivElements;
    private int ivTail;
    private boolean ivWrapped;

    CBuff(int size) {
        this.ivSize = size;
        this.ivTail = -1;
        this.ivWrapped = false;
        this.ivElements = new Object[this.ivSize];
    }

    void put(Object obj) {
        ++this.ivTail;
        if (this.ivTail == this.ivSize) {
            this.ivTail = 0;
            this.ivWrapped = true;
        }
        this.ivElements[this.ivTail] = obj;
    }

    int getSize() {
        return this.ivSize;
    }

    void setSize(int newSize) {
        if (newSize == this.ivSize) {
            return;
        }
        int oldSize = this.ivSize;
        boolean oldWrapped = this.ivWrapped;
        int oldTail = this.ivTail;
        Object[] oldElements = this.ivElements;
        try {
            this.ivWrapped = false;
            this.ivSize = newSize;
            this.ivTail = -1;
            this.ivElements = new Object[newSize];
            int elementIndex = 0;
            if (oldWrapped && (elementIndex = oldTail + 1) == oldSize) {
                elementIndex = 0;
            }
            int elementsToCopy = oldTail + 1;
            if (oldWrapped) {
                elementsToCopy = oldSize;
            }
            for (int i = 0; i < elementsToCopy; ++i) {
                this.put(oldElements[elementIndex]);
                if (++elementIndex != oldSize) continue;
                elementIndex = 0;
            }
        }
        catch (OutOfMemoryError err) {
            this.ivSize = oldSize;
            this.ivWrapped = oldWrapped;
            this.ivTail = oldTail;
            this.ivElements = oldElements;
        }
    }

    Enumeration elements() {
        int firstElementIndex = -1;
        int elementCount = this.ivTail + 1;
        if (this.ivWrapped) {
            firstElementIndex = this.ivTail;
            elementCount = this.ivSize;
        }
        return new CBuffEnum(this.ivElements, this.ivSize, elementCount, firstElementIndex);
    }

    class CBuffEnum
    implements Enumeration {
        private int ivCount;
        private int ivCurrent;
        private int ivSize;
        private Object[] ivElements;

        public CBuffEnum(Object[] elements, int size, int count, int first) {
            this.ivElements = elements;
            this.ivSize = size;
            this.ivCount = count;
            this.ivCurrent = first;
        }

        public boolean hasMoreElements() {
            return this.ivCount != 0;
        }

        public Object nextElement() {
            if (this.ivCount != 0) {
                this.ivCurrent = (this.ivCurrent + 1) % this.ivSize;
                --this.ivCount;
                return this.ivElements[this.ivCurrent];
            }
            throw new NoSuchElementException("Enumeration exhausted");
        }
    }
}

