/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.BundleResolver;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class BundleResolverImpl
implements BundleResolver {
    private static TraceComponent tc = Tr.register(BundleResolverImpl.class, null, null);
    private static final Map svResourceBundles = new HashMap();
    private static final List svRegexpBundles = new ArrayList();
    private static Map svResourceBundleCache = Collections.synchronizedMap(new HashMap());
    private static Map svResourceBundlesNotInOSGi = new HashMap();

    public ResourceBundle resolve(String bundleName, Locale locale) {
        ResourceBundleCacheEntry cacheEntry = (ResourceBundleCacheEntry)svResourceBundleCache.get(bundleName);
        if (cacheEntry != null && cacheEntry.locale.equals(locale)) {
            return cacheEntry.bundle;
        }
        ResourceBundle result = BundleResolverImpl.getOSGiResourceBundle(bundleName, locale);
        if (result != null && locale != null) {
            svResourceBundleCache.put(bundleName, new ResourceBundleCacheEntry(result, locale));
        }
        return result;
    }

    private static ResourceBundle getResourceBundleFromOSGiBundle(final String bundleName, final Locale locale, final Bundle bundle) {
        ResourceBundle resourceBundle;
        block5: {
            resourceBundle = null;
            try {
                resourceBundle = (ResourceBundle)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Class clazz = bundle.loadClass(bundleName);
                        return ResourceBundle.getBundle(bundleName, locale, clazz.getClassLoader());
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "found resource bundle " + bundleName + " in OSGi bundle " + bundle.getSymbolicName());
                }
            }
            catch (Exception e) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "unable to load resource bundle " + bundleName + " from OSGi bundle " + bundle.getSymbolicName() + ": " + e.getMessage());
                }
            }
            catch (NoClassDefFoundError error) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "unable to load resource bundle " + bundleName + " from OSGi bundle " + bundle.getSymbolicName() + ": " + error.getMessage());
            }
        }
        return resourceBundle;
    }

    private static ResourceBundle getOSGiResourceBundle(String bundleName, Locale locale) {
        if (svResourceBundlesNotInOSGi.containsKey(bundleName)) {
            return null;
        }
        ResourceBundle resourceBundle = null;
        Bundle osgiBundle = (Bundle)svResourceBundles.get(bundleName);
        if (osgiBundle != null) {
            resourceBundle = BundleResolverImpl.getResourceBundleFromOSGiBundle(bundleName, locale, osgiBundle);
        } else {
            Iterator it = svRegexpBundles.iterator();
            while (it.hasNext() && resourceBundle == null) {
                BundleEntry bundleEntry = (BundleEntry)it.next();
                Pattern pattern = bundleEntry.getRegExp();
                Matcher matcher = pattern.matcher(bundleName);
                if (!matcher.matches()) continue;
                resourceBundle = BundleResolverImpl.getResourceBundleFromOSGiBundle(bundleName, locale, bundleEntry.getBundle());
            }
        }
        if (resourceBundle == null) {
            svResourceBundlesNotInOSGi.put(bundleName, null);
        }
        return resourceBundle;
    }

    static {
        ExtensionRegistryFactory extRegFactory = ExtensionRegistryFactory.instance();
        IExtensionRegistry registry = extRegFactory.getExtensionRegistry();
        if (extRegFactory.isEclipse() && registry != null) {
            String epid;
            IExtensionPoint point;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "In running eclipse environment");
            }
            if ((point = registry.getExtensionPoint(epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".message-bundle")) != null) {
                IExtension[] extensions;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Extension point, " + epid + ", found");
                }
                if ((extensions = point.getExtensions()) != null) {
                    for (int i = 0; i < extensions.length; ++i) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Extension, " + extensions[i].getExtensionPointUniqueIdentifier() + ", being processed");
                        }
                        IConfigurationElement[] bundles = extensions[i].getConfigurationElements();
                        Bundle osgiBundle = Platform.getBundle((String)extensions[i].getNamespace());
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "osgi bundle is - " + osgiBundle.getSymbolicName());
                        }
                        for (int j = 0; j < bundles.length; ++j) {
                            String className = bundles[j].getAttribute("class");
                            String regExp = bundles[j].getAttribute("regexp");
                            if (className != null && !"".equals(className)) {
                                svResourceBundles.put(className, osgiBundle);
                            }
                            if (regExp == null || "".equals(regExp)) continue;
                            svRegexpBundles.add(new BundleEntry(regExp, osgiBundle));
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extension point, " + epid + ", NOT found");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not in a running eclipse environment");
        }
    }

    private static class ResourceBundleCacheEntry {
        ResourceBundle bundle;
        Locale locale;

        ResourceBundleCacheEntry(ResourceBundle bundle, Locale locale) {
            this.bundle = bundle;
            this.locale = locale;
        }
    }

    private static class BundleEntry {
        private String _regExp;
        private Pattern _compiledRegExp;
        private Bundle _bundle;

        public BundleEntry(String regExp, Bundle bundle) {
            this._regExp = regExp;
            this._bundle = bundle;
        }

        public Pattern getRegExp() {
            if (this._compiledRegExp == null) {
                this._compiledRegExp = Pattern.compile(this._regExp);
            }
            return this._compiledRegExp;
        }

        public Bundle getBundle() {
            return this._bundle;
        }
    }
}

