/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.persistence;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.persistence.EnhancedEnumeration;
import com.ibm.ejs.persistence.EnumeratorException;
import com.ibm.ejs.persistence.NoMoreElementsException;
import com.ibm.ejs.persistence.RemoteEnumerator;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.NoSuchElementException;
import javax.ejb.EJBObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FinderEnumerator
implements EnhancedEnumeration,
Serializable {
    static final int PREFETCH_COUNT = 25;
    private RemoteEnumerator enum = null;
    private EJBObject[] elements = null;
    private int index = 0;
    private boolean exhausted = false;
    private static final long serialVersionUID = 4603100038030697154L;

    FinderEnumerator(EJBObject[] elements) {
        this.elements = elements;
        this.exhausted = true;
    }

    FinderEnumerator(EJBObject[] prefetchElements, boolean exhausted, RemoteEnumerator vEnum) {
        this.elements = prefetchElements;
        this.exhausted = exhausted;
        this.enum = vEnum;
    }

    public Object nextElement() {
        try {
            return this.nextElementR();
        }
        catch (NoMoreElementsException e) {
            throw new NoSuchElementException();
        }
        catch (EnumeratorException e) {
            throw new RuntimeException(e.toString());
        }
        catch (NoSuchObjectException e) {
            throw new IllegalStateException("Cannot access finder result outside transaction");
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public boolean hasMoreElements() {
        try {
            return this.hasMoreElementsR();
        }
        catch (NoMoreElementsException e) {
            return false;
        }
        catch (EnumeratorException e) {
            throw new RuntimeException(e.toString());
        }
        catch (NoSuchObjectException e) {
            throw new IllegalStateException("Cannot access finder result outside transaction");
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public synchronized boolean hasMoreElementsR() throws RemoteException, EnumeratorException {
        if (this.elements != null && this.index < this.elements.length) {
            return true;
        }
        if (!this.exhausted) {
            try {
                this.elements = null;
                this.index = 0;
                this.elements = this.fetchElements(25);
                return true;
            }
            catch (NoMoreElementsException ex) {
                return false;
            }
        }
        return false;
    }

    public synchronized Object nextElementR() throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        return this.elements[this.index++];
    }

    public synchronized Object[] nextNElements(int n) throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        EJBObject[] remainder = null;
        int numCached = this.elements.length - this.index;
        if (!this.exhausted && numCached < n) {
            try {
                remainder = this.fetchElements(n - numCached);
            }
            catch (NoMoreElementsException ex) {
                // empty catch block
            }
        }
        int numRemaining = remainder != null ? remainder.length : 0;
        int totalAvail = numCached + numRemaining;
        int numToReturn = Math.min(n, totalAvail);
        Object[] result = new EJBObject[numToReturn];
        int numFromCache = Math.min(numToReturn, numCached);
        System.arraycopy(this.elements, this.index, result, 0, numFromCache);
        this.index += numFromCache;
        if (remainder != null) {
            System.arraycopy(remainder, 0, result, numFromCache, numRemaining);
        }
        return result;
    }

    public int size() {
        this.loadEntireCollection();
        if (this.elements == null) {
            return 0;
        }
        return this.elements.length;
    }

    public EJBObject[] loadEntireCollection() {
        EJBObject[] result = null;
        try {
            result = (EJBObject[])this.allRemainingElements();
        }
        catch (NoMoreElementsException e) {
            return this.elements;
        }
        catch (EnumeratorException e) {
            throw new RuntimeException(e.toString());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
        this.elements = result;
        return result;
    }

    public synchronized Object[] allRemainingElements() throws RemoteException, EnumeratorException {
        if (!this.hasMoreElementsR()) {
            throw new NoMoreElementsException();
        }
        EJBObject[] remainder = null;
        if (!this.exhausted) {
            try {
                remainder = this.enum.allRemainingElements();
            }
            catch (NoMoreElementsException ex) {
            }
            catch (NoSuchObjectException exc) {
                throw new CollectionCannotBeFurtherAccessedException();
            }
            finally {
                this.exhausted = true;
                this.enum = null;
            }
        }
        int numCached = this.elements.length - this.index;
        int numRemaining = remainder != null ? remainder.length : 0;
        Object[] result = new EJBObject[numCached + numRemaining];
        System.arraycopy(this.elements, this.index, result, 0, numCached);
        if (remainder != null) {
            System.arraycopy(remainder, 0, result, numCached, numRemaining);
        }
        this.elements = null;
        return result;
    }

    private final EJBObject[] fetchElements(int count) throws RemoteException, EnumeratorException {
        EJBObject[] batch = null;
        try {
            if (this.enum != null) {
                batch = this.enum.nextNElements(count);
            }
            EJBObject[] eJBObjectArray = batch;
            return eJBObjectArray;
        }
        catch (NoMoreElementsException ex) {
            throw ex;
        }
        catch (NoSuchObjectException exc) {
            throw new CollectionCannotBeFurtherAccessedException();
        }
        finally {
            if (batch == null || batch.length < count) {
                this.exhausted = true;
                this.enum = null;
            }
        }
    }
}

