/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.serialization;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

public abstract class BaseXMLResourceImpl
extends XMLResourceImpl {
    private static final int ROOT_FEATURE_INDEX = 3;
    protected String defaultNamespacePrefix;

    public BaseXMLResourceImpl(URI uri) {
        super(uri);
    }

    public String getDefaultNamespacePrefix() {
        return this.defaultNamespacePrefix != null ? this.defaultNamespacePrefix : "";
    }

    public EObject getRootObject() {
        EList resourceContents = this.getContents();
        EObject rootObject = null;
        if (resourceContents.size() == 1) {
            EObject documentRoot = (EObject)resourceContents.get(0);
            EStructuralFeature rootFeature = this.getRootFeature();
            rootObject = (EObject)documentRoot.eGet(rootFeature);
        }
        return rootObject;
    }

    public void setDefaultNamespacePrefix(String namespacePrefix) {
        this.defaultNamespacePrefix = namespacePrefix;
    }

    protected EObject createDocumentRoot() {
        EFactoryImpl factory = new EFactoryImpl(){

            public EPackage getEPackage() {
                return BaseXMLResourceImpl.this.getEPackage();
            }
        };
        EClass documentRootEClass = this.getDocumentRootEClass();
        EObject documentRoot = factory.create(documentRootEClass);
        Map defaultSaveOptions = this.getDefaultSaveOptions();
        ExtendedMetaData extendedMetaData = (ExtendedMetaData)defaultSaveOptions.get("EXTENDED_META_DATA");
        EReference xmlnsPrefixMapFeature = extendedMetaData.getXMLNSPrefixMapFeature(documentRootEClass);
        EMap prefixMap = (EMap)documentRoot.eGet(xmlnsPrefixMapFeature);
        String defaultNamespaceURI = this.getDefaultNamespaceURI();
        String defaultPrefix = this.getDefaultNamespacePrefix();
        prefixMap.put(defaultPrefix, defaultNamespaceURI);
        EReference xsiSchemaLocationFeature = extendedMetaData.getXSISchemaLocationMapFeature(documentRootEClass);
        EMap xsiSchemaLocationMap = (EMap)documentRoot.eGet(xsiSchemaLocationFeature);
        String schemaLocationURI = this.getSchemaLocationURI();
        xsiSchemaLocationMap.put(defaultNamespaceURI, schemaLocationURI);
        return documentRoot;
    }

    protected abstract XMLHelper createXMLHelper();

    protected abstract XMLLoad createXMLLoad();

    protected abstract XMLSave createXMLSave();

    protected abstract String getDefaultNamespaceURI();

    protected EClass getDocumentRootEClass() {
        EPackage pkg = this.getEPackage();
        EClass documentRootEClass = (EClass)pkg.getEClassifier("DocumentRoot");
        return documentRootEClass;
    }

    protected abstract EPackage getEPackage();

    protected EStructuralFeature getRootFeature() {
        EClass documentRootEClass = this.getDocumentRootEClass();
        EList allStructuralFeatures = documentRootEClass.getEAllStructuralFeatures();
        EStructuralFeature rootFeature = (EStructuralFeature)allStructuralFeatures.get(3);
        return rootFeature;
    }

    protected abstract String getSchemaLocationURI();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertDocumentRoot() {
        try {
            this.eSetDeliver(false);
            EList contents = this.getContents();
            EObject rootObject = (EObject)contents.get(0);
            contents.remove(0);
            EObject documentRoot = this.createDocumentRoot();
            EStructuralFeature rootFeature = this.getRootFeature();
            documentRoot.eSet(rootFeature, rootObject);
            this.getContents().add(documentRoot);
        }
        finally {
            this.eSetDeliver(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDocumentRoot() {
        try {
            this.eSetDeliver(false);
            EList contents = this.getContents();
            EObject rootObject = this.getRootObject();
            contents.remove(0);
            if (rootObject != null) {
                contents.add(rootObject);
            }
        }
        finally {
            this.eSetDeliver(true);
        }
    }
}

