/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.ejbext.serialization;

import com.ibm.ejs.models.base.extensions.commonext.serialization.CommonextXMLSaveImpl;
import com.ibm.ejs.models.base.extensions.ejbext.AppliedAccessIntent;
import com.ibm.ejs.models.base.extensions.ejbext.CollectionScope;
import com.ibm.ejs.models.base.extensions.ejbext.DataCache;
import com.ibm.ejs.models.base.extensions.ejbext.EjbextPackage;
import com.ibm.ejs.models.base.extensions.ejbext.Identity;
import com.ibm.ejs.models.base.extensions.ejbext.LifetimeInCacheUsageKind;
import com.ibm.ejs.models.base.extensions.ejbext.PersistenceSecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.PessimisticUpdate;
import com.ibm.ejs.models.base.extensions.ejbext.PessimisticUpdateHint;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsMode;
import com.ibm.ejs.models.base.extensions.ejbext.RunAsSpecifiedIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.SecurityIdentity;
import com.ibm.ejs.models.base.extensions.ejbext.serialization.CacheLifetimeConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodElementKind;

public class EjbextXMLSaveImpl
extends CommonextXMLSaveImpl {
    protected static final Map collectionScopeEClassToLiteralMap = new HashMap();
    protected static final Map eClassToElementNameMap = new HashMap();
    protected static final Logger logger = Logger.getLogger("com.ibm.ejs.models.base.extensions.ejbext.serialization", "com.ibm.ejs.models.base.extensions.ejbext.serialization.messages");
    protected static final Map modeEClassToLiteralMap = new HashMap();
    protected static final EjbextPackage pkg = EjbextPackage.eINSTANCE;

    public EjbextXMLSaveImpl(XMLHelper helper) {
        super(helper);
    }

    protected void endSaveFeatures(EObject o, int elementType, String content) {
        if (pkg.getAppliedAccessIntent().isSuperTypeOf(o.eClass())) {
            AppliedAccessIntent appliedAccessIntent = (AppliedAccessIntent)o;
            EList methodElements = appliedAccessIntent.getMethodElements();
            if (methodElements.size() == 1 && ((MethodElement)methodElements.get(0)).getType() == MethodElementKind.UNSPECIFIED_LITERAL) {
                this.doc.startElement(this.getElementName("ejb"));
                this.doc.addAttribute("name", ((MethodElement)methodElements.get(0)).getEnterpriseBean().getName());
                this.doc.endElement();
            } else {
                Map methodsByBean = this.splitMethodsByBean(methodElements);
                for (EnterpriseBean bean : methodsByBean.keySet()) {
                    this.doc.startElement(this.getElementName("ejb"));
                    this.doc.addAttribute("name", bean.getName());
                    List methods = (List)methodsByBean.get(bean);
                    for (MethodElement methodElement : methods) {
                        this.saveElement(methodElement, (EStructuralFeature)pkg.getAppliedAccessIntent_MethodElements());
                    }
                    this.doc.endElement();
                }
            }
        }
        super.endSaveFeatures(o, elementType, content);
    }

    protected String getCollectionScopeLiteral(EClass collectionScope) {
        return (String)collectionScopeEClassToLiteralMap.get(collectionScope);
    }

    protected String getElementNameByEClass(EClass eClass) {
        return (String)eClassToElementNameMap.get(eClass);
    }

    protected String getMode(EClass runAsModeEClass) {
        return (String)modeEClassToLiteralMap.get(runAsModeEClass);
    }

    protected void saveContainedMany(EObject o, EStructuralFeature f) {
        if (pkg.getAppliedAccessIntent_MethodElements() == f || pkg.getEJBJarExtension_EjbRelationships() == f || pkg.getContainerManagedEntityExtension_LocalRelationshipRoles() == f) {
            return;
        }
        super.saveContainedMany(o, f);
    }

    protected void saveDataTypeElementSingle(EObject o, EStructuralFeature f) {
        if (pkg.getEntityExtension_DisableFlushBeforeFind() == f || pkg.getEntityExtension_LightweightLocal() == f || pkg.getEnterpriseBeanExtension_StartEJBAtApplicationStart() == f || pkg.getSessionExtension_Timeout() == f || pkg.getContainerManagedEntityExtension_DisableEJBStoreForNonDirtyBeans() == f) {
            this.createElementWithAttribute(o, f, "value");
        } else if (pkg.getContainerManagedEntityExtension_ConcurrencyControl() == f || pkg.getSessionExtension_ActivitySessionType() == f) {
            this.createElementWithAttribute(o, f, "type");
        } else if (pkg.getDataCache_LifetimeInCacheUsage() == f) {
            Object value = this.helper.getValue(o, f);
            String elementName = null;
            if (value == LifetimeInCacheUsageKind.CLOCK_TIME_LITERAL) {
                elementName = "clock-time";
            } else if (value == LifetimeInCacheUsageKind.WEEK_TIME_LITERAL) {
                elementName = "week-time";
            } else if (value == LifetimeInCacheUsageKind.ELAPSED_TIME_LITERAL) {
                elementName = "elapsed-time";
            } else {
                logger.logp(Level.SEVERE, this.getClass().getName(), "saveDataTypeElementSingle", "Ejbext.6", new Object[]{value});
            }
            DataCache dataCache = (DataCache)o;
            long lifetimeInCache = dataCache.getLifetimeInCache();
            CacheLifetimeConverter converter = new CacheLifetimeConverter(lifetimeInCache, (LifetimeInCacheUsageKind)value);
            this.doc.startElement(this.getElementName(elementName));
            if (value == LifetimeInCacheUsageKind.ELAPSED_TIME_LITERAL) {
                this.doc.addAttribute("days", converter.getDays());
            } else if (value == LifetimeInCacheUsageKind.WEEK_TIME_LITERAL) {
                this.doc.addAttribute("day", converter.getDayOfWeek().getLiteral());
            }
            this.doc.addAttribute("hours", converter.getHours());
            this.doc.addAttribute("minutes", converter.getMinutes());
            this.doc.addAttribute("seconds", converter.getSeconds());
            this.doc.endElement();
        } else {
            if (EjbextPackage.eINSTANCE.getTimeoutScope_FinderDuration() == f) {
                Object value = this.helper.getValue(o, f);
                String svalue = this.getDatatypeValue(value, f, false);
                this.doc.startElement(this.getElementName("time-out"));
                this.doc.addAttribute("value", svalue);
                this.doc.endElement();
                return;
            }
            super.saveDataTypeElementSingle(o, f);
        }
    }

    protected void saveDataTypeSingle(EObject o, EStructuralFeature f) {
        if (pkg.getDataCache_LifetimeInCache() == f || EcorePackage.eINSTANCE.getENamedElement_Name() == f) {
            return;
        }
        super.saveDataTypeSingle(o, f);
    }

    protected void saveElement(EObject o, EStructuralFeature f) {
        EClass eClass = o.eClass();
        String elementName = this.getElementNameByEClass(eClass);
        if (elementName != null) {
            this.doc.startElement(this.getElementName(elementName));
            this.saveElementID(o);
        } else if (pkg.getAppliedAccessIntent().isSuperTypeOf(eClass)) {
            AppliedAccessIntent appliedAccessIntent = (AppliedAccessIntent)o;
            EList methodElements = appliedAccessIntent.getMethodElements();
            if (methodElements.size() == 1 && ((MethodElement)methodElements.get(0)).getType() == MethodElementKind.UNSPECIFIED_LITERAL) {
                this.doc.startElement(this.getElementName("bean-level-access-intent"));
            } else {
                this.doc.startElement(this.getElementName("method-level-access-intent"));
            }
            this.saveElementID(o);
        } else if (pkg.getCollectionScope().isSuperTypeOf(eClass)) {
            this.doc.startElement(this.getElementName("collection-scope"));
            this.saveElementID(o);
        } else if (pkg.getRunAsSpecifiedIdentity() == eClass) {
            this.doc.startElement(this.getElementName("specified-identity"));
            RunAsSpecifiedIdentity runAs = (RunAsSpecifiedIdentity)o;
            Identity identity = runAs.getRunAsSpecifiedIdentity();
            if (identity != null) {
                String roleName = identity.getRoleName();
                this.doc.addAttribute("role", roleName);
                String description = identity.getDescription();
                if (description != null) {
                    this.doc.addAttribute("description", description);
                }
            }
            this.doc.endEmptyElement();
        } else {
            if (pkg.getUseCallerIdentity() == eClass || pkg.getUseSystemIdentity() == eClass) {
                return;
            }
            super.saveElement(o, f);
        }
    }

    protected void saveElementReferenceSingle(EObject o, EStructuralFeature f) {
        if (EjbPackage.eINSTANCE.getMethodElement_EnterpriseBean() == f) {
            return;
        }
        super.saveElementReferenceSingle(o, f);
    }

    protected void saveEObjectSingle(EObject o, EStructuralFeature f) {
        if (pkg.getEnterpriseBeanExtension_EnterpriseBean() == f) {
            EObject value = (EObject)this.helper.getValue(o, f);
            EnterpriseBean enterpriseBean = (EnterpriseBean)value;
            String name = enterpriseBean.getName();
            if (name != null) {
                this.doc.addAttribute("name", name);
            } else {
                logger.logp(Level.SEVERE, this.getClass().getName(), "saveEObjectSingle", "Ejbext.5");
            }
        } else if (pkg.getEjbGeneralization_Subtype() == f || pkg.getEjbGeneralization_Supertype() == f) {
            EObject value = (EObject)this.helper.getValue(o, f);
            EnterpriseBean enterpriseBean = (EnterpriseBean)value;
            String name = enterpriseBean.getName();
            if (name != null) {
                String attributeName = this.helper.getQName(f);
                this.doc.startAttribute(attributeName);
                this.doc.addAttributeContent(name);
                this.doc.endAttribute();
            } else {
                logger.logp(Level.SEVERE, this.getClass().getName(), "saveEObjectSingle", "Ejbext.5");
            }
        } else {
            super.saveEObjectSingle(o, f);
        }
    }

    protected boolean saveFeatures(EObject o) {
        PessimisticUpdate pessimisticUpdate;
        PessimisticUpdateHint hint;
        this.forceSaveAttribute(o, pkg.getEJBCMPSequenceGroup(), pkg.getEJBCMPSequenceGroup_Type());
        this.forceSaveAttribute(o, pkg.getVerifyReadOnlyData(), pkg.getVerifyReadOnlyData_VerifyReadOnlyData());
        this.forceSaveAttribute(o, pkg.getDeferredOperation(), pkg.getDeferredOperation_DeferredOperation());
        this.forceSaveAttribute(o, pkg.getPartialOperation(), pkg.getPartialOperation_PartialOperation());
        this.forceSaveAttribute(o, pkg.getPartialOperation(), pkg.getPartialOperation_Group());
        this.forceSaveAttribute(o, pkg.getCollectionAccessPattern(), pkg.getCollectionAccessPattern_AccessPattern());
        if (o instanceof PersistenceSecurityIdentity) {
            PersistenceSecurityIdentity persistenceSecurityIdentity = (PersistenceSecurityIdentity)o;
            RunAsMode runAsMode = persistenceSecurityIdentity.getRunAsMode();
            String modeValue = this.getMode(runAsMode.eClass());
            if (modeValue != null) {
                this.doc.addAttribute("mode", modeValue);
            }
        } else if (o instanceof SecurityIdentity) {
            SecurityIdentity securityIdentity = (SecurityIdentity)o;
            RunAsMode runAsMode = securityIdentity.getRunAsMode();
            String modeValue = this.getMode(runAsMode.eClass());
            if (modeValue != null) {
                this.doc.addAttribute("mode", modeValue);
            }
        } else if (o instanceof CollectionScope) {
            String type = this.getCollectionScopeLiteral(o.eClass());
            if (type != null) {
                this.doc.addAttribute("type", type);
            } else {
                logger.logp(Level.SEVERE, this.getClass().getName(), "saveFeatures", "Ejbext.6", new Object[]{o.eClass().getName()});
            }
        } else if (o instanceof PessimisticUpdate && (hint = (pessimisticUpdate = (PessimisticUpdate)o).getHint()) != null) {
            return super.saveFeatures(hint);
        }
        return super.saveFeatures(o);
    }

    protected void saveHref(EObject remote, EStructuralFeature f) {
        if (remote instanceof ContainerManagedEntity) {
            ContainerManagedEntity entity = (ContainerManagedEntity)remote;
            this.doc.startElement(this.getElementName("container-managed-entity"));
            this.doc.addAttribute("name", entity.getName());
            this.doc.endElement();
            return;
        }
        super.saveHref(remote, f);
    }

    protected void saveHRefSingle(EObject o, EStructuralFeature f) {
        if (pkg.getEJBJarExtension_EjbJar() == f) {
            return;
        }
        super.saveHRefSingle(o, f);
    }

    protected void saveTypeAttribute(EClass eClass) {
        EClass finderDescriptorEClass = pkg.getFinderDescriptor();
        boolean isFinderDescriptor = finderDescriptorEClass.isSuperTypeOf(eClass);
        if (isFinderDescriptor) {
            return;
        }
        EClass accessIntentEntryEClass = pkg.getAccessIntentEntry();
        boolean isAccessIntentEntry = accessIntentEntryEClass.isSuperTypeOf(eClass);
        if (isAccessIntentEntry) {
            return;
        }
        EClass runAsModeEClass = pkg.getRunAsMode();
        boolean isRunAsMode = runAsModeEClass.isSuperTypeOf(eClass);
        if (isRunAsMode) {
            return;
        }
        super.saveTypeAttribute(eClass);
    }

    protected Map splitMethodsByBean(List methodElements) {
        TreeMap<EnterpriseBean, ArrayList<MethodElement>> methodsByBean = new TreeMap<EnterpriseBean, ArrayList<MethodElement>>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EnterpriseBean bean1 = (EnterpriseBean)arg0;
                EnterpriseBean bean2 = (EnterpriseBean)arg1;
                String bean1Name = bean1.getName();
                String bean2Name = bean2.getName();
                return bean1Name.compareTo(bean2Name);
            }
        });
        for (MethodElement methodElement : methodElements) {
            EnterpriseBean bean = methodElement.getEnterpriseBean();
            ArrayList<MethodElement> methods = (ArrayList<MethodElement>)methodsByBean.get(bean);
            if (methods == null) {
                methods = new ArrayList<MethodElement>();
                methodsByBean.put(bean, methods);
            }
            methods.add(methodElement);
        }
        return methodsByBean;
    }

    static {
        modeEClassToLiteralMap.put(pkg.getUseCallerIdentity(), "CALLER_IDENTITY");
        modeEClassToLiteralMap.put(pkg.getRunAsSpecifiedIdentity(), "SPECIFIED_IDENTITY");
        modeEClassToLiteralMap.put(pkg.getUseSystemIdentity(), "SYSTEM_IDENTITY");
        collectionScopeEClassToLiteralMap.put(pkg.getSessionScope(), "SESSION");
        collectionScopeEClassToLiteralMap.put(pkg.getTransactionScope(), "TRANSACTION");
        collectionScopeEClassToLiteralMap.put(pkg.getTimeoutScope(), "TIMEOUT");
        eClassToElementNameMap.put(pkg.getMessageDrivenExtension(), "message-driven");
        eClassToElementNameMap.put(pkg.getSessionExtension(), "session");
        eClassToElementNameMap.put(pkg.getContainerManagedEntityExtension(), "container-managed-entity");
        eClassToElementNameMap.put(pkg.getEntityExtension(), "entity");
        eClassToElementNameMap.put(pkg.getOptimisticRead(), "optimistic-read");
        eClassToElementNameMap.put(pkg.getOptimisticUpdate(), "optimistic-update");
        eClassToElementNameMap.put(pkg.getPessimisticRead(), "pessimistic-read");
        eClassToElementNameMap.put(pkg.getPessimisticUpdate(), "pessimistic-update");
        eClassToElementNameMap.put(pkg.getCollectionAccessPattern(), "collection-access-pattern");
        eClassToElementNameMap.put(pkg.getCollectionIncrement(), "collection-increment");
        eClassToElementNameMap.put(pkg.getVerifyReadOnlyData(), "verify-read-only-data");
        eClassToElementNameMap.put(pkg.getDeferredOperation(), "deferred-operation");
        eClassToElementNameMap.put(pkg.getPartialOperation(), "partial-operation");
        eClassToElementNameMap.put(pkg.getReadAheadHint(), "read-ahead-hint");
        eClassToElementNameMap.put(pkg.getResourceManagerPreFetchIncrement(), "resource-manager-prefetch-increment");
        eClassToElementNameMap.put(pkg.getWhereClauseFinderDescriptor(), "where-clause-finder");
        eClassToElementNameMap.put(pkg.getEjbqlFinderDescriptor(), "ejbql-finder");
        eClassToElementNameMap.put(pkg.getFullSelectFinderDescriptor(), "full-select-finder");
        eClassToElementNameMap.put(pkg.getUserFinderDescriptor(), "user-finder");
    }
}

