/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.applicationext.impl;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationextFactory;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationextPackage;
import com.ibm.ejs.models.base.extensions.applicationext.ConnectorModuleExtension;
import com.ibm.ejs.models.base.extensions.applicationext.EjbModuleExtension;
import com.ibm.ejs.models.base.extensions.applicationext.JavaClientModuleExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import com.ibm.ejs.models.base.extensions.applicationext.WebModuleExtension;
import com.ibm.ejs.models.base.extensions.applicationext.impl.ApplicationExtensionImpl;
import com.ibm.ejs.models.base.extensions.applicationext.impl.ConnectorModuleExtensionImpl;
import com.ibm.ejs.models.base.extensions.applicationext.impl.EjbModuleExtensionImpl;
import com.ibm.ejs.models.base.extensions.applicationext.impl.JavaClientModuleExtensionImpl;
import com.ibm.ejs.models.base.extensions.applicationext.impl.WebModuleExtensionImpl;
import com.ibm.ejs.models.base.extensions.applicationext.util.ApplicationExtensionCoreSynchronizeAdapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;

public class ApplicationextFactoryImpl
extends EFactoryImpl
implements ApplicationextFactory {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public static ApplicationextFactory init() {
        try {
            ApplicationextFactory theApplicationextFactory = (ApplicationextFactory)EPackage.Registry.INSTANCE.getEFactory("applicationext.xmi");
            if (theApplicationextFactory != null) {
                return theApplicationextFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log(exception);
        }
        return new ApplicationextFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createApplicationExtension();
            }
            case 2: {
                return this.createWebModuleExtension();
            }
            case 3: {
                return this.createJavaClientModuleExtension();
            }
            case 4: {
                return this.createEjbModuleExtension();
            }
            case 5: {
                return this.createConnectorModuleExtension();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public ModuleExtension createModuleExtension(Module aModule) {
        if (aModule == null) {
            return null;
        }
        ModuleExtension ext = null;
        if (aModule.isEjbModule()) {
            ext = this.createEjbModuleExtension();
        } else if (aModule.isWebModule()) {
            ext = this.createWebModuleExtension();
        } else if (aModule.isJavaModule()) {
            ext = this.createJavaClientModuleExtension();
        } else if (aModule.isConnectorModule()) {
            ext = this.createConnectorModuleExtension();
        }
        if (ext != null) {
            ext.setModule(aModule);
        }
        return ext;
    }

    public static ApplicationextFactory getActiveFactory() {
        return (ApplicationextFactory)ApplicationextFactoryImpl.getPackage().getEFactoryInstance();
    }

    public ApplicationExtension createApplicationExtension() {
        ApplicationExtension applicationExtension = this.createApplicationExtensionGen();
        ExtendedEcoreUtil.createAdapterForLoading(new ApplicationExtensionCoreSynchronizeAdapter(), applicationExtension);
        return applicationExtension;
    }

    public ApplicationExtension createApplicationExtensionGen() {
        ApplicationExtensionImpl applicationExtension = new ApplicationExtensionImpl();
        return applicationExtension;
    }

    public WebModuleExtension createWebModuleExtension() {
        WebModuleExtensionImpl webModuleExtension = new WebModuleExtensionImpl();
        return webModuleExtension;
    }

    public JavaClientModuleExtension createJavaClientModuleExtension() {
        JavaClientModuleExtensionImpl javaClientModuleExtension = new JavaClientModuleExtensionImpl();
        return javaClientModuleExtension;
    }

    public EjbModuleExtension createEjbModuleExtension() {
        EjbModuleExtensionImpl ejbModuleExtension = new EjbModuleExtensionImpl();
        return ejbModuleExtension;
    }

    public ConnectorModuleExtension createConnectorModuleExtension() {
        ConnectorModuleExtensionImpl connectorModuleExtension = new ConnectorModuleExtensionImpl();
        return connectorModuleExtension;
    }

    public ApplicationextPackage getApplicationextPackage() {
        return (ApplicationextPackage)this.getEPackage();
    }

    public static ApplicationextPackage getPackage() {
        return ApplicationextPackage.eINSTANCE;
    }
}

