/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.bindings.applicationbnd.serialization;

import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndFactory;
import com.ibm.ejs.models.base.bindings.applicationbnd.ApplicationbndPackage;
import com.ibm.ejs.models.base.bindings.applicationbnd.AuthorizationTable;
import com.ibm.ejs.models.base.bindings.applicationbnd.ProfileBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.ProfileMap;
import com.ibm.ejs.models.base.bindings.applicationbnd.RoleAssignment;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsBinding;
import com.ibm.ejs.models.base.bindings.applicationbnd.RunAsMap;
import com.ibm.ejs.models.base.bindings.applicationbnd.SpecialSubject;
import com.ibm.ejs.models.base.bindings.applicationbnd.User;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.AllAuthenticatedInTrustedRealmsImpl;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.AllAuthenticatedUsersImpl;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.EveryoneImpl;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.ServerImpl;
import com.ibm.ejs.models.base.bindings.applicationbnd.impl.SpecialSubjectImpl;
import com.ibm.ejs.models.base.bindings.applicationbnd.serialization.Messages;
import com.ibm.ejs.models.base.bindings.commonbnd.BasicAuthData;
import com.ibm.ejs.models.base.bindings.commonbnd.CommonbndFactory;
import com.ibm.ejs.models.base.serialization.BaseSAXXMLHandler;
import com.ibm.ejs.models.base.serialization.BaseXMLResourceImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.common.internal.impl.SecurityRoleImpl;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.wst.common.internal.emf.utilities.EncoderDecoderRegistry;

public class ApplicationbndSAXXMLHandler
extends BaseSAXXMLHandler {
    protected static final ApplicationbndPackage pkg = ApplicationbndPackage.eINSTANCE;
    protected static final Map specialSubjectToEClassNameMap = new HashMap();
    private static final Logger logger = Logger.getLogger("com.ibm.ejs.models.base.bindings.applicationbnd.serialization", "com.ibm.ejs.models.base.bindings.applicationbnd.serialization.messages");

    public ApplicationbndSAXXMLHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
    }

    public void endElement(String uri, String localName, String name) {
        if ("run-as".equals(localName)) {
            return;
        }
        if ("user".equals(localName)) {
            return;
        }
        super.endElement(uri, localName, name);
        if ("security-role".equals(localName) || "profile".equals(localName)) {
            super.endElement(uri, "", "");
        }
    }

    protected EObject createObjectFromFactory(EFactory factory, String typeName) {
        String specialSubjectClassName = pkg.getSpecialSubject().getName();
        if (specialSubjectClassName.equals(typeName)) {
            String specialSubjectTypeName;
            String type = this.attribs.getValue("", "type");
            if (type == null) {
                logger.logp(Level.SEVERE, this.getClass().getName(), "createObjectFromFactory", "Applicationbnd.2", new Object[]{typeName, this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
            }
            if ((specialSubjectTypeName = this.getSpecialSubjectTypeName(type)) != null) {
                EObject eo = super.createObjectFromFactory(factory, specialSubjectTypeName);
                if (!(eo instanceof SpecialSubjectImpl)) {
                    logger.logp(Level.SEVERE, this.getClass().getName(), "createObjectFromFactory", "Applicationbnd.0", new Object[]{type, this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
                    throw new IllegalArgumentException(Messages.getString("Applicationbnd.0.1"));
                }
                SpecialSubjectImpl ss = (SpecialSubjectImpl)super.createObjectFromFactory(factory, specialSubjectTypeName);
                if (ss instanceof AllAuthenticatedInTrustedRealmsImpl) {
                    ss.setName("AllAuthenticatedInTrustedRealms");
                    ss.setAccessId("AllAuthenticatedInTrustedRealms");
                } else if (ss instanceof EveryoneImpl) {
                    ss.setName("Everyone");
                    ss.setAccessId("Everyone");
                } else if (ss instanceof AllAuthenticatedUsersImpl) {
                    ss.setName("AllAuthenticatedUsers");
                    ss.setAccessId("AllAuthenticatedUsers");
                } else if (ss instanceof ServerImpl) {
                    ss.setName("Server");
                    ss.setAccessId("Server");
                } else {
                    logger.logp(Level.SEVERE, this.getClass().getName(), "createObjectFromFactory", "Applicationbnd.0", new Object[]{type, this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
                    throw new IllegalArgumentException(Messages.getString("Applicationbnd.0.1"));
                }
                return ss;
            }
            logger.logp(Level.SEVERE, this.getClass().getName(), "createObjectFromFactory", "Applicationbnd.0", new Object[]{type, this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
            throw new IllegalArgumentException(Messages.getString("Applicationbnd.0.1"));
        }
        return super.createObjectFromFactory(factory, typeName);
    }

    protected ApplicationBinding getApplicationBinding() {
        BaseXMLResourceImpl resource = (BaseXMLResourceImpl)this.xmlResource;
        ApplicationBinding applicationBinding = (ApplicationBinding)resource.getRootObject();
        return applicationBinding;
    }

    protected URI getDDUriSuffix() {
        return J2EEConstants.APPLICATION_DD_URI_OBJ;
    }

    protected String getRootElementName() {
        return "application-bnd";
    }

    protected String getSpecialSubjectTypeName(String specialSubject) {
        return (String)specialSubjectToEClassNameMap.get(specialSubject);
    }

    protected boolean isRootObject(EObject object) {
        return object instanceof ApplicationBinding;
    }

    protected void processElement(String name, String prefix, String localName) {
        if ("security-role".equals(localName)) {
            EObject object = (EObject)this.objects.peek();
            if (object instanceof ApplicationBinding) {
                AuthorizationTable authorizationTable = ((ApplicationBinding)object).getAuthorizationTable();
                this.helper.pushContext();
                if (authorizationTable == null) {
                    this.handleFeature(prefix, pkg.getApplicationBinding_AuthorizationTable().getName());
                } else {
                    this.processObject(authorizationTable);
                }
                object = (EObject)this.objects.peek();
                if (object instanceof AuthorizationTable) {
                    this.handleFeature(prefix, localName);
                }
            }
        } else if ("profile".equals(localName)) {
            EObject object = (EObject)this.objects.peek();
            if (object instanceof ApplicationBinding) {
                ProfileMap profileMap = ((ApplicationBinding)object).getProfileMap();
                this.helper.pushContext();
                if (profileMap == null) {
                    this.handleFeature(prefix, pkg.getApplicationBinding_ProfileMap().getName());
                } else {
                    this.processObject(profileMap);
                }
                object = (EObject)this.objects.peek();
                if (object instanceof ProfileMap) {
                    this.handleFeature(prefix, localName);
                }
            }
        } else if ("run-as".equals(localName)) {
            boolean shouldRemoveRoleAssignment;
            ApplicationBinding applicationBinding = this.getApplicationBinding();
            RunAsMap runAsMap = applicationBinding.getRunAsMap();
            if (runAsMap == null) {
                runAsMap = ApplicationbndFactory.eINSTANCE.createRunAsMap();
                applicationBinding.setRunAsMap(runAsMap);
            }
            RoleAssignment roleAssignment = (RoleAssignment)this.objects.peek();
            SecurityRole securityRole = roleAssignment.getRole();
            RunAsBinding runAsBinding = ApplicationbndFactory.eINSTANCE.createRunAsBinding();
            runAsBinding.setSecurityRole(securityRole);
            BasicAuthData basicAuthData = CommonbndFactory.eINSTANCE.createBasicAuthData();
            String userId = this.attribs.getValue("", "userid");
            if (userId != null) {
                basicAuthData.setUserId(userId);
            } else {
                logger.logp(Level.WARNING, this.getClass().getName(), "processElement", "Applicationbnd.3", new Object[]{"userid", this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
            }
            String password = this.attribs.getValue("", "password");
            if (password != null) {
                basicAuthData.setPassword(this.decodeString(password));
            } else {
                logger.logp(Level.WARNING, this.getClass().getName(), "processElement", "Applicationbnd.3", new Object[]{"password", this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
            }
            runAsBinding.setAuthData(basicAuthData);
            runAsMap.getRunAsBindings().add(runAsBinding);
            boolean bl = shouldRemoveRoleAssignment = roleAssignment.getGroups().isEmpty() && roleAssignment.getUsers().isEmpty() && roleAssignment.getSpecialSubjects().isEmpty();
            if (shouldRemoveRoleAssignment) {
                AuthorizationTable authorizationTable = applicationBinding.getAuthorizationTable();
                EList authorizations = authorizationTable.getAuthorizations();
                authorizations.remove(roleAssignment);
            }
        } else if ("user".equals(localName)) {
            EObject object = (EObject)this.objects.peek();
            if (object instanceof RoleAssignment) {
                RoleAssignment roleAssignment = (RoleAssignment)object;
                SecurityRole securityRole = roleAssignment.getRole();
                User user = ApplicationbndFactory.eINSTANCE.createUser();
                if (user != null) {
                    String userId = this.attribs.getValue("", "name");
                    if (userId != null) {
                        user.setName(userId);
                    } else {
                        logger.logp(Level.WARNING, this.getClass().getName(), "processElement", "Applicationbnd.3", new Object[]{"name", this.xmlResource.getURI(), String.valueOf(this.getLineNumber()), String.valueOf(this.getColumnNumber())});
                    }
                    String accessId = this.attribs.getValue("", "access-id");
                    if (accessId != null) {
                        user.setAccessId(accessId);
                    }
                    roleAssignment.getUsers().add(user);
                }
            }
        } else {
            super.processElement(name, prefix, localName);
        }
    }

    protected void setAttribValue(EObject object, String name, String value) {
        if (object instanceof ProfileMap || object instanceof AuthorizationTable || object instanceof SpecialSubject) {
            return;
        }
        if (object instanceof RoleAssignment && "name".equals(name)) {
            RoleAssignment roleAssignment = (RoleAssignment)object;
            roleAssignment.setRole(this.createSecurityRoleWithName(value));
            return;
        }
        super.setAttribValue(object, name, value);
    }

    protected void setDeploymentDescriptor(EObject deploymentDescriptor) {
        BaseXMLResourceImpl resource = (BaseXMLResourceImpl)this.xmlResource;
        ApplicationBinding applicationBinding = (ApplicationBinding)resource.getRootObject();
        applicationBinding.setApplication((Application)deploymentDescriptor);
    }

    protected void setFeatureValue(EObject object, EStructuralFeature feature, Object value, int position) {
        if (object instanceof ProfileBinding && pkg.getProfileBinding_ClientProfileNames() == feature) {
            String profileName = this.attribs.getValue("", "name");
            super.setFeatureValue(object, feature, profileName, position);
            return;
        }
        super.setFeatureValue(object, feature, value, position);
    }

    protected SecurityRole createSecurityRoleWithName(String name) {
        SecurityRoleImpl securityRole = (SecurityRoleImpl)CommonFactory.eINSTANCE.createSecurityRole();
        securityRole.setRoleName(name);
        securityRole.eSetProxyURI(URI.createURI(name));
        return securityRole;
    }

    protected String decodeString(String aString) {
        return EncoderDecoderRegistry.getDefaultRegistry().getDefaultEncoderDecoder().decode(aString);
    }

    static {
        specialSubjectToEClassNameMap.put("EVERYONE", pkg.getEveryone().getName());
        specialSubjectToEClassNameMap.put("ALL_AUTHENTICATED_USERS", pkg.getAllAuthenticatedUsers().getName());
        specialSubjectToEClassNameMap.put("ALL_AUTHENTICATED_IN_TRUSTED_REALMS", pkg.getAllAuthenticatedInTrustedRealms().getName());
        specialSubjectToEClassNameMap.put("SERVER", pkg.getServer().getName());
    }
}

