/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.jms.mq.pcf;

import com.ibm.ejs.jms.mq.pcf.CommandServer;
import com.ibm.ejs.jms.mq.pcf.CommunicationException;
import com.ibm.ejs.jms.mq.pcf.QueueDefinerException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ImplFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

public class CommandServerFactory {
    private static final String MQ_PCF_TRACE_MESSAGES = "com.ibm.ejs.jms.messaging";
    private static final TraceComponent tc = Tr.register(CommandServerFactory.class, "Messaging", "com.ibm.ejs.jms.messaging");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandServer createCommandServer(String qmgr) throws CommunicationException, QueueDefinerException {
        CommandServer commandServer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommandServer", qmgr);
        }
        CommandServer cs = null;
        try {
            Class csClass = ImplFactory.loadClassFromKey(CommandServer.class);
            Class[] params = new Class[]{String.class};
            Constructor construct = csClass.getConstructor(params);
            Object[] args = new Object[]{qmgr};
            commandServer = cs = (CommandServer)construct.newInstance(args);
        }
        catch (NoSuchMethodException nsme) {
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "createCommandServer", nsme);
                }
                FFDCFilter.processException((Throwable)nsme, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"95");
                throw new QueueDefinerException("PCFInternalQueueDefinerException");
                catch (IllegalAccessException iae) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", iae);
                    }
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"104");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
                catch (InstantiationException ie) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ie);
                    }
                    FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"113");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
                catch (InvocationTargetException ite) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ite);
                    }
                    FFDCFilter.processException((Throwable)ite, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"121");
                    if (ite.getTargetException() instanceof CommunicationException) {
                        throw (CommunicationException)ite.getTargetException();
                    }
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCommandServer", cs);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommandServer", cs);
        }
        return commandServer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandServer createCommandServer(String qmgrName, String hostName, int port, String channelName) throws CommunicationException, QueueDefinerException {
        CommandServer commandServer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommandServer", new Object[]{qmgrName, hostName, new Integer(port), channelName});
        }
        CommandServer cs = null;
        try {
            Class csClass = ImplFactory.loadClassFromKey(CommandServer.class);
            Class[] params = new Class[]{String.class, String.class, Integer.TYPE, String.class};
            Constructor construct = csClass.getConstructor(params);
            Object[] args = new Object[]{qmgrName, hostName, new Integer(port), channelName};
            commandServer = cs = (CommandServer)construct.newInstance(args);
        }
        catch (NoSuchMethodException nsme) {
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "createCommandServer", nsme);
                }
                FFDCFilter.processException((Throwable)nsme, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"172");
                throw new QueueDefinerException("PCFInternalQueueDefinerException");
                catch (IllegalAccessException iae) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", iae);
                    }
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"181");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
                catch (InstantiationException ie) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ie);
                    }
                    FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"190");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
                catch (InvocationTargetException ite) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ite);
                    }
                    FFDCFilter.processException((Throwable)ite, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"199");
                    if (ite.getTargetException() instanceof CommunicationException) {
                        throw (CommunicationException)ite.getTargetException();
                    }
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCommandServer", cs);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommandServer", cs);
        }
        return commandServer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandServer createCommandServer(String qmgrName, String hostName, int port, String channelName, String userName, String password) throws CommunicationException, QueueDefinerException {
        CommandServer commandServer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommandServer", new Object[]{qmgrName, hostName, new Integer(port), channelName, userName, "password not traced"});
        }
        CommandServer cs = null;
        try {
            Class csClass = ImplFactory.loadClassFromKey(CommandServer.class);
            Class[] params = new Class[]{String.class, String.class, Integer.TYPE, String.class, String.class, String.class};
            Constructor construct = csClass.getConstructor(params);
            Object[] args = new Object[]{qmgrName, hostName, new Integer(port), channelName, userName, password};
            commandServer = cs = (CommandServer)construct.newInstance(args);
        }
        catch (NoSuchMethodException nsme) {
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "createCommandServer", nsme);
                }
                FFDCFilter.processException((Throwable)nsme, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"277");
                throw new QueueDefinerException("PCFInternalQueueDefinerException");
                catch (IllegalAccessException iae) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", iae);
                    }
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"286");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
                catch (InstantiationException ie) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ie);
                    }
                    FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"295");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
                catch (InvocationTargetException ite) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ite);
                    }
                    FFDCFilter.processException((Throwable)ite, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"304");
                    if (ite.getTargetException() instanceof CommunicationException) {
                        throw (CommunicationException)ite.getTargetException();
                    }
                    throw new QueueDefinerException("PCFInternalQueueDefinerException");
                }
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCommandServer", cs);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommandServer", cs);
        }
        return commandServer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandServer createCommandServer(String qmgr, Locale locale) throws CommunicationException, QueueDefinerException {
        CommandServer commandServer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommandServer", new Object[]{qmgr, locale});
        }
        CommandServer cs = null;
        try {
            Class csClass = ImplFactory.loadClassFromKey(CommandServer.class);
            Class[] params = new Class[]{String.class, Locale.class};
            Constructor construct = csClass.getConstructor(params);
            Object[] args = new Object[]{qmgr, locale};
            commandServer = cs = (CommandServer)construct.newInstance(args);
        }
        catch (NoSuchMethodException nsme) {
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "createCommandServer", nsme);
                }
                FFDCFilter.processException((Throwable)nsme, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"95");
                throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                catch (IllegalAccessException iae) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", iae);
                    }
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"104");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
                catch (InstantiationException ie) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ie);
                    }
                    FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"113");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
                catch (InvocationTargetException ite) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ite);
                    }
                    FFDCFilter.processException((Throwable)ite, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"121");
                    if (ite.getTargetException() instanceof CommunicationException) {
                        throw (CommunicationException)ite.getTargetException();
                    }
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCommandServer", cs);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommandServer", cs);
        }
        return commandServer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandServer createCommandServer(String qmgrName, String hostName, int port, String channelName, Locale locale) throws CommunicationException, QueueDefinerException {
        CommandServer commandServer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommandServer", new Object[]{qmgrName, hostName, new Integer(port), channelName, locale});
        }
        CommandServer cs = null;
        try {
            Class csClass = ImplFactory.loadClassFromKey(CommandServer.class);
            Class[] params = new Class[]{String.class, String.class, Integer.TYPE, String.class, Locale.class};
            Constructor construct = csClass.getConstructor(params);
            Object[] args = new Object[]{qmgrName, hostName, new Integer(port), channelName, locale};
            commandServer = cs = (CommandServer)construct.newInstance(args);
        }
        catch (NoSuchMethodException nsme) {
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "createCommandServer", nsme);
                }
                FFDCFilter.processException((Throwable)nsme, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"172");
                throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                catch (IllegalAccessException iae) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", iae);
                    }
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"181");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
                catch (InstantiationException ie) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ie);
                    }
                    FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"190");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
                catch (InvocationTargetException ite) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ite);
                    }
                    FFDCFilter.processException((Throwable)ite, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"199");
                    if (ite.getTargetException() instanceof CommunicationException) {
                        throw (CommunicationException)ite.getTargetException();
                    }
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCommandServer", cs);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommandServer", cs);
        }
        return commandServer;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CommandServer createCommandServer(String qmgrName, String hostName, int port, String channelName, String userName, String password, Locale locale) throws CommunicationException, QueueDefinerException {
        CommandServer commandServer;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCommandServer", new Object[]{qmgrName, hostName, new Integer(port), channelName, userName, "password not traced", locale});
        }
        CommandServer cs = null;
        try {
            Class csClass = ImplFactory.loadClassFromKey(CommandServer.class);
            Class[] params = new Class[]{String.class, String.class, Integer.TYPE, String.class, String.class, String.class, Locale.class};
            Constructor construct = csClass.getConstructor(params);
            Object[] args = new Object[]{qmgrName, hostName, new Integer(port), channelName, userName, password, locale};
            commandServer = cs = (CommandServer)construct.newInstance(args);
        }
        catch (NoSuchMethodException nsme) {
            try {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "createCommandServer", nsme);
                }
                FFDCFilter.processException((Throwable)nsme, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"277");
                throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                catch (IllegalAccessException iae) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", iae);
                    }
                    FFDCFilter.processException((Throwable)iae, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"286");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
                catch (InstantiationException ie) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ie);
                    }
                    FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"295");
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
                catch (InvocationTargetException ite) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "createCommandServer", ite);
                    }
                    FFDCFilter.processException((Throwable)ite, (String)"com.ibm.ejs.jms.mq.pcf.CommandServerFactory.createCommandServer", (String)"304");
                    if (ite.getTargetException() instanceof CommunicationException) {
                        throw (CommunicationException)ite.getTargetException();
                    }
                    throw new QueueDefinerException("PCFInternalQueueDefinerException", locale);
                }
            }
            catch (Throwable throwable) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createCommandServer", cs);
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCommandServer", cs);
        }
        return commandServer;
    }
}

