/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.csi.EJBModuleMetaDataImpl;
import com.ibm.ejs.csi.TransactionControlImpl;
import com.ibm.ejs.csi.TxCookieImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSITransactionRequiredException;
import com.ibm.websphere.csi.CSITransactionRolledbackException;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.ExceptionType;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.uow.UOWSynchronizationRegistry;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.LocalTransaction.RolledbackException;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.WebSphereTransactionManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.traceinfo.ejbcontainer.TETxLifeCycleInfo;
import com.ibm.wsspi.uow.UOWManagerFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

abstract class TranStrategy {
    private static final String CLASS_NAME = TranStrategy.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private static final UOWSynchronizationRegistry svUOWSynchReg = UOWManagerFactory.getUOWManager();
    protected TransactionControlImpl txCtrl;
    protected LocalTransactionCurrent ltcCurrent;
    private WebSphereTransactionManager txManager = TransactionManagerFactory.getTransactionManager();

    protected TranStrategy(TransactionControlImpl txCtrl) {
        this.txCtrl = txCtrl;
        this.ltcCurrent = TransactionManagerFactory.getLocalTransactionCurrent();
    }

    abstract TxCookieImpl preInvoke(EJBKey var1, EJBMethodInfo var2) throws CSIException;

    void postInvoke(EJBKey key, TxCookieImpl cookie, EJBMethodInfo methodInfo) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "postInvoke");
        }
        if (cookie.beginner) {
            if (this.txCtrl.getRollbackOnly()) {
                this.rollback(true, key, methodInfo);
                MethodInterface methodType = methodInfo.getInterfaceType();
                EJBModuleMetaDataImpl mmd = (EJBModuleMetaDataImpl)methodInfo.getEJBComponentMetaData().getModuleMetaData();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "EJBModuleMetaDataImpl.ivUseExtendedSetRollbackOnlyBehavior = " + mmd.ivUseExtendedSetRollbackOnlyBehavior);
                }
                if (!mmd.ivUseExtendedSetRollbackOnlyBehavior || methodType == MethodInterface.MESSAGE_LISTENER || methodType == MethodInterface.TIMED_OBJECT) {
                    throw new CSITransactionRolledbackException("Transaction marked rollbackonly");
                }
            } else {
                this.commit(key, methodInfo);
            }
        } else {
            this.txCtrl.completeTxTimeout();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "postInvoke");
        }
    }

    void handleException(EJBKey key, TxCookieImpl txCookie, ExceptionType type, EJBMethodInfo methodInfo) throws CSIException {
        if (type == ExceptionType.CHECKED_EXCEPTION) {
            this.postInvoke(key, txCookie, methodInfo);
            return;
        }
        if (txCookie.beginner) {
            this.rollback(true, key, methodInfo);
            return;
        }
        if (this.globalTxExists(false)) {
            this.txCtrl.completeTxTimeout();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "handleException: marking client transaction rollbackOnly");
            }
            this.rollback(false, key, methodInfo);
            throw new CSITransactionRolledbackException();
        }
        LocalTransactionCoordinator coord = this.ltcCurrent.getLocalTranCoord();
        if (coord != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "handleException: marking client LTC rollbackOnly");
            }
            coord.setRollbackOnly();
        }
    }

    final TxCookieImpl beginLocalTx(EJBKey ejbKey, EJBMethodInfo methodInfo, Transaction suspendedGlobalTx) throws CSIException {
        LocalTransactionCoordinator suspendedLocalTx;
        int EJBType = ((EJBComponentMetaData)methodInfo.getComponentMetaData()).getEJBComponentType();
        LocalTranConfigData ltcd = ((EJBComponentMetaData)methodInfo.getComponentMetaData()).getLocalTranConfigData();
        boolean ltcBoundaryIsAS = ltcd.getValueBoundary() == 1;
        boolean suspendedLocalTxFound = false;
        LocalTransactionCoordinator savedLocalTx = null;
        boolean begunLocalTx = false;
        if (ltcBoundaryIsAS && (EJBType == 3 || EJBType == 4 || EJBType == 5) && (suspendedLocalTx = (LocalTransactionCoordinator)this.txCtrl.stickyLocalTxTable.remove((Object)ejbKey)) != null) {
            suspendedLocalTxFound = true;
            try {
                savedLocalTx = this.ltcCurrent.suspend();
                this.resumeLocalTx(suspendedLocalTx);
                begunLocalTx = true;
            }
            catch (Throwable ex) {
                block29: {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".beginLocalTx"), (String)"200", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Local tx resume failed", ex);
                    }
                    if (savedLocalTx != null) {
                        try {
                            this.resumeLocalTx(savedLocalTx);
                        }
                        catch (Throwable ex2) {
                            FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".beginLocalTx"), (String)"212", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block29;
                            Tr.event(tc, "Saved local tx resume failed", ex2);
                        }
                    }
                }
                throw new CSIException("Resume local tx failed", ex);
            }
        }
        if (!suspendedLocalTxFound) {
            try {
                boolean ltcUnresActionIsCommit = ltcd.getValueUnresolvedAction() == 1;
                boolean ltcResolverIsCAB = ltcd.getValueResolver() == 1;
                boolean ltcShareable = ltcd.isShareable();
                LocalTransactionCoordinator coord = this.ltcCurrent.getLocalTranCoord();
                if (coord == null) {
                    if (ltcShareable) {
                        this.ltcCurrent.beginShareable(ltcBoundaryIsAS, ltcUnresActionIsCommit, ltcResolverIsCAB);
                    } else {
                        this.ltcCurrent.begin(ltcBoundaryIsAS, ltcUnresActionIsCommit, ltcResolverIsCAB);
                    }
                    svUOWSynchReg.putResource("com.ibm.websphere.profile", methodInfo.getJPATaskName());
                    begunLocalTx = true;
                } else if (coord.isShareable() && ltcShareable) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "LTC context shared");
                    }
                } else {
                    savedLocalTx = this.ltcCurrent.suspend();
                    if (ltcShareable) {
                        this.ltcCurrent.beginShareable(ltcBoundaryIsAS, ltcUnresActionIsCommit, ltcResolverIsCAB);
                    } else {
                        this.ltcCurrent.begin(ltcBoundaryIsAS, ltcUnresActionIsCommit, ltcResolverIsCAB);
                    }
                    svUOWSynchReg.putResource("com.ibm.websphere.profile", methodInfo.getJPATaskName());
                    begunLocalTx = true;
                }
                if (TraceComponent.isAnyTracingEnabled() && (tc.isEventEnabled() || TETxLifeCycleInfo.isTraceEnabled())) {
                    LocalTransactionCoordinator lCoord = this.txCtrl.getLocalCoord();
                    if (tc.isEventEnabled()) {
                        if (lCoord != null) {
                            Tr.event(tc, "Began LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)");
                        } else {
                            Tr.event(tc, "Began LTC cntxt: null Coordinator!");
                        }
                        if (begunLocalTx) {
                            Tr.event(tc, "Set JPA task name: " + methodInfo.getJPATaskName());
                        }
                    }
                    if (lCoord != null && TETxLifeCycleInfo.isTraceEnabled()) {
                        TETxLifeCycleInfo.traceLocalTxBegin("" + System.identityHashCode(lCoord), "Begin Local Tx");
                    }
                }
            }
            catch (Exception ex) {
                block30: {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".beginLocalTx"), (String)"217", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Begin local tx failed", ex);
                    }
                    if (savedLocalTx != null) {
                        try {
                            this.resumeLocalTx(savedLocalTx);
                        }
                        catch (Throwable ex2) {
                            FFDCFilter.processException((Throwable)ex2, (String)(CLASS_NAME + ".beginLocalTx"), (String)"242", (Object)this);
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block30;
                            Tr.event(tc, "Saved local tx resume failed", ex2);
                        }
                    }
                }
                throw new CSIException("Begin local tx failed", ex);
            }
        }
        TxCookieImpl cookie = new TxCookieImpl(begunLocalTx, true, this, suspendedGlobalTx);
        cookie.suspendedLocalTx = savedLocalTx;
        return cookie;
    }

    final void suspendLocalTx(LocalTransactionCoordinator lCoord) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (lCoord != null) {
                Tr.event(tc, "Suspending LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)");
            } else {
                Tr.event(tc, "Suspending LTC cntxt: null Coordinator!");
            }
        }
        this.ltcCurrent.suspend();
        if (TraceComponent.isAnyTracingEnabled() && lCoord != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxSuspend("" + System.identityHashCode(lCoord), "Suspend Local Tx");
        }
    }

    final void resumeLocalTx(LocalTransactionCoordinator lCoord) throws IllegalStateException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            if (lCoord != null) {
                Tr.event(tc, "Resuming LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)");
            } else {
                Tr.event(tc, "Resuming LTC cntxt: null Coordinator!");
            }
        }
        this.ltcCurrent.resume(lCoord);
        if (TraceComponent.isAnyTracingEnabled() && lCoord != null && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceLocalTxResume("" + System.identityHashCode(lCoord), "Resume Local Tx");
        }
    }

    final boolean globalTxExists(boolean failIfNonInterop) throws CSIException {
        Transaction tx;
        block4: {
            tx = null;
            try {
                tx = this.txManager.getTransaction();
            }
            catch (SystemException se) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block4;
                Tr.event(tc, "Could not determine if there is a global tx active");
            }
        }
        if (failIfNonInterop && tx != null && ((UOWCoordinator)tx).getTxType() == 2) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Cannot proceed under a non-interoperable transaction context");
            }
            throw new CSITransactionRequiredException("Interoperable global transaction required");
        }
        return tx != null;
    }

    final void beginGlobalTx(EJBKey key, EJBMethodInfo methodInfo) throws CSIException {
        try {
            this.txCtrl.txService.begin();
            svUOWSynchReg.putResource("com.ibm.websphere.profile", methodInfo.getJPATaskName());
            if (TraceComponent.isAnyTracingEnabled()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Began TX cntxt: " + this.txCtrl.txService.getTransaction());
                    Tr.event(tc, "Set JPA task name: " + methodInfo.getJPATaskName());
                }
                if (TETxLifeCycleInfo.isTraceEnabled()) {
                    int idx;
                    String idStr = this.txCtrl.txService.getTransaction().toString();
                    idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                    TETxLifeCycleInfo.traceGlobalTxBegin(idStr, "Begin Global Tx");
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".beginGlobalTx"), (String)"243", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Begin global tx failed", ex);
            }
            throw new CSIException("Begin global tx failed", ex);
        }
    }

    final Transaction suspendGlobalTx(int action) throws CSIException {
        Transaction result = this.txCtrl.suspendGlobalTx(action);
        if (TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
            TETxLifeCycleInfo.traceGlobalTxSuspend("NoTx", "Suspend Global Tx");
        }
        return result;
    }

    final void resumeGlobalTx(Transaction control, int action) throws CSIException {
        try {
            this.txCtrl.resumeGlobalTx(control, action);
            if (TraceComponent.isAnyTracingEnabled() && TETxLifeCycleInfo.isTraceEnabled()) {
                int idx;
                String idStr = this.txCtrl.txService.getTransaction().toString();
                idStr = idStr != null ? ((idx = idStr.indexOf("(")) != -1 ? idStr.substring(idx + 1, idStr.indexOf(")")) : ((idx = idStr.indexOf("tid=")) != -1 ? idStr.substring(idx + 4) : idStr)) : "NoTx";
                TETxLifeCycleInfo.traceGlobalTxResume(idStr, "Resume Global Tx");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".resumeGlobalTx"), (String)"335", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Global tx resume failed", ex);
            }
            throw new CSIException("", ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void commit(EJBKey key, EJBMethodInfo methodInfo) throws CSITransactionRolledbackException {
        LocalTransactionCoordinator lCoord = this.ltcCurrent.getLocalTranCoord();
        if (lCoord != null) {
            int EJBType = ((EJBComponentMetaData)methodInfo.getComponentMetaData()).getEJBComponentType();
            if (lCoord.isASScoped()) {
                if (methodInfo.isHome() || EJBType == 6) return;
                this.suspendLocalTx(lCoord);
                if (EJBType == 2 || methodInfo.getMethodName().equalsIgnoreCase("remove")) return;
                this.txCtrl.stickyLocalTxTable.put((Object)key, (Object)lCoord);
                return;
            } else {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Completing LTC cntxt: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)");
                    }
                    lCoord.end(0);
                    if (!TraceComponent.isAnyTracingEnabled() || !TETxLifeCycleInfo.isTraceEnabled()) return;
                    TETxLifeCycleInfo.traceLocalTxCommit("" + System.identityHashCode(lCoord), "Commit Local Tx - end");
                    return;
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".commit"), (String)"277", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) throw new CSITransactionRolledbackException("");
                    Tr.event(tc, "Local tx completion failed", ex);
                    throw new CSITransactionRolledbackException("");
                }
            }
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "Committing TX cntxt: " + this.txCtrl.txService.getTransaction());
            }
            this.txCtrl.txService.commit();
            if (!TraceComponent.isAnyTracingEnabled() || !TETxLifeCycleInfo.isTraceEnabled()) return;
            TETxLifeCycleInfo.traceGlobalTxCommit("NoTx", "Commit Global Tx");
            return;
        }
        catch (HeuristicMixedException hme) {
            FFDCFilter.processException((Throwable)hme, (String)(CLASS_NAME + ".commit"), (String)"856", (Object)this);
            if (!tc.isEventEnabled()) throw new CSITransactionRolledbackException("", hme);
            Tr.event(tc, "Global tx commit failed Heuristically", hme);
            throw new CSITransactionRolledbackException("", hme);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".commit"), (String)"294", (Object)this);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) throw new CSITransactionRolledbackException("");
            Tr.event(tc, "Global tx commit failed", ex);
            throw new CSITransactionRolledbackException("");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void rollback(boolean beginner, EJBKey key, EJBMethodInfo methodInfo) throws CSIException {
        LocalTransactionCoordinator lCoord = this.ltcCurrent.getLocalTranCoord();
        if (lCoord != null) {
            int EJBType = ((EJBComponentMetaData)methodInfo.getComponentMetaData()).getEJBComponentType();
            if (lCoord.isASScoped()) {
                if (methodInfo.isHome() || EJBType == 6) return;
                lCoord.setRollbackOnly();
                this.suspendLocalTx(lCoord);
                if (EJBType == 2 || methodInfo.getMethodName().equalsIgnoreCase("remove")) return;
                this.txCtrl.stickyLocalTxTable.put((Object)key, (Object)lCoord);
                return;
            } else {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Completing LTC cntxt with rollback due to bean exception: tid=" + Integer.toHexString(lCoord.hashCode()) + "(LTC)");
                    }
                    lCoord.setRollbackOnly();
                    lCoord.end(1);
                    if (!TraceComponent.isAnyTracingEnabled() || !TETxLifeCycleInfo.isTraceEnabled()) return;
                    TETxLifeCycleInfo.traceLocalTxRollback("" + System.identityHashCode(lCoord), "Rollback Local Tx - end");
                    return;
                }
                catch (RolledbackException ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".rollback"), (String)"375", (Object)this);
                    return;
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".rollback"), (String)"378", (Object)this);
                    String errStr = "Could not complete local tx";
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) throw new CSIException(errStr, ex);
                    Tr.event(tc, errStr, ex);
                    throw new CSIException(errStr, ex);
                }
            }
        }
        try {
            if (beginner) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Rolling back TX cntxt due to bean exception: " + this.txCtrl.txService.getTransaction());
                }
                this.txCtrl.txService.rollback();
                if (!TraceComponent.isAnyTracingEnabled() || !TETxLifeCycleInfo.isTraceEnabled()) return;
                TETxLifeCycleInfo.traceGlobalTxRollback("NoTx", "Rollback Global Tx");
                return;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Marking TX cntxt for rollback due to bean exception: " + this.txCtrl.txService.getTransaction());
                }
                this.txCtrl.txService.setRollbackOnly();
            }
            return;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".rollback"), (String)"405", (Object)this);
            String errStr = "Could not roll back global tx";
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) throw new CSIException(errStr, ex);
            Tr.event(tc, errStr, ex);
            throw new CSIException(errStr, ex);
        }
    }

    boolean isBmtActive() {
        return false;
    }
}

