/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.oa.EJSORB;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.OrbUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javax.activity.ActivityCompletedException;
import com.ibm.ws.javax.activity.ActivityRequiredException;
import com.ibm.ws.javax.activity.InvalidActivityException;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.transaction.InvalidTransactionException;
import javax.transaction.TransactionRequiredException;
import javax.transaction.TransactionRolledbackException;
import org.omg.CORBA.ACTIVITY_COMPLETED;
import org.omg.CORBA.ACTIVITY_REQUIRED;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_ACTIVITY;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.UnknownException;

public class OrbUtilsImpl
implements OrbUtils {
    private static final String CLASS_NAME = "com.ibm.ejs.csi.OrbUtilsImpl";

    public void connectToOrb(Object stub) throws CSIException {
        try {
            ((Stub)stub).connect((ORB)EJSORB.init());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.csi.OrbUtilsImpl.connectToOrb", (String)"40", (Object)this);
            throw new CSIException("stub connect failed", e);
        }
    }

    public Exception mapException(RemoteException ex) throws CSIException {
        String detail = ex.toString();
        if (ex instanceof NoSuchObjectException) {
            return new OBJECT_NOT_EXIST(detail);
        }
        if (ex instanceof TransactionRequiredException) {
            return new TRANSACTION_REQUIRED(detail);
        }
        if (ex instanceof TransactionRolledbackException) {
            return new TRANSACTION_ROLLEDBACK(detail);
        }
        if (ex instanceof InvalidTransactionException) {
            return new INVALID_TRANSACTION(detail);
        }
        if (ex instanceof AccessException) {
            return new NO_PERMISSION(detail);
        }
        if (ex instanceof ActivityRequiredException) {
            return new ACTIVITY_REQUIRED(detail);
        }
        if (ex instanceof InvalidActivityException) {
            return new INVALID_ACTIVITY(detail);
        }
        if (ex instanceof ActivityCompletedException) {
            return new ACTIVITY_COMPLETED(detail);
        }
        return new UnknownException((Throwable)ex);
    }

    public Exception mapException(RemoteException ex, int minorCode) throws CSIException {
        if (minorCode == 0) {
            return this.mapException(ex);
        }
        String detail = ex.toString();
        if (ex instanceof NoSuchObjectException) {
            return new OBJECT_NOT_EXIST(detail, minorCode, CompletionStatus.COMPLETED_NO);
        }
        if (ex instanceof TransactionRequiredException) {
            return new TRANSACTION_REQUIRED(detail, minorCode, CompletionStatus.COMPLETED_NO);
        }
        if (ex instanceof TransactionRolledbackException) {
            return new TRANSACTION_ROLLEDBACK(detail, minorCode, CompletionStatus.COMPLETED_NO);
        }
        if (ex instanceof InvalidTransactionException) {
            return new INVALID_TRANSACTION(detail, minorCode, CompletionStatus.COMPLETED_MAYBE);
        }
        if (ex instanceof AccessException) {
            return new NO_PERMISSION(detail, minorCode, CompletionStatus.COMPLETED_NO);
        }
        if (ex instanceof ActivityRequiredException) {
            return new ACTIVITY_REQUIRED(detail, minorCode, CompletionStatus.COMPLETED_NO);
        }
        if (ex instanceof InvalidActivityException) {
            return new INVALID_ACTIVITY(detail, minorCode, CompletionStatus.COMPLETED_NO);
        }
        if (ex instanceof ActivityCompletedException) {
            return new ACTIVITY_COMPLETED(detail, minorCode, CompletionStatus.COMPLETED_NO);
        }
        return new UnknownException((Throwable)ex);
    }
}

