/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.models.base.extensions.commonext.localtran.LocalTransaction;
import com.ibm.ejs.models.base.extensions.ejbext.EnterpriseBeanExtension;
import com.ibm.ejs.models.base.extensions.ejbext.LocalTran;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SystemGetPropertyPrivileged;
import com.ibm.websphere.csi.LocalTranConfigData;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;

public class LocalTranConfigDataImpl
implements LocalTranConfigData {
    private static final TraceComponent tc = Tr.register(LocalTranConfigDataImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private int boundary = 0;
    private int resolver = 0;
    private int unresolvedAction = 0;
    private boolean isShareable = false;

    public LocalTranConfigDataImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Default CTOR was called, using default values for config data");
        }
    }

    public LocalTranConfigDataImpl(EnterpriseBeanExtension ebx) {
        if (ebx != null) {
            LocalTransaction localTransaction;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CTOR was passed non-null EnterpriseBeanExtension object for config data");
            }
            if (ebx.getEnterpriseBean().isContainerManagedEntity()) {
                this.resolver = 1;
            }
            if ((localTransaction = ebx.getLocalTransaction()) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "We have a LocalTransaction object, so use the 5.0 or later config data");
                }
                this.init(localTransaction);
            } else {
                LocalTran oldLocalTran;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No LocalTransaction object, checking for a LocalTran object");
                }
                if ((oldLocalTran = ebx.getLocalTran()) != null && oldLocalTran.isSetUnresolvedAction() && oldLocalTran.getUnresolvedAction().getValue() == 1) {
                    this.unresolvedAction = 1;
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "CTOR was passed a null EnterpriseBeanExtension object, using default values for config data");
        }
    }

    public LocalTranConfigDataImpl(LocalTransaction ltx) {
        this.init(ltx);
    }

    private void init(LocalTransaction ltx) {
        if (ltx != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "init was passed non-null LocalTransaction object for config data");
            }
            if (ltx.isSetBoundary()) {
                this.boundary = ltx.getBoundary().getValue();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "LocalTransaction boundary is NOT set, using default value of BeanMethod");
            }
            if (ltx.isSetResolver()) {
                this.resolver = ltx.getResolver().getValue();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "LocalTransaction resolver is NOT set, using default value of Application");
            }
            if (ltx.isSetUnresolvedAction()) {
                this.unresolvedAction = ltx.getUnresolvedAction().getValue();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "LocalTransaction unresolved action is NOT set, using default value of Rollback");
            }
            if (ltx.isSetShareable()) {
                this.isShareable = ltx.isShareable();
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "LocalTransaction isShareable action is NOT set, using default value of false");
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "init was passed a null LocalTransaction object, using default values for config data");
        }
    }

    public int getValueBoundary() {
        return this.boundary;
    }

    public int getValueResolver() {
        return this.resolver;
    }

    public int getValueUnresolvedAction() {
        return this.unresolvedAction;
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    public String toString() {
        String separator = (String)AccessController.doPrivileged((PrivilegedAction)new SystemGetPropertyPrivileged("line.separator", "\n"));
        String sep = "                                 ";
        StringBuffer sb = new StringBuffer();
        sb.append(separator + sep + "      ****** LOCAL-TRANSACTION *******");
        if (this.boundary == 1) {
            sb.append(separator + sep + "Boundary=ACTIVITY");
        } else if (this.boundary == 0) {
            sb.append(separator + sep + "Boundary=BEAN_METHOD");
        } else {
            sb.append(separator + sep + "Boundary=UNKNOWN");
        }
        if (this.resolver == 0) {
            sb.append(separator + sep + "Resolver=APPLICATION");
        } else if (this.resolver == 1) {
            sb.append(separator + sep + "Resolver=CONTAINER_AT_BOUNDARY");
        } else {
            sb.append(separator + sep + "Resolver=UNKNOWN");
        }
        if (this.unresolvedAction == 0) {
            sb.append(separator + sep + "UnResolvedAction=ROLLBACK");
        } else if (this.unresolvedAction == 1) {
            sb.append(separator + sep + "UnResolvedAction=COMMIT");
        } else {
            sb.append(separator + sep + "UnResolvedAction=UNKNOWN");
        }
        if (this.isShareable) {
            sb.append(separator + sep + "isShareable=TRUE");
        } else {
            sb.append(separator + sep + "isShareable=FALSE");
        }
        return sb.toString();
    }
}

