/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.EJSWrapperCommon;
import com.ibm.ejs.container.WrapperId;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.container.WrapperManager;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.Serializable;

public class SerializableByteArray
implements Serializable {
    private static final long serialVersionUID = 8311919298341109455L;
    private static final String CLASS_NAME = SerializableByteArray.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private static final boolean DEBUG_ON = false;
    private byte[] ivIdBytes;

    public SerializableByteArray(EJSWrapperBase wrapper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SerializableByteArray for wrapper = " + wrapper);
        }
        BeanId beanId = wrapper.beanId;
        WrapperInterface wrapperInterface = wrapper.ivInterface;
        BeanMetaData bmd = wrapper.bmd;
        if (wrapperInterface == WrapperInterface.BUSINESS_LOCAL) {
            int interfaceIndex = wrapper.ivBusinessInterfaceIndex;
            Class biClass = bmd.ivBusinessLocalInterfaceClasses[interfaceIndex];
            String interfaceName = biClass.getName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "serializing a WrapperId for BeanId = " + beanId + ", local business interface = " + interfaceName + ", primary key = " + beanId.getPrimaryKey());
            }
            WrapperId wrapperId = new WrapperId(beanId.getByteArrayBytes(), interfaceName, interfaceIndex);
            this.ivIdBytes = wrapperId.getBytes();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "serializing a BeanId = " + beanId + ", primary key = " + beanId.getPrimaryKey());
            }
            this.ivIdBytes = beanId.getByteArrayBytes();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SerializableByteArray");
        }
    }

    public Object getWrapper() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWrapper");
        }
        EJSContainer container2 = EJSContainer.getDefaultContainer();
        Object retObj = null;
        WrapperManager wm = container2.getWrapperManager();
        if (this.ivIdBytes[0] == -84) {
            ByteArray byteArray = new ByteArray(this.ivIdBytes);
            BeanId beanId = BeanId.getBeanId(byteArray, container2);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "deserialized a BeanId = " + beanId + ", primary key = " + beanId.getPrimaryKey());
            }
            retObj = wm.getWrapper(beanId).getLocalWrapper();
        } else if (this.ivIdBytes[0] == -83) {
            WrapperId wrapperId = new WrapperId(this.ivIdBytes);
            int index = wrapperId.ivInterfaceIndex;
            String interfaceName = wrapperId.ivInterfaceClassName;
            ByteArray byteArray = wrapperId.getBeanIdArray();
            BeanId beanId = BeanId.getBeanId(byteArray, container2);
            BeanMetaData bmd = beanId.getBeanMetaData();
            Tr.debug(tc, "deserialized a WrapperId for BeanId = " + beanId + ", primary key = " + beanId.getPrimaryKey());
            Class[] bInterfaces = bmd.ivBusinessLocalInterfaceClasses;
            int numberOfLocalInterfaces = bInterfaces.length;
            String wrapperInterfaceName = null;
            if (index < numberOfLocalInterfaces) {
                wrapperInterfaceName = bInterfaces[index].getName();
            }
            if (wrapperInterfaceName == null || !wrapperInterfaceName.equals(interfaceName)) {
                for (int i = 0; i < numberOfLocalInterfaces; ++i) {
                    wrapperInterfaceName = bmd.ivBusinessLocalInterfaceClasses[i].getName();
                    if (!wrapperInterfaceName.equals(interfaceName)) continue;
                    index = i;
                    break;
                }
            }
            EJSHome home = bmd.getHome();
            EJSWrapperCommon wc = home.internalCreateWrapper(beanId);
            retObj = wc.getBusinessObject(bmd.ivBusinessLocalInterfaceClasses[index]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWrapper returning: " + retObj);
        }
        return retObj;
    }
}

