/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSLocalWrapper;
import com.ibm.ejs.container.util.LocalInterfaceHomeInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.naming.util.NullRefAddrException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class LocalInterfaceHomeObjectFactory
implements ObjectFactory {
    private static final TraceComponent tc = Tr.register(LocalInterfaceHomeObjectFactory.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String ADDR_TYPE = "LocalInterfaceHomeInfo";

    public LocalInterfaceHomeObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        String thisMethod = "getObjectInstance(Object, Name, Context, Hashtable)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, thisMethod);
        }
        EJSLocalWrapper retObj = null;
        if (!(obj instanceof Reference)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, thisMethod, obj + " is not a Reference");
            }
            return null;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(this.getClass().getName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, thisMethod, "this is not the right factory for this Reference: " + obj);
            }
            return null;
        }
        RefAddr addr = ref.get(ADDR_TYPE);
        if (addr == null) {
            NullRefAddrException ne = new NullRefAddrException("The address for this Reference is empty (null)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, thisMethod, "Get NullRefAddrException!");
            }
            throw ne;
        }
        LocalInterfaceHomeInfo info = (LocalInterfaceHomeInfo)addr.getContent();
        String containerName = info.getContainerName();
        J2EEName j2eeName = info.getJ2eeName();
        retObj = EJSContainer.getContainer(containerName).getLocalHome(j2eeName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "LocalHome(" + j2eeName + "):" + retObj.getClass().getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, thisMethod, "retObj = " + retObj);
        }
        return retObj;
    }
}

