/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.util;

import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSWrapperForBasicSFSBHome;
import com.ibm.ejs.container.util.EJBLocalInterfaceInfo;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.naming.util.NullRefAddrException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBLocalInterfaceObjectFactory
implements ObjectFactory {
    private static final String CLASS_NAME = EJBLocalInterfaceObjectFactory.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");

    public EJBLocalInterfaceObjectFactory() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>");
        }
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        String thisMethod = "getObjectInstance(Object, Name, Context, Hashtable)";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, thisMethod);
        }
        Object retObj = null;
        if (!(obj instanceof Reference)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, thisMethod, obj + " is not a Reference");
            }
            return null;
        }
        Reference ref = (Reference)obj;
        if (!ref.getFactoryClassName().equals(this.getClass().getName())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, thisMethod, "this is not the right factory for this Reference: " + obj);
            }
            return null;
        }
        RefAddr addr = ref.get("EJBLocalInterfaceInfo");
        if (addr == null) {
            NullRefAddrException ne = new NullRefAddrException("The address for this Reference is empty (null)");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, thisMethod, "Get NullRefAddrException!");
            }
            throw ne;
        }
        EJBLocalInterfaceInfo info = (EJBLocalInterfaceInfo)addr.getContent();
        J2EEName j2eeName = info.getJ2eeName();
        if (info.isLocalHomeInterfaceName()) {
            retObj = EJSContainer.getDefaultContainer().getLocalHome(j2eeName);
        } else {
            EJSHome home = (EJSHome)EJSContainer.homeOfHomes.getHome(j2eeName);
            ClassLoader classLoader = home.getBeanMetaData().classLoader;
            String businessInterfaceName = info.getLocalInterfaceName();
            Class<?> businessClass = classLoader.loadClass(businessInterfaceName);
            if (home.isStatelessSessionHome()) {
                retObj = home.createBusinessObject(businessClass);
            } else if (home.isStatefulSessionHome()) {
                EJSWrapperForBasicSFSBHome wrapper = home.getStatefulBusinessHomeWrapper();
                retObj = wrapper.create(businessClass);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, thisMethod, retObj);
        }
        return retObj;
    }
}

