/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.passivator;

import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.TimerHandleImpl;
import com.ibm.ejs.container.util.SerializableByteArray;
import com.ibm.ejs.container.util.StatefulBeanOReplacement;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.dopriv.LoadClassPrivileged;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.rmi.CORBA.Stub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewInputStream
extends ObjectInputStream {
    BeanO activatedBeanO;
    private ClassLoader ivClassLoader;
    private EJSContainer ivContainer;
    private static final TraceComponent tc = Tr.register(NewInputStream.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.passivator.NewInputStream";

    NewInputStream(InputStream is, BeanO bo, ClassLoader classLoader, EJSContainer container2) throws StreamCorruptedException, IOException {
        super(is);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "NewInputStream: Input stream:" + is + ", activatedBeanO: " + bo);
        }
        this.activatedBeanO = bo;
        this.ivClassLoader = classLoader;
        this.ivContainer = container2;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                NewInputStream.this.enableResolveObject(true);
                return null;
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "NewInputStream");
        }
    }

    @Override
    protected Object resolveObject(Object obj) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String className = obj == null ? null : obj.getClass().getName();
            Tr.entry(tc, "resolveObject: " + className);
        }
        if (obj instanceof StatefulBeanOReplacement) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replacing StatefulBeanOReplacement");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveObject: " + this.activatedBeanO);
            }
            return this.activatedBeanO;
        }
        if (obj instanceof Stub) {
            try {
                this.ivContainer.getOrbUtils().connectToOrb(obj);
            }
            catch (CSIException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.NewInputStream.resolveObject", (String)"172", (Object)this);
                Tr.warning(tc, "FAILED_TO_CONNECT_TO_ORB_CNTR0006W", ex);
                return null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveObject: original remote object");
            }
            return obj;
        }
        if (obj instanceof SerializableByteArray) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replacing SerializableByteArray with EJSLocalWrapper");
            }
            try {
                Object rtnObj = ((SerializableByteArray)obj).getWrapper();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "resolveObject: " + rtnObj.getClass().getName());
                }
                return rtnObj;
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.NewInputStream.resolveObject", (String)"191", (Object)this);
                Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{obj, this, ex});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "resolveObject: null : ERROR");
                }
                return null;
            }
        }
        if (obj instanceof TimerHandleImpl) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "replacing TimerHandle with Timer or TimerHandle");
            }
            Object resolve = ((TimerHandleImpl)obj).getSerializedObject();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveObject: " + resolve);
            }
            return resolve;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveObject: original object");
        }
        return obj;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass streamClass) throws IOException, ClassNotFoundException {
        String className = streamClass.getName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveClass: " + className);
        }
        if (this.ivClassLoader != null) {
            Class beanClass;
            try {
                beanClass = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new LoadClassPrivileged(className, this.ivClassLoader));
            }
            catch (PrivilegedActionException ex2) {
                ClassNotFoundException ex = (ClassNotFoundException)ex2.getException();
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.passivator.NewInputStream.resolveClass", (String)"185", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to find " + className + " for passivated bean");
                }
                throw ex;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "resolveClass returning: " + beanClass);
            }
            return beanClass;
        }
        throw new ClassNotFoundException();
    }
}

