/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.passivator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EJBObjectInfo
implements Serializable {
    private static final long serialVersionUID = 7712587930606979632L;
    private boolean ivSerializable = false;
    private Object ivSerializableObject = null;
    private String ivClassName = null;
    private Map<String, List<FieldInfo>> ivFieldInfoMap = null;

    EJBObjectInfo() {
    }

    String getClassName() {
        return this.ivClassName;
    }

    void setClassName(String className) {
        this.ivClassName = className;
    }

    Map<String, List<FieldInfo>> getFieldInfoMap() {
        return this.ivFieldInfoMap;
    }

    void addFieldInfo(String className, List<FieldInfo> fieldInfoList) {
        if (this.ivFieldInfoMap == null) {
            this.ivFieldInfoMap = new HashMap<String, List<FieldInfo>>();
        }
        this.ivFieldInfoMap.put(className, fieldInfoList);
    }

    boolean isSerializable() {
        return this.ivSerializable;
    }

    void setSerializable(boolean serializable) {
        this.ivSerializable = serializable;
    }

    Object getSerializableObject() {
        return this.ivSerializableObject;
    }

    void setSerializableObject(Object serializableObject) {
        this.ivSerializableObject = serializableObject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("EJBObjectInfo");
        sb.append("\tserializable=" + this.ivSerializable);
        if (this.ivSerializable) {
            if (this.ivSerializableObject != null) {
                sb.append(" className=" + this.ivSerializableObject.getClass().getName());
            }
        } else {
            if (this.ivClassName != null) {
                sb.append(" className=" + this.ivClassName);
            }
            if (this.ivFieldInfoMap != null) {
                sb.append("\n\tfieldInfoMap");
                Set<String> classNames = this.ivFieldInfoMap.keySet();
                for (String className : classNames) {
                    sb.append("\n\t\tclassName=" + className);
                    List<FieldInfo> fieldInfoList = this.ivFieldInfoMap.get(className);
                    if (fieldInfoList == null) continue;
                    for (FieldInfo fieldInfo : fieldInfoList) {
                        sb.append("\n\t\t\tfieldInfo=" + fieldInfo.name + " - " + fieldInfo.value);
                    }
                }
            }
        }
        return sb.toString();
    }

    static class FieldInfo
    implements Serializable {
        private static final long serialVersionUID = -6936032901508808602L;
        String name;
        Object value;

        FieldInfo() {
        }
    }
}

