/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.lock;

import com.ibm.ejs.container.lock.Lock;
import com.ibm.ejs.container.lock.LockException;
import com.ibm.ejs.container.lock.LockProxy;
import com.ibm.ejs.container.lock.Locker;
import com.ibm.ejs.container.lock.Waiter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Enumeration;
import java.util.Hashtable;

public class LockManager {
    private static final TraceComponent tc = Tr.register(LockManager.class, "EJBContainer", "com.ibm.ejs.container.container");
    public static final int SHARED = 0;
    public static final int EXCLUSIVE = 1;
    public static final String[] modeStrs = new String[]{"SHARED", "EXCLUSIVE"};
    private Hashtable lockTable;
    private Hashtable waitTable;

    public LockManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.lockTable = new Hashtable();
        this.waitTable = new Hashtable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(Object lockName, Locker locker, int mode) throws InterruptedException, LockException {
        Lock theLock = null;
        Hashtable hashtable = this.lockTable;
        synchronized (hashtable) {
            LockProxy l;
            Locker o = this.lockTable.put(lockName, locker);
            if (o == null || o == locker) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "lock acquired", new Object[]{lockName, locker, modeStrs[mode]});
                }
                return o == null;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Conflict : Lock upgrading from proxy", new Object[]{lockName, locker, modeStrs[mode]});
            }
            if ((l = (LockProxy)o).isLock()) {
                theLock = (Lock)l;
                if (theLock.isHolder(locker)) {
                    this.lockTable.put(lockName, theLock);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "lock acquired (already held)", new Object[]{lockName, locker, modeStrs[mode]});
                    }
                    return false;
                }
            } else {
                theLock = new Lock(lockName, o, this);
            }
            this.lockTable.put(lockName, theLock);
            theLock.acquire(locker, mode, false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Conflict : Lock upgraded from proxy", new Object[]{lockName, locker, modeStrs[mode]});
            }
        }
        theLock.acquire(locker, mode, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "lock acquired", new Object[]{lockName, locker, modeStrs[mode]});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object lockName, Locker locker) {
        Hashtable hashtable = this.lockTable;
        synchronized (hashtable) {
            Lock theLock;
            Object o = this.lockTable.remove(lockName);
            if (o != null && o != locker && (theLock = (Lock)o).release(locker) != 0) {
                this.lockTable.put(lockName, theLock);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "lock released", new Object[]{lockName, locker});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Locker locker) {
        Hashtable hashtable = this.lockTable;
        synchronized (hashtable) {
            if (this.lockTable.size() == 0) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "unlock", locker);
            }
            Enumeration lockNames = this.lockTable.keys();
            while (lockNames.hasMoreElements()) {
                Object lockName = lockNames.nextElement();
                Object o = this.lockTable.get(lockName);
                if (o == locker) {
                    this.unlock(lockName, locker);
                    continue;
                }
                if (!((LockProxy)o).isLock() || !((Lock)o).isHolder(locker)) continue;
                this.unlock(lockName, locker);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "unlock");
            }
        }
    }

    void waitEvent(Waiter w) {
        this.waitTable.put(w.locker, w.theLock);
    }

    void unwaitEvent(Waiter w) {
        this.waitTable.remove(w.locker);
    }

    boolean detectDeadlock(Locker acquirer, Lock l, int mode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "detectDeadlock", new Object[]{acquirer, l, modeStrs[mode]});
        }
        boolean result = false;
        Enumeration holders = l.getHolders();
        while (holders.hasMoreElements()) {
            if (!this.lockerWaitingOn((Locker)holders.nextElement(), acquirer)) continue;
            result = true;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "detectDeadlock:" + result);
        }
        return result;
    }

    public boolean lockerWaitingOn(Locker locker, Locker target) {
        Lock waitingOn = (Lock)this.waitTable.get(locker);
        if (waitingOn == null) {
            return false;
        }
        Enumeration holders = waitingOn.getHolders();
        while (holders.hasMoreElements()) {
            Locker next = (Locker)holders.nextElement();
            if (next == target) {
                return true;
            }
            if (!this.lockerWaitingOn(next, target)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.lockTable.size();
    }

    public void dump() {
        if (!tc.isDumpEnabled()) {
            return;
        }
        Enumeration vEnum = this.lockTable.keys();
        Tr.dump(tc, "-- Lock Manager Dump --");
        while (vEnum.hasMoreElements()) {
            Object key = vEnum.nextElement();
            Tr.dump(tc, "lock table entry", new Object[]{key, this.lockTable.get(key)});
        }
    }
}

