/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.lock;

import com.ibm.ejs.container.lock.DeadlockException;
import com.ibm.ejs.container.lock.LockException;
import com.ibm.ejs.container.lock.LockManager;
import com.ibm.ejs.container.lock.LockProxy;
import com.ibm.ejs.container.lock.LockReleasedException;
import com.ibm.ejs.container.lock.Locker;
import com.ibm.ejs.container.lock.Waiter;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class Lock
implements LockProxy {
    private static final TraceComponent tc = Tr.register(Lock.class, "EJBContainer", "com.ibm.ejs.container.container");
    private int mode;
    private Object lockName;
    private Hashtable holders;
    private Hashtable waiters;
    private Vector waitQ;
    private LockManager lockMgr;
    private int numUsers;

    Lock(Object lockName, Locker holder, LockManager lockMgr) {
        this.lockName = lockName;
        this.holders = new Hashtable();
        this.holders.put(holder, holder);
        ++this.numUsers;
        this.lockMgr = lockMgr;
        this.mode = holder.getLockMode(lockName);
        this.waiters = new Hashtable();
        this.waitQ = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquire(Locker locker, int requestedMode, boolean wait) throws InterruptedException, LockException {
        Waiter waiter = null;
        Object object = this;
        synchronized (object) {
            if (this.numUsers == 0) {
                this.holders.put(locker, locker);
                this.mode = requestedMode;
                ++this.numUsers;
                return;
            }
            if (this.holders.get(locker) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Lock currently held by locker");
                }
                return;
            }
            if (this.mode == 0 && requestedMode == 0 && this.waiters.size() == 0) {
                this.holders.put(locker, locker);
                ++this.numUsers;
                return;
            }
            Waiter currWaiter = (Waiter)this.waiters.get(locker);
            if (currWaiter != null) {
                if (currWaiter.mode != requestedMode) {
                    if (this.lockMgr.detectDeadlock(locker, this, requestedMode)) {
                        throw new DeadlockException();
                    }
                    if (requestedMode == 1) {
                        currWaiter.mode = 1;
                    }
                }
                waiter = currWaiter;
            } else {
                if (this.lockMgr.detectDeadlock(locker, this, requestedMode)) {
                    throw new DeadlockException();
                }
                waiter = new Waiter(this, locker, requestedMode);
                this.waiters.put(locker, waiter);
                this.lockMgr.waitEvent(waiter);
                ++this.numUsers;
                this.waitQ.addElement(waiter);
            }
        }
        if (!wait) {
            return;
        }
        object = waiter;
        synchronized (object) {
            if (waiter.released) {
                throw new LockReleasedException();
            }
            if (waiter.theLock.holders.get(waiter.locker) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "waiting for lock", new Object[]{this.lockName, locker, LockManager.modeStrs[this.mode]});
                }
                waiter.wait();
                if (waiter.released) {
                    throw new LockReleasedException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int release(Locker locker) {
        Waiter waiter;
        if (this.holders.remove(locker) != null) {
            --this.numUsers;
        }
        if ((waiter = (Waiter)this.waiters.remove(locker)) != null) {
            --this.numUsers;
            Waiter waiter2 = waiter;
            synchronized (waiter2) {
                this.waitQ.removeElement(waiter);
                waiter.released = true;
                this.lockMgr.unwaitEvent(waiter);
                waiter.notify();
            }
        }
        if (this.holders.size() == 0) {
            Waiter waiter3;
            Waiter newHolder;
            if (this.waiters.size() > 0) {
                waiter3 = newHolder = (Waiter)this.waitQ.firstElement();
                synchronized (waiter3) {
                    this.waiters.remove(newHolder.locker);
                    this.waitQ.removeElementAt(0);
                    this.holders.put(newHolder.locker, newHolder.locker);
                    this.mode = newHolder.mode;
                    this.lockMgr.unwaitEvent(newHolder);
                    newHolder.notify();
                }
            }
            if (this.mode == 1) {
                return this.numUsers;
            }
            while (this.waiters.size() > 0) {
                newHolder = (Waiter)this.waitQ.firstElement();
                if (newHolder.mode == 1) {
                    return this.numUsers;
                }
                waiter3 = newHolder;
                synchronized (waiter3) {
                    this.waiters.remove(newHolder.locker);
                    this.waitQ.removeElementAt(0);
                    this.holders.put(newHolder.locker, newHolder.locker);
                    this.lockMgr.unwaitEvent(newHolder);
                    newHolder.notify();
                }
            }
        }
        return this.numUsers;
    }

    public final boolean isLock() {
        return true;
    }

    public Enumeration getHolders() {
        return this.holders.elements();
    }

    public boolean isHolder(Locker locker) {
        return this.holders.get(locker) != null;
    }
}

