/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.finder;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.container.finder.FinderResultServerImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.NoSuchElementException;

public class FinderResultClientBase_Local {
    private static final TraceComponent tc = Tr.register(FinderResultClientBase_Local.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.finder.FinderResultClientBase_Local";
    protected FinderResultServerImpl serverImpl;
    private int nextIndex;
    private boolean exhausted;
    private Object nextElement;

    public FinderResultClientBase_Local(FinderResultServerImpl serverImpl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "com.ibm.ejs.container.finder.FinderResultClientBase_Local<init>", serverImpl);
        }
        this.serverImpl = serverImpl;
        this.nextIndex = 0;
        this.nextElement = this.readAheadNextElement();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "com.ibm.ejs.container.finder.FinderResultClientBase_Local<init>");
        }
    }

    public boolean hasMoreElements() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "hasMoreElement(): exhaused=" + this.exhausted);
        }
        return !this.exhausted;
    }

    public Object nextElement() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "nextElement");
        }
        if (this.hasMoreElements()) {
            if (!this.serverImpl.validLocalAccessScope()) {
                throw new CollectionCannotBeFurtherAccessedException();
            }
            Object rtnObject = this.nextElement;
            this.nextElement = this.readAheadNextElement();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "nextElement(): return element=" + (rtnObject == null ? "null" : rtnObject.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(rtnObject))));
            }
            return rtnObject;
        }
        throw new NoSuchElementException();
    }

    private Object readAheadNextElement() {
        Object rtnObject;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "readAheadNextElement(): nextIndex=" + this.nextIndex + ": exhausted=" + this.exhausted);
        }
        if ((rtnObject = this.serverImpl.getNextWrapper(this.nextIndex)) != null || !this.serverImpl.exhaustedCollection()) {
            ++this.nextIndex;
        } else {
            this.exhausted = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "readAheadNextElement(): nextIndex=" + this.nextIndex + ": exhausted=" + this.exhausted + ": nextElement=" + (rtnObject == null ? "null" : rtnObject.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(rtnObject))));
        }
        return rtnObject;
    }
}

