/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.drs.SfDRSCacheEntry;
import com.ibm.ejs.container.drs.SfDRSCacheMsgListener;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSSettings;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;

public class SfDRSCache {
    private static final TraceComponent tc = Tr.register(SfDRSCache.class, "EJBDRSCache", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSCache";
    private final FastHashtable<SfDRSKey, CacheEntry> ivCache;
    private final FastHashtable<String, SfDRSClient> ivSfDRSClientCache;
    private final MultibrokerDomain ivMultibrokerDomain;
    private String ivContainerId;
    private SfDRSClient ivContainerSfDRSClient;
    private EJSContainer ivContainer;

    public SfDRSCache(MultibrokerDomain mbd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "SfDRSCache CTOR");
        }
        this.ivCache = new FastHashtable(97);
        this.ivSfDRSClientCache = new FastHashtable(17);
        this.ivMultibrokerDomain = mbd;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "SfDRSCache created");
        }
    }

    public final SfDRSClient getContainerSfDRSClient() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getContainerSfDRSClient", this.ivContainerSfDRSClient);
        }
        return this.ivContainerSfDRSClient;
    }

    public SfDRSClient getSfDRSClient(String id, DRSSettings drsSettings) {
        SfDRSClient drsClient;
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "getSfDRSClient for DRS instance ID = " + id);
            }
            if ((drsClient = (SfDRSClient)this.ivSfDRSClientCache.get((Object)id)) == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "creating DRS instance for ID = " + id);
                }
                try {
                    SfDRSCacheMsgListener ml = new SfDRSCacheMsgListener(this);
                    String domainName = drsSettings.getMessageBrokerDomainName();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "DRS replication domain: " + domainName);
                    }
                    HashMap<String, Object> miscParms = new HashMap<String, Object>();
                    miscParms.put("Configure DRS Controller Instance", "EJB Container DRS Controller Instance");
                    miscParms.put("MISC_PARM_JOIN_CLUSTER", Boolean.TRUE);
                    DRSDataXfer ddx = this.ivMultibrokerDomain.createInstance(id, (DRSCacheMsgListener)ml, null, drsSettings, null, miscParms);
                    SfDRSClient sfDrsClient = new SfDRSClient(ddx, id, ml);
                    ml.setSfDRSClient(sfDrsClient);
                    this.ivSfDRSClientCache.put((Object)id, (Object)sfDrsClient);
                    drsClient = sfDrsClient;
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.drs.SfDRSCache.getSfDRSClient", (String)"216", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "creating DRS instance failed: " + th);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSfDRSClient returning " + drsClient);
        }
        return drsClient;
    }

    public SfDRSClient getCachedSfDRSClient(String id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSfDRSClient for DRS instance ID = " + id);
        }
        SfDRSClient drsClient = (SfDRSClient)this.ivSfDRSClientCache.get((Object)id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSfDRSClient returning " + drsClient);
        }
        return drsClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanDoesNotExistOrHasTimedOut(BeanId beanId) {
        SfDRSKey key;
        CacheEntry cacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beanDoesNotExistOrHasTimedOut for BeanId = " + beanId);
        }
        if ((cacheEntry = (CacheEntry)this.ivCache.get((Object)(key = beanId.getDRSKey()))) == null) {
            cacheEntry = this.faultDataIntoCache(beanId);
        }
        boolean returnValue = true;
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                returnValue = this.beanTimedOut(cacheEntry);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beanDoesNotExistOrHasTimedOut returning " + returnValue + " for BeanId = " + beanId);
        }
        return returnValue;
    }

    public void addCacheEntry(SfDRSKey key, SfDRSCacheEntry newEntry, SfDRSCacheMsgListener ml) {
        CacheEntry cacheEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addCacheEntry for key = " + key);
        }
        if ((cacheEntry = (CacheEntry)this.ivCache.get((Object)key)) != null) {
            this.updateCacheEntry(key, newEntry, ml);
        } else {
            cacheEntry = new CacheEntry();
            cacheEntry.ivData = newEntry.ivData;
            cacheEntry.ivSequenceNumber = newEntry.ivSequenceNumber;
            cacheEntry.ivPassivated = newEntry.ivPassivated;
            cacheEntry.ivStickyUOW = newEntry.ivStickyUOW;
            cacheEntry.ivTimeoutValue = newEntry.ivTimeoutValue;
            cacheEntry.ivLastAccessTime = newEntry.ivLastAccessTime;
            cacheEntry.ivKey = key;
            cacheEntry.ivOwner = ml;
            this.ivCache.put((Object)key, (Object)cacheEntry);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "added: " + cacheEntry);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addCacheEntry");
        }
    }

    public final boolean beanExists(BeanId beanId) {
        SfDRSKey key = beanId.getDRSKey();
        return this.beanExists(key);
    }

    final boolean beanExists(SfDRSKey key) {
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get((Object)key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, cacheEntry != null ? "Session bean is in DRS cache" : "Session bean is not DRS cache");
        }
        return cacheEntry != null;
    }

    private boolean beanTimedOut(CacheEntry cacheEntry) {
        long currentTime;
        long elapsedTime;
        if (cacheEntry.ivTimeoutValue > 0L && (elapsedTime = (currentTime = System.currentTimeMillis()) - cacheEntry.ivLastAccessTime) >= cacheEntry.ivTimeoutValue) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Date currentDate = new Date(currentTime);
                Date lastAccessTime = new Date(cacheEntry.ivLastAccessTime);
                Tr.event(tc, "SFSB DRS cache entry timed out ", "DRS Key: " + cacheEntry.ivKey + ", Current Time: " + currentDate.toString() + ", Last Access Time: " + lastAccessTime.toString() + " Timeout: " + cacheEntry.ivTimeoutValue + " ms");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanExistsAndTimedOut(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beanExistsAndTimedOut for BeanId = " + beanId);
        }
        boolean existsAndTimedOut = false;
        SfDRSKey key = beanId.getDRSKey();
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get((Object)key);
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                existsAndTimedOut = this.beanTimedOut(cacheEntry);
            }
        }
        cacheEntry = this.faultDataIntoCache(beanId);
        if (cacheEntry != null) {
            CacheEntry cacheEntry3 = cacheEntry;
            synchronized (cacheEntry3) {
                existsAndTimedOut = this.beanTimedOut(cacheEntry);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beanExistsAndTimedOut returning " + existsAndTimedOut + " for BeanId = " + beanId);
        }
        return existsAndTimedOut;
    }

    private CacheEntry faultDataIntoCache(BeanId beanId) {
        SfDRSCacheEntry newEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "faultDataIntoCache for BeanId: " + beanId);
        }
        CacheEntry entry = null;
        SfDRSClient drs = beanId.getBeanMetaData().getSfDRSClient();
        if (drs != null && (newEntry = drs.getEntry(beanId)) != null) {
            SfDRSKey key = beanId.getDRSKey();
            this.addCacheEntry(key, newEntry, drs.ivSfDRSCacheMsgListener);
            entry = (CacheEntry)this.ivCache.get((Object)key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "faultDataIntoCache returning: " + entry + "for BeanId = " + beanId);
        }
        return entry;
    }

    public byte[] getAndRemoveData(BeanId beanId, SfDRSClient drsClient) {
        SfDRSKey key = beanId.getDRSKey();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAndRemoveData, key = " + key);
        }
        byte[] data = null;
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.remove((Object)key);
        if (cacheEntry != null) {
            data = cacheEntry.ivData;
            SfDRSCacheEntry e = new SfDRSCacheEntry(cacheEntry.ivKey, cacheEntry.ivTimeoutValue);
            e.ivData = data;
            e.ivLastAccessTime = cacheEntry.ivLastAccessTime;
            e.ivPassivated = cacheEntry.ivPassivated;
            e.ivSequenceNumber = cacheEntry.ivSequenceNumber;
            e.ivStickyUOW = cacheEntry.ivStickyUOW;
            drsClient.createEntry(beanId, e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            int n = data != null ? data.length : 0;
            Tr.exit(tc, "getAndRemoveData returning data of length: " + n);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SfDRSCacheEntry getCacheEntry(SfDRSKey key) {
        SfDRSCacheEntry newEntry = null;
        CacheEntry entry = (CacheEntry)this.ivCache.get((Object)key);
        if (entry != null) {
            newEntry = new SfDRSCacheEntry(key, entry.ivTimeoutValue);
            CacheEntry cacheEntry = entry;
            synchronized (cacheEntry) {
                newEntry.ivSequenceNumber = entry.ivSequenceNumber;
                newEntry.ivData = entry.ivData;
                newEntry.ivPassivated = entry.ivPassivated;
                newEntry.ivStickyUOW = entry.ivStickyUOW;
                newEntry.ivLastAccessTime = entry.ivLastAccessTime;
            }
        }
        return newEntry;
    }

    public void initialize(EJSContainer container2, DRSSettings drsSettings) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize for MultiBrokerDomain: " + this.ivMultibrokerDomain);
        }
        this.ivContainer = container2;
        if (drsSettings != null) {
            this.ivContainerId = container2.getHomeOfHomes().getJ2EEName().getApplication();
            this.ivContainerSfDRSClient = this.getSfDRSClient(this.ivContainerId, drsSettings);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inStickyUOW(BeanId beanId) {
        boolean stickyUOW = false;
        SfDRSKey key = beanId.getDRSKey();
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get((Object)key);
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                stickyUOW = cacheEntry.ivStickyUOW;
            }
        }
        return stickyUOW;
    }

    public final void removeCacheEntry(SfDRSKey key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeCacheEntry, key = " + key);
        }
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.remove((Object)key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (cacheEntry != null) {
                Tr.debug(tc, "removed cache entry: " + cacheEntry);
            } else {
                Tr.debug(tc, "cache entry not removed since it was not found");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeCacheEntry");
        }
    }

    public final void removeCacheEntry(BeanId beanId) {
        SfDRSKey key = beanId.getDRSKey();
        this.removeCacheEntry(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "sweep : DRS Cache size = " + this.ivCache.size());
        }
        Enumeration e = this.ivCache.elements();
        while (e.hasMoreElements()) {
            CacheEntry cacheEntry;
            boolean tryToDelete = false;
            CacheEntry cacheEntry2 = cacheEntry = (CacheEntry)e.nextElement();
            synchronized (cacheEntry2) {
                if (this.beanTimedOut(cacheEntry)) {
                    tryToDelete = true;
                }
            }
            if (!tryToDelete) continue;
            SfDRSKey key = cacheEntry.ivKey;
            this.ivCache.remove((Object)key);
            cacheEntry.ivOwner.removeIfPrimary(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "sweep : DRS Cache size = " + this.ivCache.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheEntry(SfDRSKey key, SfDRSCacheEntry newEntry, SfDRSCacheMsgListener ml) {
        CacheEntry entry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCacheEntry for key = " + key);
        }
        if ((entry = (CacheEntry)this.ivCache.get((Object)key)) == null) {
            this.addCacheEntry(key, newEntry, ml);
        } else if (newEntry.ivSequenceNumber > entry.ivSequenceNumber) {
            CacheEntry cacheEntry = entry;
            synchronized (cacheEntry) {
                entry.ivSequenceNumber = newEntry.ivSequenceNumber;
                entry.ivStickyUOW = newEntry.ivStickyUOW;
                entry.ivPassivated = newEntry.ivPassivated;
                entry.ivLastAccessTime = newEntry.ivLastAccessTime;
                if (newEntry.ivData != null) {
                    entry.ivData = newEntry.ivData;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "cached updated: " + entry);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "stale data cache entry: " + newEntry);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCacheEntry");
        }
    }

    public String getContainerDrsInstanceId() {
        return this.ivContainerId;
    }

    public final boolean isContainerSFSBFailoverEnabled() {
        return this.ivContainer.isEnableSFSBFailover();
    }

    private class CacheEntry {
        SfDRSKey ivKey;
        byte[] ivData;
        long ivSequenceNumber;
        long ivTimeoutValue;
        long ivLastAccessTime;
        boolean ivPassivated;
        boolean ivStickyUOW;
        SfDRSCacheMsgListener ivOwner;

        private CacheEntry() {
        }

        public String toString() {
            return "key = " + this.ivKey + ", sequence = " + this.ivSequenceNumber + ", passivated = " + this.ivPassivated + ", sticky UOW = " + this.ivStickyUOW;
        }
    }
}

