/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerAS;
import com.ibm.ejs.container.ContainerInternalError;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.activator.ActivatorCacheFullException;
import com.ibm.ejs.container.activator.SingletonActivationStrategy;
import com.ibm.ejs.container.activator.TimeoutKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.IllegalOperationException;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.ws.exception.WsEJBException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;

public class ReadOnlyEntityActivationStrategy
extends SingletonActivationStrategy {
    private static final TraceComponent tc = Tr.register(ReadOnlyEntityActivationStrategy.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy";

    ReadOnlyEntityActivationStrategy(Activator activator) {
        super(activator);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init> complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    BeanO atActivate(ContainerTx tx, BeanId beanId) throws RemoteException {
        BeanO bean;
        block53: {
            TimeoutKey key;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "atActivate (" + beanId + ")", tx);
            }
            Throwable exception = null;
            boolean pinned = false;
            boolean enlisted = false;
            ContainerAS as = null;
            bean = tx.find(beanId);
            if (bean == null && (as = tx.getContainerAS()) != null && (bean = as.find(beanId)) != null) {
                bean.enlist(tx);
            }
            if (bean != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found bean in Tran/AS Cache");
                }
                if (tx != null) {
                    tx.ivCallbackBeanO = bean;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "CallbackBeanO = " + bean);
                    }
                }
            } else {
                block52: {
                    key = new TimeoutKey(beanId);
                    Object object = this.locks.getLock(key);
                    synchronized (object) {
                        bean = (BeanO)this.cache.find(key);
                        if (bean == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Bean not in EJB Cache");
                            }
                            EJSHome home = (EJSHome)beanId.getHome();
                            bean = home.createBeanO(beanId, tx);
                            BeanMetaData bmd = home.getBeanMetaData();
                            key.setTimeoutByInterval(bmd.ivCacheReloadType, bmd.ivCacheReloadInterval);
                            this.cache.insert(key, bean);
                            bean.ivCacheKey = key;
                            pinned = true;
                        } else {
                            key = (TimeoutKey)bean.ivCacheKey;
                            if (key.expirationDetected()) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found bean in EJB Cache - Expired");
                                }
                                EJSHome home = (EJSHome)beanId.getHome();
                                BeanMetaData bmd = home.getBeanMetaData();
                                key.setTimeoutByInterval(bmd.ivCacheReloadType, bmd.ivCacheReloadInterval);
                                bean.invalidate();
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found bean in EJB Cache");
                                }
                                key.setInUse(true);
                            }
                            pinned = true;
                            if (tx != null) {
                                tx.ivCallbackBeanO = bean;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "CallbackBeanO = " + bean);
                                }
                            }
                        }
                    }
                    object = bean;
                    synchronized (object) {
                        bean.activate(beanId, tx);
                        enlisted = bean.enlist(tx);
                    }
                    as = tx.getContainerAS();
                    if (as == null) break block52;
                    as.enlist(bean);
                }
                Object var15_21 = null;
                if (exception == null) break block53;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "atActivate: exception raised", exception);
                }
                try {
                    if (enlisted) {
                        tx.delist(bean);
                    }
                    if (pinned) {
                        Object object = this.locks.getLock(key);
                        synchronized (object) {
                            this.cache.remove(key, true);
                        }
                    }
                    if (bean != null) {
                        bean.destroy();
                    }
                }
                catch (IllegalOperationException ex) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "atActivate: cache remove failed,  just unpinning, not unlocking");
                    }
                    this.cache.unpin(key);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "atActivate: " + exception);
                }
            }
            break block53;
            {
                catch (InsufficientCacheSpaceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy.atActivate", (String)"129", (Object)this);
                    exception = e;
                    throw new ActivatorCacheFullException();
                }
                catch (NoSuchObjectException e) {
                    exception = e;
                    throw e;
                }
                catch (RemoteException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy.atActivate", (String)"135", (Object)this);
                    exception = e;
                    throw e;
                }
                catch (RuntimeException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy.atActivate", (String)"313", (Object)this);
                    exception = e;
                    throw e;
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy.atActivate", (String)"319", (Object)this);
                    exception = e;
                    throw new WsEJBException(e);
                }
            }
            catch (Throwable throwable) {
                Object var15_22 = null;
                if (exception != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "atActivate: exception raised", exception);
                    }
                    try {
                        if (enlisted) {
                            tx.delist(bean);
                        }
                        if (pinned) {
                            Object object = this.locks.getLock(key);
                            synchronized (object) {
                                this.cache.remove(key, true);
                            }
                        }
                        if (bean != null) {
                            bean.destroy();
                        }
                    }
                    catch (IllegalOperationException ex) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "atActivate: cache remove failed,  just unpinning, not unlocking");
                        }
                        this.cache.unpin(key);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "atActivate: " + exception);
                    }
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atActivate: " + bean);
        }
        return bean;
    }

    void atPostInvoke(ContainerTx tx, BeanO bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "atPostInvoke (" + bean + ")", tx);
        }
    }

    BeanO atCreate(ContainerTx tx, BeanO bean) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "atCreate should never be called!!!");
        }
        throw new ContainerInternalError(new CreateException("Attempt made to create Read Only EJB"));
    }

    void atCommit(ContainerTx tx, BeanO bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atCommit (" + bean + ")", tx);
        }
        if (tx.getContainerAS() == null) {
            this.commonUnitOfWorkEnd(bean);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ActivitySession present - cache pin held");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atCommit");
        }
    }

    void atRollback(ContainerTx tx, BeanO bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atRollback (" + bean + ")", tx);
        }
        if (tx.getContainerAS() == null) {
            this.commonUnitOfWorkEnd(bean);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ActivitySession present - cache pin held");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atRollback");
        }
    }

    void atUnitOfWorkEnd(ContainerAS as, BeanO bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atUnitOfWorkEnd (" + bean + ")", as);
        }
        this.commonUnitOfWorkEnd(bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atUnitOfWorkEnd");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonUnitOfWorkEnd(BeanO bean) {
        block13: {
            BeanO removedBean = null;
            TimeoutKey key = (TimeoutKey)bean.ivCacheKey;
            Object object = this.locks.getLock(key);
            synchronized (object) {
                int pinned = this.cache.unpin(key);
                if (pinned == 0) {
                    if (key.expirationDetected()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Bean expired / no pins -> removing from Cache");
                        }
                        removedBean = (BeanO)this.cache.remove(key, false);
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Marking Bean no longer in use");
                        }
                        key.setInUse(false);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bean in use by other threads : " + pinned);
                }
            }
            if (removedBean != null) {
                try {
                    removedBean.passivate();
                }
                catch (RemoteException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy.atUnitOfWorkEnd", (String)"320", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block13;
                    Tr.event(tc, "Exception while passivating bean", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BeanO atGet(ContainerTx tx, BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atGet (" + beanId + ")", tx);
        }
        BeanO result = null;
        TimeoutKey key = new TimeoutKey(beanId);
        Object object = this.locks.getLock(key);
        synchronized (object) {
            result = (BeanO)this.cache.find(key);
            if (result != null) {
                this.cache.unpin(key);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atGet : " + result);
        }
        return result;
    }

    void atDiscard(BeanO bean) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atDiscard (" + bean + ")");
        }
        try {
            bean.ivCacheKey = null;
            bean.passivate();
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy.atDiscard", (String)"423", (Object)this);
            Tr.warning(tc, "UNABLE_TO_PASSIVATE_EJB_CNTR0005W", new Object[]{bean, this, e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "atDiscard", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atDiscard");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void atUninstall(BeanId beanId, BeanO bean) {
        Object key;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "atUninstall (" + bean + ")");
        }
        if ((key = bean.ivCacheKey) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "atUninstall: ReadOnly bean already removed");
            }
            return;
        }
        Object object = this.locks.getLock(key);
        synchronized (object) {
            try {
                bean = (BeanO)this.cache.remove(key, false);
                if (bean != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "ReadOnly bean removed from EJB Cache");
                    }
                    bean.ivCacheKey = null;
                    bean.destroy();
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "ReadOnly bean NOT found in EJB Cache");
                }
            }
            catch (IllegalOperationException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.activator.ReadOnlyEntityActivationStrategy.atUninstall", (String)"457", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Unable to remove uninstalled bean instance", ex);
                }
                ((TimeoutKey)key).setDiscarded();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "atUninstall");
        }
    }
}

