/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.ExceptionMappingStrategy;
import com.ibm.ejs.container.WSEJBProxy;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.ejbcontainer.WSEJBEndpointManager;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSEJBWrapper
extends EJSWrapperBase
implements WSEJBEndpointManager {
    private static final String CLASS_NAME = WSEJBWrapper.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ws.runtime.runtime");
    private Method ivMethod = null;
    private EJSDeployedSupport ivMethodContext = null;
    private int ivMethodIndex = Integer.MIN_VALUE;

    @Override
    public Object ejbPreInvoke(Method method, Map<String, Object> context) throws RemoteException {
        if (this.ivMethod != null) {
            throw new IllegalStateException("WSEJBEndpointManager.ejbPreInvoke called previously : " + this.ivMethod.getName());
        }
        if (method == null) {
            throw new IllegalArgumentException("WSEJBEndpointManager.ejbPreInvoke requires a method");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ejbPreInvoke : " + method.getName());
        }
        Object[] args = null;
        this.ivMethod = method;
        this.ivMethodIndex = this.getMethodIndex(method);
        this.ivMethodContext = this.container.getEJSDeployedSupport(this);
        this.ivMethodContext.ivWSMessageContext = context;
        Object bean = this.container.EjbPreInvoke(this, this.ivMethodIndex, this.ivMethodContext, args);
        if (this.bmd.ivWebServiceEndpointProxyClass != null) {
            try {
                WSEJBProxy proxy = (WSEJBProxy)this.bmd.ivWebServiceEndpointProxyClass.newInstance();
                proxy.ivContainer = this.container;
                proxy.ivMethodContext = this.ivMethodContext;
                proxy.ivEjbInstance = bean;
                bean = proxy;
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".ejbPreInvoke"), (String)"192", (Object)this);
                throw ExceptionUtil.EJBException("Failed to create proxy for Web service endpoint", ex);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ejbPreInvoke : " + this.ivMethod.getName() + " : " + bean.getClass().getName());
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ejbPostInvoke() throws RemoteException {
        if (this.ivMethod == null) {
            throw new IllegalStateException("WSEJBEndpointManager.ejbPreInvoke must be called first.");
        }
        if (this.ivMethodContext == null) {
            if (this.ivMethodIndex != Integer.MIN_VALUE) {
                throw new IllegalStateException("WSEJBEndpointManager.ejbPostInvoke already called.");
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "ejbPostInvoke : " + this.ivMethod.getName());
        }
        try {
            this.container.postInvoke(this, this.ivMethodIndex, this.ivMethodContext);
            Object var2_1 = null;
            this.container.putEJSDeployedSupport(this.ivMethodContext);
            this.ivMethodContext = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.container.putEJSDeployedSupport(this.ivMethodContext);
            this.ivMethodContext = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "ejbPostInvoke : " + this.ivMethod.getName());
            }
            throw throwable;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "ejbPostInvoke : " + this.ivMethod.getName());
        }
    }

    @Override
    public Throwable setException(Throwable ex) {
        if (this.ivMethod == null) {
            throw new IllegalStateException("WSEJBEndpointManager.ejbPreInvoke must be called first.");
        }
        if (this.ivMethodContext == null) {
            if (this.ivMethodIndex != Integer.MIN_VALUE) {
                throw new IllegalStateException("WSEJBEndpointManager.ejbPostInvoke already called.");
            }
            return ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setException : " + ex.getClass().getName());
        }
        Throwable mappedException = null;
        ExceptionMappingStrategy exStrategy = this.ivMethodContext.exceptionStrategy;
        if (ex instanceof Exception && !(ex instanceof RemoteException)) {
            Class<?>[] checkedExceptions;
            Class<?> exceptionClass = ex.getClass();
            for (Class<?> checkedClass : checkedExceptions = this.ivMethod.getExceptionTypes()) {
                if (!checkedClass.isAssignableFrom(exceptionClass)) continue;
                exStrategy.setCheckedException((Exception)ex);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "setException : " + ex.getClass().getName());
                }
                return ex;
            }
        }
        mappedException = exStrategy.setUncheckedException(ex);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setException : " + mappedException.getClass().getName());
        }
        return mappedException;
    }

    private int getMethodIndex(Method method) {
        for (int i = 0; i < this.methodInfos.length; ++i) {
            if (!this.methodInfos[i].methodsMatch(method)) continue;
            return i;
        }
        Tr.error(tc, "WS_ENDPOINT_METHOD_MISSING_CNTR0178E", new Object[]{method.getName(), this.bmd.j2eeName.getComponent(), this.bmd.j2eeName.getModule(), this.bmd.j2eeName.getApplication()});
        throw ExceptionUtil.EJBException("Configured Web service endpoint method " + method.getName() + " is not implemented by the " + this.bmd.j2eeName.getComponent() + " bean in the " + this.bmd.j2eeName.getModule() + " module of the " + this.bmd.j2eeName.getApplication() + " application.", null);
    }

    static boolean resolveWebServiceEndpointMethods(BeanMetaData bmd, Method[] endpointMethods) throws EJBConfigurationException {
        if (endpointMethods == null || endpointMethods.length == 0) {
            throw new EJBConfigurationException("Web service endpoint configurd with no methods : " + bmd.j2eeName);
        }
        if (bmd.wsEndpointMethodInfos == null) {
            throw new EJBConfigurationException("Web service endpoint is only allwed for stateless session beans, and a Web service endpoint interface must be configured in ejb-jar.xml if the module level is prior to 3.0 : " + bmd.j2eeName);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveWebServiceEndpointMethods : " + bmd.j2eeName);
        }
        boolean hasAroundInvoke = false;
        int numMethodInfos = bmd.wsEndpointMethodInfos.length;
        int numEndpointMethods = endpointMethods.length;
        String[] endpointMethodNames = new String[numEndpointMethods];
        EJBMethodInfoImpl[] endpointMethodInfos = new EJBMethodInfoImpl[numEndpointMethods];
        for (int i = 0; i < numEndpointMethods; ++i) {
            Method method = endpointMethods[i];
            for (int j = 0; j < numMethodInfos; ++j) {
                EJBMethodInfoImpl methodInfo = bmd.wsEndpointMethodInfos[j];
                if (!methodInfo.methodsMatch(method)) continue;
                endpointMethodInfos[i] = methodInfo;
                endpointMethodNames[i] = method.getName();
                if (methodInfo.ivAroundInvokeInterceptors != null) {
                    hasAroundInvoke = true;
                }
                if (methodInfo.getBridgeMethod() != null) break;
            }
            if (endpointMethodInfos[i] != null) continue;
            Tr.error(tc, "WS_ENDPOINT_METHOD_MISSING_CNTR0178E", new Object[]{method.getName(), bmd.j2eeName.getComponent(), bmd.j2eeName.getModule(), bmd.j2eeName.getApplication()});
            throw new EJBConfigurationException("Configured Web service endpoint method " + method.getName() + " is not implemented by the " + bmd.j2eeName.getComponent() + " bean in the " + bmd.j2eeName.getModule() + " module of the " + bmd.j2eeName.getApplication() + " application.");
        }
        bmd.wsEndpointMethodInfos = endpointMethodInfos;
        bmd.wsEndpointMethodNames = endpointMethodNames;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveWebServiceEndpointMethods : " + bmd.j2eeName + " : aroundInvoke = " + hasAroundInvoke);
        }
        return hasAroundInvoke;
    }
}

