/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimerHandleImpl;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.TimerTaskInfoImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.scheduler.Scheduler;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.csi.TimerTaskInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public final class TimerImpl
implements Timer {
    private static final TraceComponent tc = Tr.register(TimerImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerImpl";
    private String ivTaskId;
    private BeanId ivBeanId;
    private EJSHome ivHome;
    private Scheduler ivScheduler;
    private int ivHashCode;
    protected transient TaskStatus ivStatus;

    TimerImpl(BeanId beanId, Date expiration, long interval, Serializable info) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String infoClassName = info == null ? null : info.getClass().getName();
            Tr.entry(tc, "TimerImpl: " + beanId + ", " + expiration + ", " + interval + ", " + infoClassName);
        }
        try {
            this.ivBeanId = beanId;
            this.ivHome = (EJSHome)beanId.home;
            this.ivScheduler = this.ivHome.container.ivScheduler;
            boolean runInGlobalTx = false;
            if (this.ivHome.beanMetaData.timedMethodInfos[0].getTransactionAttribute() == TransactionAttribute.TX_REQUIRED) {
                runInGlobalTx = true;
            }
            TimerTaskInfoImpl taskInfo = new TimerTaskInfoImpl(beanId, expiration, interval, info, TimerImpl.getTaskName(beanId), runInGlobalTx);
            TaskStatus taskStatus = this.ivScheduler.create(taskInfo);
            this.ivTaskId = taskStatus.getTaskId();
            this.ivHashCode = taskStatus.hashCode();
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.<init>", (String)"128", (Object)this);
            TimerServiceException tse = new TimerServiceException(this.toString(), th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "TimerImpl: " + tse);
            }
            throw tse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.toString());
        }
    }

    TimerImpl(BeanId beanId, String taskId, int hashCode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TimerImpl : " + beanId + ", " + taskId);
        }
        this.ivTaskId = taskId;
        this.ivBeanId = beanId;
        this.ivHome = (EJSHome)this.ivBeanId.home;
        this.ivScheduler = this.ivHome.container.ivScheduler;
        this.ivHashCode = hashCode;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, this.toString());
        }
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cancel: " + this);
        }
        this.checkTimerAccess();
        try {
            this.ivScheduler.cancel(this.ivTaskId, true);
        }
        catch (TaskInvalid invalid) {
            FFDCFilter.processException((Throwable)invalid, (String)"com.ibm.ejs.container.TimerImpl.cancel", (String)"203", (Object)this);
            NoSuchObjectLocalException nsoe = new NoSuchObjectLocalException(this.toString(), invalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cancel: " + nsoe);
            }
            throw nsoe;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.cancel", (String)"215", (Object)this);
            TimerServiceException tse = new TimerServiceException(this.toString(), th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "cancel: " + tse);
            }
            throw tse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel: successful");
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Date nextTime = this.getNextTimeout();
        long currentTime = System.currentTimeMillis();
        long remaining = nextTime.getTime() - currentTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimeRemaining: " + remaining);
        }
        return remaining;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextTimeout: " + this);
        }
        this.checkTimerAccess();
        Date nextTime = null;
        TaskStatus taskStatus = this.ivStatus;
        try {
            if (taskStatus == null) {
                taskStatus = this.ivScheduler.getStatus(this.ivTaskId);
            }
            nextTime = taskStatus.getNextFireTime();
        }
        catch (TaskInvalid invalid) {
            FFDCFilter.processException((Throwable)invalid, (String)"com.ibm.ejs.container.TimerImpl.getNextTimeout", (String)"288", (Object)this);
            NoSuchObjectLocalException nsoe = new NoSuchObjectLocalException(this.toString(), invalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getNextTimeout: " + nsoe);
            }
            throw nsoe;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.getNextTimeout", (String)"300", (Object)this);
            TimerServiceException tse = new TimerServiceException(this.toString(), th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getNextTimeout: " + tse);
            }
            throw tse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextTimeout: " + nextTime);
        }
        return nextTime;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInfo: " + this);
        }
        this.checkTimerAccess();
        Serializable userInfo = null;
        TimerTaskInfo taskInfo = null;
        try {
            taskInfo = (TimerTaskInfo)this.ivScheduler.getTask(this.ivTaskId);
            userInfo = taskInfo.getInfo();
        }
        catch (TaskInvalid invalid) {
            FFDCFilter.processException((Throwable)invalid, (String)"com.ibm.ejs.container.TimerImpl.getInfo", (String)"351", (Object)this);
            NoSuchObjectLocalException nsoe = new NoSuchObjectLocalException(this.toString(), invalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getInfo: " + nsoe);
            }
            throw nsoe;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.getInfo", (String)"363", (Object)this);
            TimerServiceException tse = new TimerServiceException(this.toString(), th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getInfo: " + tse);
            }
            throw tse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInfo: " + userInfo);
        }
        return userInfo;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getHandle: " + this);
        }
        this.checkTimerAccess();
        TimerHandleImpl timerHandle = null;
        try {
            if (this.ivStatus == null) {
                this.ivScheduler.getStatus(this.ivTaskId);
            }
            timerHandle = new TimerHandleImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode, false);
        }
        catch (TaskInvalid invalid) {
            FFDCFilter.processException((Throwable)invalid, (String)"com.ibm.ejs.container.TimerImpl.getHandle", (String)"415", (Object)this);
            NoSuchObjectLocalException nsoe = new NoSuchObjectLocalException(this.toString(), invalid);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getHandle: " + nsoe);
            }
            throw nsoe;
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.getHandle", (String)"427", (Object)this);
            TimerServiceException tse = new TimerServiceException(this.toString(), th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getHandle: " + tse);
            }
            throw tse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getHandle: " + timerHandle);
        }
        return timerHandle;
    }

    static Collection findTimersByBeanId(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findTimersByBeanId: " + beanId);
        }
        ArrayList<TimerImpl> timers = new ArrayList<TimerImpl>();
        String taskName = TimerImpl.getTaskName(beanId);
        EJSHome home = (EJSHome)beanId.home;
        Scheduler scheduler = home.container.ivScheduler;
        long numFound = 0L;
        Iterator tasks = null;
        try {
            tasks = scheduler.findTasksByName(taskName);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.findTimersByBeanId", (String)"487");
            TimerServiceException tse = new TimerServiceException(beanId.toString(), th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "findTimersByBeanId: " + tse);
            }
            throw tse;
        }
        while (tasks.hasNext()) {
            TimerTaskInfo task = (TimerTaskInfo)tasks.next();
            BeanId timedObjectId = (BeanId)task.getTimedObjectId();
            if (beanId.equals(timedObjectId)) {
                TimerImpl timer = new TimerImpl(timedObjectId, task.getTaskId(), task.hashCode());
                timers.add(timer);
            }
            ++numFound;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findTimersByBeanId: " + timers.size() + "(of " + numFound + " found)");
        }
        return timers;
    }

    static void removeTimersByBeanId(BeanId beanId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeTimersByBeanId: " + beanId);
        }
        String taskName = TimerImpl.getTaskName(beanId);
        EJSHome home = (EJSHome)beanId.home;
        Scheduler scheduler = home.container.ivScheduler;
        long numFound = 0L;
        long numRemoved = 0L;
        Iterator tasks = null;
        try {
            tasks = scheduler.findTasksByName(taskName);
        }
        catch (Throwable th) {
            FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", (String)"559");
            TimerServiceException tse = new TimerServiceException(beanId.toString(), th);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "removeTimersByBeanId: " + tse);
            }
            throw tse;
        }
        while (tasks.hasNext()) {
            TimerTaskInfo task = (TimerTaskInfo)tasks.next();
            BeanId timedObjectId = (BeanId)task.getTimedObjectId();
            if (beanId.equals(timedObjectId)) {
                try {
                    scheduler.cancel(task.getTaskId(), true);
                    ++numRemoved;
                }
                catch (TaskInvalid invalid) {
                    FFDCFilter.processException((Throwable)invalid, (String)"com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", (String)"591");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "TaskInvalid ignored : " + task.getTaskId());
                    }
                }
                catch (Throwable th) {
                    FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", (String)"601");
                    TimerServiceException tse = new TimerServiceException(task.toString(), th);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "removeTimersByBeanId: " + tse);
                    }
                    throw tse;
                }
            }
            ++numFound;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTimersByBeanId: " + numRemoved + "(of " + numFound + " found)");
        }
    }

    private static String getTaskName(BeanId beanId) {
        J2EEName j2eeName = beanId.getJ2EEName();
        StringBuffer sb = new StringBuffer(j2eeName.getComponent());
        if (sb.length() > 240) {
            sb.setLength(240);
        }
        sb.append("_").append(beanId.hashCode());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "taskName = " + sb);
        }
        return sb.toString();
    }

    protected void checkTimerAccess() throws IllegalStateException {
        IllegalStateException ise;
        BeanO beanO;
        block6: {
            beanO = null;
            ContainerTx tx = null;
            Object s = null;
            ise = null;
            try {
                tx = this.ivHome.container.getCurrentTx(false);
                if (tx != null) {
                    beanO = tx.ivCallbackBeanO;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "checkTimerAccess: checking callback  beanO from current tx: " + beanO);
                    }
                }
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ejs.container.TimerImpl.checkTimerAccess", (String)"703", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Exception ignored : " + th);
            }
        }
        if (beanO == null) {
            ise = new IllegalStateException("Timer: Timer methods not allowed - no active EJB");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "checkTimerAccess: " + ise);
            }
            throw ise;
        }
        beanO.checkTimerServiceAccess();
    }

    public TimerHandleImpl getSerializableObject() {
        TimerHandleImpl timerHandle = new TimerHandleImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode, true);
        return timerHandle;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimerImpl) {
            TimerImpl timer = (TimerImpl)obj;
            if (this.ivHashCode == timer.ivHashCode && this.ivTaskId.equals(timer.ivTaskId)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(TimerImpl timer) {
        return timer != null && this.ivHashCode == timer.ivHashCode && this.ivTaskId.equals(timer.ivTaskId);
    }

    public int hashCode() {
        return this.ivHashCode;
    }

    public String toString() {
        return "TimerImpl(" + this.ivTaskId + ", " + this.ivBeanId + ")";
    }
}

