/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.RemoteClassByteServer;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;

public class RemoteClassLoader
extends ClassLoader {
    private static final String CLASS_NAME = "com.ibm.ejs.container.RemoteClassLoader";
    RemoteClassByteServer byteServer;
    J2EEName j2eeName;

    public RemoteClassLoader(RemoteClassByteServer byteServer, J2EEName j2eeName) {
        this.byteServer = byteServer;
        this.j2eeName = j2eeName;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            byte[] classBytes;
            try {
                classBytes = this.byteServer.getClassBytes(name, this.j2eeName);
            }
            catch (RemoteException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.RemoteClassLoader.findClass", (String)"65", (Object)this);
                throw new ClassNotFoundException(ex.getMessage());
            }
            result = this.defineClass(name, classBytes, 0, classBytes.length);
        }
        return result;
    }
}

