/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.RemoteClassByteServer;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;

public class RemoteClassByteServerImpl
extends PortableRemoteObject
implements RemoteClassByteServer {
    private static final String CLASS_NAME = "com.ibm.ejs.container.RemoteClassByteServerImpl";
    private final EJSContainer container;
    private final int READ_BUFFER_SIZE = 256;

    public RemoteClassByteServerImpl(EJSContainer container2) throws RemoteException {
        this.container = container2;
    }

    public synchronized byte[] getClassBytes(String name, J2EEName j2eeName) throws RemoteException {
        System.out.println("Processing request for " + name);
        byte[] buffer = new byte[256];
        try {
            int bytesRead;
            ClassLoader classLoader = EJSContainer.getClassLoader(j2eeName);
            InputStream is = classLoader.getResourceAsStream(this.getResourceName(name));
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            while ((bytesRead = is.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
            return outStream.toByteArray();
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.RemoteClassByteServerImpl.getClassBytes", (String)"71", (Object)this);
            System.out.println("Exception : " + ex);
            throw new RemoteException(ex.getMessage());
        }
    }

    private String getResourceName(String className) {
        String resName = className;
        resName = resName.replace('.', '/') + ".class";
        System.out.println("Resource name : " + resName);
        return resName;
    }
}

