/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.MDBInternalHome;
import com.ibm.ejs.container.MessageEndpointHandler;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.Pool;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.ws.Transaction.RecoverableXAResource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.MessageEndpointFactory;
import com.ibm.ws.j2c.RALifeCycleManager;
import com.ibm.ws.j2c.RALifeCycleManagerFactory;
import com.ibm.ws.runtime.component.ApplicationEventListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

public class MessageEndpointFactoryImpl
extends EJSHome
implements MessageEndpointFactory,
MDBInternalHome,
ApplicationEventListener {
    private static final long serialVersionUID = 6055819285757596987L;
    private static final String CLASS_NAME = "com.ibm.ejs.container.MessageEndpointFactoryImpl";
    protected static TraceComponent tc = Tr.register(MessageEndpointFactoryImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private final byte INACTIVE_STATE = 0;
    private final byte ACTIVATING_STATE = 1;
    private final byte ACTIVE_STATE = (byte)2;
    private final byte DEACTIVATING_STATE = (byte)3;
    private final byte DEACTIVATE_PENDING_STATE = (byte)4;
    private byte ivState = 0;
    private Thread ivActivatingThread = null;
    private int ivRecoveryId;
    private boolean ivRecoveryIdKnown = false;
    private boolean ivEnlistNotNeeded = false;
    private int ivEnlistNotNeededReason;
    private boolean ivEnlistNotNeededMessageLogged = false;
    private Constructor<?> ivProxyCTOR = null;
    private Pool ivInvocationHandlerPool = null;
    private int ivNumberOfMessageEndpointsCreated;
    private int ivMaxCreation;
    private EJBMethodInfo[] ivMdbMethods;
    private String ivDeactivationKey = null;
    private String ivRAKey = null;
    private boolean ivJMS = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateEndpoint(EJBConfigData ejbConfigData) throws ResourceException {
        ResourceException ex;
        block22: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "MEF.activateEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName);
            }
            ex = null;
            RALifeCycleManager r = RALifeCycleManagerFactory.getInstance();
            String deactivationKey = null;
            Thread currentThread = Thread.currentThread();
            try {
                Constructor<?> constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    if (this.ivState == 0) {
                        this.ivState = 1;
                        this.ivActivatingThread = currentThread;
                    } else if (this.ivState == 2) {
                        r = null;
                    } else {
                        r = null;
                        ex = new ResourceException("can not activate until deactivate completes");
                    }
                }
                if (r == null) break block22;
                deactivationKey = r.activateEndpoint(this.beanMetaData.ivActivationSpecJndiName, (MessageEndpointFactory)this, this.beanMetaData.ivActivationConfig, this.beanMetaData.j2eeName, this.beanMetaData.ivActivationSpecAuthAlias, this.beanMetaData.ivMessageDestinationJndiName);
                constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    this.ivDeactivationKey = deactivationKey;
                }
            }
            catch (ResourceException re) {
                Constructor<?> constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    this.ivState = 0;
                }
                ex = re;
            }
            catch (Throwable t) {
                Constructor<?> constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    this.ivState = 0;
                }
                ex = new ResourceException(t);
            }
        }
        this.beanMetaData.ivActivationConfig = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.activateEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateEndpoint() throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.deactivateEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        RALifeCycleManager r = RALifeCycleManagerFactory.getInstance();
        String deactivationKey = null;
        Constructor<?> constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            if (this.ivState == 2 || this.ivState == 4) {
                this.ivState = (byte)3;
                deactivationKey = this.ivDeactivationKey;
                if (deactivationKey == null) {
                    this.ivState = 0;
                }
            } else if (this.ivState != 0) {
                throw new ResourceException("illegal state for deactivate");
            }
        }
        if (deactivationKey != null) {
            Constructor<?> constructor2;
            try {
                r.deactivateEndPoint(deactivationKey);
                Object var6_5 = null;
                constructor2 = this.ivProxyCTOR;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Constructor<?> constructor3 = this.ivProxyCTOR;
                synchronized (constructor3) {
                    this.ivState = 0;
                    this.ivDeactivationKey = null;
                }
                throw throwable;
            }
            synchronized (constructor2) {
                this.ivState = 0;
                this.ivDeactivationKey = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.deactivateEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEndpoint createEndpoint(XAResource xaResource) throws UnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.createEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        boolean recoverableXAResource = false;
        MessageEndpointHandler handler = null;
        Proxy proxy = null;
        boolean newInstanceRequired = false;
        Constructor<?> constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            if (!(xaResource == null || this.ivRecoveryIdKnown && this.ivRecoveryId != 0 || this.ivEnlistNotNeeded)) {
                if (xaResource instanceof RecoverableXAResource) {
                    recoverableXAResource = true;
                } else {
                    Tr.error(tc, "ENDPOINT_RECOVERY_ID_UNKNOWN_CNTR0082E", new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                    throw new UnavailableException("setRecoveryId must be called prior to createEndpoint");
                }
            }
            if (this.ivState == 2) {
                if (this.ivDeactivationKey == null) {
                    throw new UnavailableException("endpoint needs to be activated.");
                }
                if (this.ivInvocationHandlerPool != null && (handler = (MessageEndpointHandler)this.ivInvocationHandlerPool.get()) == null) {
                    if (this.ivNumberOfMessageEndpointsCreated >= this.ivMaxCreation) {
                        throw new UnavailableException("limit for number of MessageEndpoint proxies created reached.");
                    }
                    ++this.ivNumberOfMessageEndpointsCreated;
                    newInstanceRequired = true;
                }
            } else if (this.ivState == 1) {
                if (this.ivActivatingThread == Thread.currentThread()) {
                    throw new UnavailableException("activating thread not allowed to create endpoint during activation.");
                }
                try {
                    this.ivProxyCTOR.wait();
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                if (this.ivState != 2) {
                    throw new UnavailableException("endpoint needs to be activated.");
                }
            } else {
                if (this.ivState == 3 || this.ivState == 4) {
                    throw new UnavailableException("deactivate of endpoint is in progress.");
                }
                throw new UnavailableException("endpoint needs to be activated.");
            }
        }
        UnavailableException ex = null;
        try {
            if (handler != null) {
                proxy = (Proxy)handler.ivProxy;
            } else {
                handler = new MessageEndpointHandler(this, this.ivRecoveryId, this.container, this.beanMetaData, this.pmiBean, this.wrapperManager, this.ivJMS);
                proxy = (Proxy)this.ivProxyCTOR.newInstance(handler);
                handler.ivProxy = proxy;
            }
            if (this.ivEnlistNotNeeded) {
                if (xaResource == null) {
                    handler.initialize(null, false);
                } else {
                    ex = this.mapAndLogTranEnlistmentNotNeeded();
                }
            } else {
                handler.initialize(xaResource, recoverableXAResource);
            }
        }
        catch (Throwable t) {
            Tr.error(tc, "CREATE_ENDPOINT_FAILED_CNTR0083E", t);
            ex = new UnavailableException("Creation of MessageEndpoint Proxy failed", t);
        }
        if (ex != null) {
            if (this.ivInvocationHandlerPool != null) {
                if (handler != null && proxy != null) {
                    this.ivInvocationHandlerPool.put(handler);
                } else if (newInstanceRequired) {
                    Constructor<?> t = this.ivProxyCTOR;
                    synchronized (t) {
                        --this.ivNumberOfMessageEndpointsCreated;
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                BeanMetaData bmd = this.beanMetaData;
                Tr.exit(tc, "createEndpoint for enterprise class " + bmd.enterpriseBeanName + " failed.");
            }
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.createEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        return (MessageEndpoint)((Object)proxy);
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        boolean transacted;
        EJBMethodInfo minfo;
        BeanMetaData bmd = this.beanMetaData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.isDeliveryTransacted called for " + bmd.enterpriseBeanName + "." + method.getName());
        }
        if ((minfo = this.getEJBMethodInfo(method)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "MEF.isDeliveryTransacted failed to find method " + bmd.enterpriseBeanName + "." + method.getName());
            }
            Tr.error(tc, "NO_SUCH_MDB_METHOD_CNTR0085E", new Object[]{bmd.j2eeName, method.getName(), bmd.localInterfaceClass});
            throw new NoSuchMethodException(bmd.enterpriseBeanName + "." + method.getName() + " not found");
        }
        TransactionAttribute txAttr = minfo.getTransactionAttribute();
        if (txAttr == TransactionAttribute.TX_REQUIRED) {
            transacted = true;
        } else if (txAttr == TransactionAttribute.TX_NOT_SUPPORTED) {
            transacted = false;
        } else if (txAttr == TransactionAttribute.TX_BEAN_MANAGED) {
            transacted = false;
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "MEF.isDeliveryTransacted detected invalid TX attribute for " + bmd.enterpriseBeanName + "." + method.getName() + ", TX attribute is " + txAttr);
            }
            Tr.error(tc, "INVALID_MDB_TX_ATTR_CNTR0084E", new Object[]{method.getName(), bmd.j2eeName});
            ApplicationServerInternalException r = new ApplicationServerInternalException("Method exists, but TX attribute is neither REQUIRED, NOT_SUPPORTED, nor BEAN_MANAGED: " + txAttr);
            NoSuchMethodException ex = new NoSuchMethodException("see chained exception");
            ex.initCause(r);
            throw ex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.isDeliveryTransacted returning " + transacted + " for " + bmd.enterpriseBeanName + "." + method.getName());
        }
        return transacted;
    }

    private EJBMethodInfo getEJBMethodInfo(Method method) {
        String targetSignature = MethodAttribUtils.methodSignature(method);
        EJBMethodInfo minfo2 = null;
        for (EJBMethodInfo minfo2 : this.ivMdbMethods) {
            if (!targetSignature.equals(minfo2.getMethodSignature())) continue;
            return minfo2;
        }
        return null;
    }

    public void initialize(EJSContainer container2, BeanId id, BeanMetaData bmd) throws RemoteException {
        super.initialize(container2, id, bmd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF Initializing MessageEndpointFactory for enterprise class " + bmd.enterpriseBeanName + ", with message listener interface of " + bmd.localInterfaceClass.getName());
        }
        this.ivMdbMethods = this.beanMetaData.getEJBMethodMetaData(MethodInterface.MESSAGE_LISTENER);
        if (bmd.localInterfaceClass.isAssignableFrom(bmd.enterpriseBeanClass)) {
            this.ivJMS = bmd.localInterfaceClass.getName().equals("javax.jms.MessageListener");
        }
        Class[] interfaces = new Class[]{MessageEndpoint.class, bmd.localInterfaceClass};
        Class<?> proxyClass = Proxy.getProxyClass(bmd.classLoader, interfaces);
        try {
            this.ivProxyCTOR = proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "MEF initialization for enterprise class " + bmd.enterpriseBeanName + " with messaging listener interface of " + bmd.localInterfaceClass.getName() + " failed.");
            }
            throw new RemoteException("Unable to get Proxy Constructor Method object", t);
        }
        this.ivMaxCreation = bmd.maxPoolSize;
        if (this.ivMaxCreation > 0) {
            this.ivInvocationHandlerPool = container2.poolManager.createThreadSafePool(bmd.minPoolSize, bmd.maxPoolSize);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MessageEndpointFactory initialized for enterprise class " + bmd.enterpriseBeanName + " with messaging listener interface of " + bmd.localInterfaceClass.getName());
        }
    }

    public void setRecoveryID(int recoveryId) throws ResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        if (this.ivRecoveryIdKnown) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName);
            }
            throw new ApplicationServerInternalException("setRecoveryId can only be called once per factory");
        }
        this.ivRecoveryId = recoveryId;
        this.ivRecoveryIdKnown = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
    }

    public void setTranEnlistmentNotNeeded(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.setTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName + ", reason =  " + reason);
        }
        this.ivEnlistNotNeeded = true;
        this.ivEnlistNotNeededReason = reason;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.setTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
    }

    private UnavailableException mapAndLogTranEnlistmentNotNeeded() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.mapAndLogTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        UnavailableException ex = null;
        switch (this.ivEnlistNotNeededReason) {
            case 0: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error(tc, "RA_DOES_NOT_SUPPORT_XATRANSACTIONS_CNTR0087E", new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                }
                ex = new UnavailableException("Transaction recovery not setup for this RA since RA does not support XA transactions");
                break;
            }
            case 1: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error(tc, "ERROR_DURING_TRAN_RECOVERY_SETUP_CNTR0086E", new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                }
                ex = new UnavailableException("Error occured during transaction recovery setup for this Resource Adapter");
                break;
            }
            default: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error(tc, "REASON_CODE_NOT_RECOGNIZED_CNTR0081E", new Integer(this.ivEnlistNotNeededReason));
                }
                ex = new UnavailableException("Error occured during transaction recovery setup for this Resource Adapter");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.mapAndLogTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        this.ivEnlistNotNeededMessageLogged = true;
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnInvocationHandler(MessageEndpointHandler handler, boolean reuse) {
        if (this.ivInvocationHandlerPool != null) {
            if (reuse) {
                this.ivInvocationHandlerPool.put(handler);
            } else {
                Constructor<?> constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    --this.ivNumberOfMessageEndpointsCreated;
                }
            }
        }
    }

    public void setRAKey(String raKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.setRAKey for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        this.ivRAKey = raKey;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.setRAKey for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageEndpointForcefullyDeactivated() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.messageEndpointForcefullyDeactivated called for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
        Constructor<?> constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            this.ivDeactivationKey = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.messageEndpointForcefullyDeactivated exit for enterprise class " + this.beanMetaData.enterpriseBeanName);
        }
    }

    public int getMaxPoolSize() {
        return this.ivMaxCreation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() {
        if (this.ivInvocationHandlerPool != null) {
            Constructor<?> constructor = this.ivProxyCTOR;
            synchronized (constructor) {
                --this.ivNumberOfMessageEndpointsCreated;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applicationStarted(String appName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.applicationStarted for application " + appName);
        }
        Constructor<?> constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            this.ivState = (byte)2;
            this.ivProxyCTOR.notifyAll();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.applicationStarted for application " + appName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applicationStopping(String appName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "MEF.applicationStopping for application " + appName);
        }
        Constructor<?> constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            if (this.ivState == 2) {
                this.ivState = (byte)4;
            } else if (this.ivState == 1) {
                this.ivState = (byte)4;
                this.ivProxyCTOR.notifyAll();
            } else if (this.ivState == 4) {
                this.ivProxyCTOR.notifyAll();
            } else if (this.ivState == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "MEF.applicationStopping for application " + appName + " was called for an inactive endpoint.");
                }
            } else {
                String msg = "Internal programming error - applicationStopping called for application \"" + appName + "\" while in deactivating state. This should NEVER occur.";
                IllegalStateException ex = new IllegalStateException(msg);
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.container.MessageEndpointFactoryImpl.applicationStopping", (String)"1208", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, msg);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "MEF.applicationStopping for application " + appName);
        }
        return true;
    }
}

