/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BusinessExceptionMappingStrategy;
import com.ibm.ejs.container.EJSDeployedSupport;
import com.ibm.ejs.container.EJSWrapperBase;
import com.ibm.ejs.container.LocalExceptionMappingStrategy;
import com.ibm.ejs.container.RemoteExceptionMappingStrategy;
import com.ibm.ejs.container.WrapperInterface;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

class EJSDeployedSupportStack {
    private static final TraceComponent tc = Tr.register(EJSDeployedSupportStack.class, "EJBContainer", "com.ibm.ejs.container.container");
    private EJSDeployedSupport[] elements;
    private int topOfStack = 0;
    private boolean orig = false;
    private LocalExceptionMappingStrategy[] localExceptionMappingStrategies;
    private RemoteExceptionMappingStrategy[] remoteExceptionMappingStrategies;
    private BusinessExceptionMappingStrategy[] businessExceptionMappingStrategies;

    EJSDeployedSupportStack(int capacity) {
        this.elements = new EJSDeployedSupport[capacity];
        this.localExceptionMappingStrategies = new LocalExceptionMappingStrategy[capacity];
        this.remoteExceptionMappingStrategies = new RemoteExceptionMappingStrategy[capacity];
        this.businessExceptionMappingStrategies = new BusinessExceptionMappingStrategy[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.elements[i] = new EJSDeployedSupport();
            this.localExceptionMappingStrategies[i] = new LocalExceptionMappingStrategy(this.elements[i]);
            this.remoteExceptionMappingStrategies[i] = new RemoteExceptionMappingStrategy(this.elements[i]);
            this.businessExceptionMappingStrategies[i] = new BusinessExceptionMappingStrategy(this.elements[i]);
        }
    }

    final EJSDeployedSupport get(EJSWrapperBase wrapper) {
        EJSDeployedSupport retVal = null;
        if (this.topOfStack < 0 || this.orig) {
            this.orig = true;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "EJSDeployedSupportStack::get called withTopOfStack or in orig mode: " + this.topOfStack + " orig:  " + this.orig);
            }
            this.elements = null;
            retVal = new EJSDeployedSupport(wrapper);
        } else if (this.topOfStack < this.elements.length) {
            WrapperInterface wInterface = wrapper.ivInterface;
            if (wInterface == WrapperInterface.REMOTE || wInterface == WrapperInterface.HOME || wInterface == WrapperInterface.SERVICE_ENDPOINT || wInterface == WrapperInterface.BUSINESS_RMI_REMOTE) {
                RemoteExceptionMappingStrategy remStrategy = this.remoteExceptionMappingStrategies[this.topOfStack];
                remStrategy.ivOrbUtils = wInterface == WrapperInterface.SERVICE_ENDPOINT ? null : wrapper.container.orbUtils;
                this.elements[this.topOfStack].exceptionStrategy = remStrategy;
            } else {
                this.elements[this.topOfStack].exceptionStrategy = wInterface == WrapperInterface.BUSINESS_LOCAL || wInterface == WrapperInterface.BUSINESS_REMOTE ? this.businessExceptionMappingStrategies[this.topOfStack] : this.localExceptionMappingStrategies[this.topOfStack];
            }
            retVal = this.elements[this.topOfStack++];
        } else {
            ++this.topOfStack;
            retVal = new EJSDeployedSupport(wrapper);
        }
        return retVal;
    }

    final void done(EJSDeployedSupport s) {
        if (this.orig || s == null || this.topOfStack == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "EJSDeployedSupportStack::done called with TopOfStack=" + this.topOfStack + " s: " + s + " orig=" + this.orig);
            }
            this.orig = true;
            this.elements = null;
        } else {
            --this.topOfStack;
            if (this.topOfStack < this.elements.length) {
                if (s != this.elements[this.topOfStack]) {
                    this.orig = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "EJSDeployedSupportStack::done called with wrong value for TopOfStack: " + s + "!=" + this.elements[this.topOfStack]);
                    }
                    this.elements = null;
                } else {
                    this.elements[this.topOfStack].initializeInstanceData();
                }
            }
        }
    }
}

