/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJBSecurityPolicyImpl;
import com.ibm.ejs.container.interceptors.InterceptorProxy;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.csi.ActivitySessionAttribute;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.ws.appprofile.accessintent.AIEJBMethodInfo;
import com.ibm.ws.appprofile.accessintent.EJBAccessIntent;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataImpl;
import com.ibm.ws.runtime.metadata.MethodMetaData;
import com.ibm.ws.runtime.service.MetaDataFactoryMgr;
import com.ibm.wsspi.security.policy.EJBSecurityPolicy;
import java.lang.reflect.Method;

public final class EJBMethodInfoImpl
extends MetaDataImpl
implements EJBMethodInfo,
AIEJBMethodInfo {
    private static final TraceComponent tc = Tr.register(EJBMethodInfoImpl.class, "EJBContainer", "com.ibm.ejs.container.container");
    private String methodSignature;
    private String jdiMethodSignature;
    private TransactionAttribute txAttr;
    private ActivitySessionAttribute asAttr;
    protected MethodInterface ivInterface;
    private String methodName;
    private boolean isHome;
    private boolean isStatefulSessionBean;
    protected BeanMetaData bmd;
    final boolean isStatelessSessionBean;
    final boolean isHomeCreate;
    protected int isolationAttr;
    final boolean readOnlyAttr;
    private boolean isaCMP11CustomFinderWithForUpdateAI = false;
    private boolean isaCMP11FBPK = false;
    private boolean isLocal;
    protected boolean setClassLoader;
    protected AccessIntent ivAccessIntent = null;
    public boolean isCMRSetMethod = false;
    protected boolean isLightweight = false;
    protected boolean isLightweightTxCapable = false;
    private String ivJPATaskName = null;
    InterceptorProxy[] ivAroundInvokeInterceptors = null;
    Method ivMethod = null;
    Method ivBridgeMethod = null;
    boolean ivSFSBRemove = false;
    boolean ivRetainIfException = false;
    EJBSecurityPolicyImpl ivSecurityPolicy = null;

    public EJBMethodInfoImpl(String methodSig, String jdiMethodSig, TransactionAttribute txAttr, int isolationAttr, ActivitySessionAttribute asAttr, MethodInterface methodInterface, boolean readOnlyAttr, String methodName, boolean denyAll, boolean permitAll, String[] rolesAllowed, boolean isStatefulSessionBean, boolean isStatelessSessionBean, boolean isaCMP11CustomFinderWithForUpdateAI, boolean isaCMP11FBPK, BeanMetaData bmd, MetaDataFactoryMgr metaDataManager) {
        super(metaDataManager.getSlotSize(MethodMetaData.class));
        this.methodSignature = methodSig;
        this.jdiMethodSignature = jdiMethodSig;
        this.txAttr = txAttr;
        this.isolationAttr = isolationAttr;
        this.asAttr = asAttr;
        this.ivInterface = methodInterface;
        this.readOnlyAttr = readOnlyAttr;
        this.methodName = methodName;
        this.isStatefulSessionBean = isStatefulSessionBean;
        this.isStatelessSessionBean = isStatelessSessionBean;
        this.isaCMP11CustomFinderWithForUpdateAI = isaCMP11CustomFinderWithForUpdateAI;
        this.isaCMP11FBPK = isaCMP11FBPK;
        this.bmd = bmd;
        this.ivSecurityPolicy = new EJBSecurityPolicyImpl(denyAll, permitAll, rolesAllowed, this);
        this.isHome = methodInterface == MethodInterface.HOME || methodInterface == MethodInterface.LOCAL_HOME;
        this.isLocal = methodInterface == MethodInterface.LOCAL || methodInterface == MethodInterface.LOCAL_HOME;
        this.isHomeCreate = this.isHome && methodName.equals("create");
        this.setClassLoader = methodInterface == MethodInterface.LOCAL || methodInterface == MethodInterface.LOCAL_HOME || methodInterface == MethodInterface.SERVICE_ENDPOINT || methodInterface == MethodInterface.MESSAGE_LISTENER;
        this.isLightweight = this.isLocal && bmd.isLightweight;
        this.isLightweightTxCapable = !(!this.isLightweight || txAttr != TransactionAttribute.TX_REQUIRED && txAttr != TransactionAttribute.TX_SUPPORTS && txAttr != TransactionAttribute.TX_MANDATORY || asAttr != ActivitySessionAttribute.AS_UNKNOWN && asAttr != ActivitySessionAttribute.AS_SUPPORTS);
    }

    public String getBeanClassName() {
        return this.bmd.enterpriseBeanClassName;
    }

    public String getAbstractBeanClassName() {
        return this.bmd.enterpriseBeanAbstractClass.getName();
    }

    public String getHomeName() {
        String returnValue = this.bmd.simpleJndiBindingName;
        if ((returnValue == null || returnValue.equals("")) && ((returnValue = this.bmd.ivRemoteHomeJndiName) == null || returnValue.equals(""))) {
            returnValue = this.bmd.ivLocalHomeJndiName;
        }
        return returnValue;
    }

    public String getMethodName() {
        if (this.methodName == null && this.methodSignature != null) {
            this.methodName = this.methodSignature.substring(0, this.methodSignature.indexOf(":"));
        }
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public String getJDIMethodSignature() {
        return this.jdiMethodSignature;
    }

    public TransactionAttribute getTransactionAttribute() {
        return this.txAttr;
    }

    public boolean getIsCMP11FBPK() {
        return this.isaCMP11FBPK;
    }

    public boolean getIsCMP11CustomFinderWithForUpdateAI() {
        return this.isaCMP11CustomFinderWithForUpdateAI;
    }

    public int getIsolationLevel() {
        return this.isolationAttr;
    }

    public ActivitySessionAttribute getActivitySessionAttribute() {
        return this.asAttr;
    }

    public boolean getReadOnlyAttribute() {
        return this.readOnlyAttr;
    }

    public MethodInterface getInterfaceType() {
        return this.ivInterface;
    }

    public boolean isHome() {
        return this.isHome;
    }

    public boolean isStatefulSessionBean() {
        return this.isStatefulSessionBean;
    }

    public boolean isStatelessSessionBean() {
        return this.isStatelessSessionBean;
    }

    public boolean isHomeCreate() {
        return this.isHomeCreate;
    }

    public boolean isLocalInterface() {
        return this.isLocal;
    }

    public boolean isLightweight() {
        return this.isLightweight;
    }

    public ComponentMetaData getComponentMetaData() {
        return this.bmd;
    }

    public EJBComponentMetaData getEJBComponentMetaData() {
        return this.bmd;
    }

    public boolean getCommitDanglingWork() {
        return this.bmd.commitDanglingWork;
    }

    public String getName() {
        return this.methodName;
    }

    public void release() {
    }

    public AccessIntent getAccessIntent(EJBAccessIntent aiService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessIntent");
        }
        AccessIntent ai = aiService.getAccessIntent(this, this.ivAccessIntent);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessIntent", ai);
        }
        return ai;
    }

    public AccessIntent getMethodAccessIntent(EJBAccessIntent aiService) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMethodAccessIntent");
        }
        AccessIntent ai = aiService.getMethodAccessIntent(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getMethodAccessIntent", ai);
        }
        return ai;
    }

    public void setPMInternalAccessIntent(AccessIntent ai) {
        this.ivAccessIntent = ai;
    }

    public void initializeInstanceData(String methodSignature, String methodNameOnly, BeanMetaData bmd, MethodInterface methodInterface, TransactionAttribute txAttr) {
        this.methodSignature = methodSignature;
        this.methodName = methodNameOnly;
        this.bmd = bmd;
        this.ivInterface = methodInterface;
        this.txAttr = txAttr;
        this.isHome = methodInterface == MethodInterface.HOME || methodInterface == MethodInterface.LOCAL_HOME;
        this.isLocal = methodInterface == MethodInterface.LOCAL || methodInterface == MethodInterface.LOCAL_HOME;
        this.setClassLoader = methodInterface == MethodInterface.LOCAL || methodInterface == MethodInterface.LOCAL_HOME || methodInterface == MethodInterface.SERVICE_ENDPOINT || methodInterface == MethodInterface.MESSAGE_LISTENER;
        this.isLightweight = this.isLocal && bmd.isLightweight;
        this.isLightweightTxCapable = !(!this.isLightweight || txAttr != TransactionAttribute.TX_REQUIRED && txAttr != TransactionAttribute.TX_SUPPORTS && txAttr != TransactionAttribute.TX_MANDATORY || this.asAttr != ActivitySessionAttribute.AS_UNKNOWN && this.asAttr != ActivitySessionAttribute.AS_SUPPORTS);
    }

    public String getAMCName() {
        J2EEName j2eeName = this.bmd.getJ2EEName();
        String app = j2eeName.getApplication();
        String mod = j2eeName.getModule();
        String comp = j2eeName.getComponent();
        String retval = app + "::" + mod + "::" + comp;
        return retval;
    }

    public J2EEName getJ2EEName() {
        return this.bmd.getJ2EEName();
    }

    public int getBeanType() {
        return this.bmd.type;
    }

    public boolean isReentrant() {
        return this.bmd.reentrant;
    }

    public Method getMethod() {
        return this.ivMethod;
    }

    public void setMethod(Method method) {
        this.ivMethod = method;
    }

    public void setBridgeMethod(Method bridgeMethod) {
        this.ivBridgeMethod = bridgeMethod;
    }

    public Method getBridgeMethod() {
        return this.ivBridgeMethod;
    }

    public boolean methodsMatch(Method method) {
        Class<?>[] parms2;
        Class<?>[] parms1;
        boolean match = false;
        if (method == this.ivMethod || method == this.ivBridgeMethod) {
            match = true;
        } else if (method.getName().equals(this.ivMethod.getName()) && (parms1 = method.getParameterTypes()).length == (parms2 = this.ivMethod.getParameterTypes()).length) {
            int i;
            match = true;
            int length = parms1.length;
            for (i = 0; i < length; ++i) {
                if (parms1[i] == parms2[i]) continue;
                match = false;
                break;
            }
            if (!match && this.ivBridgeMethod != null) {
                match = true;
                parms2 = this.ivBridgeMethod.getParameterTypes();
                for (i = 0; i < length; ++i) {
                    if (parms1[i] == parms2[i]) continue;
                    match = false;
                    break;
                }
            }
        }
        return match;
    }

    public InterceptorProxy[] getAroundInvokeInterceptorProxies() {
        return this.ivAroundInvokeInterceptors;
    }

    public void setAroundInvokeInterceptorProxies(InterceptorProxy[] proxies) {
        this.ivAroundInvokeInterceptors = proxies;
    }

    public void setSFSBRemove(boolean retainIfException) {
        this.ivSFSBRemove = true;
        this.ivRetainIfException = retainIfException;
    }

    public String getRunAsSpecifiedIdentity() {
        return this.bmd.ivRunAs;
    }

    public void setRunAsSpecifiedIdentity(String identity) {
        this.bmd.ivRunAs = identity;
    }

    public boolean isRunAsCallerIdentity() {
        return this.bmd.ivUseCallerIdentity;
    }

    public void setRunAsCallerIdentity(boolean runAs) {
        this.bmd.ivUseCallerIdentity = runAs;
    }

    public String getRole(String link) {
        String result = null;
        if (this.bmd.ivRoleLinkMap != null) {
            result = this.bmd.ivRoleLinkMap.get(link);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getRoleFromLink returning " + result);
        }
        return result;
    }

    public EJBSecurityPolicy getEJBSecurityPolicy() {
        return this.ivSecurityPolicy;
    }

    public void dump(StringBuilder sb, String newLine, String indent, int methodId, boolean dumpCMP2xAccessIntent) {
        sb.append(newLine).append(indent).append("method signature  = ");
        sb.append(this.methodSignature);
        if (methodId != Integer.MAX_VALUE) {
            sb.append(newLine).append(indent).append("Method index      = ");
            sb.append(methodId);
        } else {
            sb.append(newLine).append(indent).append("Method index      = unknown");
        }
        sb.append(newLine).append(indent).append("TX attribute      = ");
        sb.append(MethodAttribUtils.TX_ATTR_STR[this.txAttr.getValue()]);
        if (this.asAttr != null) {
            sb.append(newLine).append(indent).append("AS attribute      = ");
            sb.append(this.asAttr.toString());
        }
        if (this.bmd.ivModuleVersion <= 11) {
            sb.append(newLine).append(indent).append("CMP 1.x Isolation Level = ");
            sb.append(MethodAttribUtils.getIsolationLevelString(this.isolationAttr));
            if (this.bmd.cmpVersion == 1) {
                sb.append(newLine).append(indent).append("CMP 1.x access intent(read-only attribute) = ");
                sb.append(this.readOnlyAttr);
            }
        } else if (this.bmd.cmpVersion == 2 && dumpCMP2xAccessIntent) {
            EJBAccessIntent aiService = this.bmd.container.ivAIService;
            if (aiService != null) {
                AccessIntent ai = this.getAccessIntent(aiService);
                String aiString = ContainerTx.getAccessIntentString(ai);
                sb.append(newLine).append(indent).append("CMP 2.x AccessIntent = ");
                sb.append(aiString);
            }
        } else if (this.bmd.cmpVersion == 1) {
            sb.append(newLine).append(indent).append("CMP 1.x Isolation Level = ");
            sb.append(MethodAttribUtils.getIsolationLevelString(this.isolationAttr));
            sb.append(newLine).append(indent).append("CMP 1.x access intent(read-only attribute) = ");
            sb.append(this.readOnlyAttr);
        }
        sb.append(newLine).append(indent).append("JDI signature     = ");
        sb.append(this.jdiMethodSignature);
        this.ivSecurityPolicy.dump(sb, newLine, indent);
    }

    public boolean isSFSBRemoveMethod() {
        return this.ivSFSBRemove;
    }

    public String getJPATaskName() {
        if (this.ivJPATaskName == null) {
            this.ivJPATaskName = this.bmd.enterpriseBeanClassName + "." + this.getMethodName();
        }
        return this.ivJPATaskName;
    }
}

