/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.EJSRemoteWrapper;
import com.ibm.ejs.container.EJSWrapper;
import com.ibm.ejs.container.EJSWrapperForBasicSFSBHome;
import com.ibm.ejs.container.HomeOfHomes;
import com.ibm.ejs.container.util.ExceptionUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.ejbcontainer.EJBFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.EJBContainerImpl;
import com.ibm.ws.runtime.component.EJBContainerImpl_threadLocal;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.ImplFactory;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import javax.ejb.EJBException;
import javax.rmi.PortableRemoteObject;

public final class EJBFactoryImpl
extends EJSRemoteWrapper
implements EJBFactory {
    private static final String CLASS_NAME = EJBFactoryImpl.class.getName();
    private static final TraceComponent tc = Tr.register(CLASS_NAME, "EJBContainer", "com.ibm.ejs.container.container");
    private static final J2EENameFactory J2EENAME_FACTORY = (J2EENameFactory)ImplFactory.loadImplFromKey(J2EENameFactory.class);
    private final HomeOfHomes ivHomeOfHomes;

    private EJBFactoryImpl() {
        throw new IllegalStateException("Unsupported constructor");
    }

    EJBFactoryImpl(HomeOfHomes homeOfHomes) {
        this.ivHomeOfHomes = homeOfHomes;
    }

    public Object create(String application, String module, String beanName, String interfaceName) throws EJBException, RemoteException {
        if (application == null) {
            throw new IllegalArgumentException("Application name not specified");
        }
        if (module == null) {
            throw new IllegalArgumentException("Module name not specified");
        }
        if (!module.endsWith(".jar")) {
            throw new IllegalArgumentException("Module must be a .jar file");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("Bean name not specified");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("Interface name not specified");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "create : App = " + application + ", module = " + module + ", bean = " + beanName + ", interface = " + interfaceName);
        }
        Object retObj = null;
        EJSHome home = null;
        J2EEName j2eeName = null;
        try {
            j2eeName = J2EENAME_FACTORY.create(application, module, beanName);
            home = (EJSHome)this.ivHomeOfHomes.getHome(j2eeName);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".findByBeanName"), (String)"182", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure locating " + j2eeName, ex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findByBeanName: " + ejbex);
            }
            throw ejbex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "home = " + home.getJ2EEName());
        }
        BeanMetaData bmd = home.getBeanMetaData();
        if (interfaceName.equals(bmd.localHomeInterfaceClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "match on local home");
            }
            retObj = home.getWrapper().getLocalWrapper();
        } else if (interfaceName.equals(bmd.homeInterfaceClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "match on remote home");
            }
            EJSWrapper wrapper = home.getWrapper().getRemoteWrapper();
            retObj = EJBFactoryImpl.toStub(wrapper, bmd.classLoader);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for match on business interface");
            }
            retObj = this.createBusinessObject(home, bmd, interfaceName, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "create : " + retObj.getClass().getName());
        }
        return retObj;
    }

    public Object findByBeanName(String application, String beanName, String interfaceName) throws EJBException, RemoteException {
        if (application == null) {
            throw new IllegalArgumentException("Application name not specified");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("Bean name not specified");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("Interface name not specified");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findByBeanName : App = " + application + ", bean = " + beanName + ", interface = " + interfaceName);
        }
        Object retObj = null;
        EJSHome home = null;
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for home in all app modules...");
            }
            home = this.ivHomeOfHomes.getHomeByName(application, beanName);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".findByBeanName"), (String)"182", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure locating bean " + beanName + " in application " + application, ex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findByBeanName: " + ejbex);
            }
            throw ejbex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "home = " + home.getJ2EEName());
        }
        BeanMetaData bmd = home.getBeanMetaData();
        if (interfaceName.equals(bmd.localHomeInterfaceClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "match on local home");
            }
            retObj = home.getWrapper().getLocalWrapper();
        } else if (interfaceName.equals(bmd.homeInterfaceClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "match on remote home");
            }
            EJSWrapper wrapper = home.getWrapper().getRemoteWrapper();
            retObj = EJBFactoryImpl.toStub(wrapper, bmd.classLoader);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for match on business interface");
            }
            retObj = this.createBusinessObject(home, bmd, interfaceName, true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findByBeanName : " + retObj.getClass().getName());
        }
        return retObj;
    }

    public Object findByInterface(String application, String interfaceName) throws EJBException, RemoteException {
        if (application == null) {
            throw new IllegalArgumentException("Application name not specified");
        }
        if (interfaceName == null) {
            throw new IllegalArgumentException("Interface name not specified");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findByInterface : App = " + application + ", interface = " + interfaceName);
        }
        Object retObj = null;
        EJSHome home = null;
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "bean name not specified, auto-link on " + interfaceName);
            }
            home = this.ivHomeOfHomes.getHomeByInterface(application, null, interfaceName);
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".findByInterface"), (String)"182", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure locating interface " + interfaceName + " in application " + application, ex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "findByInterface: " + ejbex);
            }
            throw ejbex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "home = " + home.getJ2EEName());
        }
        BeanMetaData bmd = home.getBeanMetaData();
        if (interfaceName.equals(bmd.localHomeInterfaceClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "match on local home");
            }
            retObj = home.getWrapper().getLocalWrapper();
        } else if (interfaceName.equals(bmd.homeInterfaceClassName)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "match on remote home");
            }
            EJSWrapper wrapper = home.getWrapper().getRemoteWrapper();
            retObj = EJBFactoryImpl.toStub(wrapper, bmd.classLoader);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "looking for match on business interface");
            }
            retObj = this.createBusinessObject(home, bmd, interfaceName, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findByInterface : " + retObj.getClass().getName());
        }
        return retObj;
    }

    private Object createBusinessObject(EJSHome home, BeanMetaData bmd, String interfaceName, boolean ejblink) throws EJBException, NoSuchObjectException {
        Object retObj = null;
        ClassLoader classLoader = bmd.classLoader;
        try {
            Class businessInterface = classLoader.loadClass(interfaceName);
            if (ejblink) {
                businessInterface = bmd.getSupportingBusinessInterface(businessInterface);
            }
            if (home.isStatelessSessionHome()) {
                retObj = home.createBusinessObject(businessInterface);
            } else if (home.isStatefulSessionHome()) {
                EJSWrapperForBasicSFSBHome homeWrapper = home.getStatefulBusinessHomeWrapper();
                retObj = homeWrapper.create(businessInterface);
            }
            if (retObj instanceof Remote) {
                retObj = EJBFactoryImpl.toStub((Remote)retObj, classLoader);
            }
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".createBusinessObject"), (String)"281", (Object)this);
            EJBException ejbex = ExceptionUtil.EJBException("Failure creating instance of " + home.getJ2EEName() + " of type " + interfaceName, ex);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "createBusinessObject: " + ejbex);
            }
            throw ejbex;
        }
        if (retObj == null) {
            EJBException ejbex = new EJBException("Unable to create instance of " + home.getJ2EEName() + " of type " + interfaceName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "createBusinessObject: " + ejbex);
            }
            throw ejbex;
        }
        return retObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Remote toStub(Remote wrapper, ClassLoader classLoader) throws NoSuchObjectException {
        Remote remote;
        block2: {
            ClassLoader originalLoader = null;
            boolean resetClassLoader = false;
            SetContextClassLoaderPrivileged setCLPrivObj = ((EJBContainerImpl_threadLocal)EJBContainerImpl.svEJBContainerImpl_threadLocal.get()).ivClassLoaderChanger;
            try {
                setCLPrivObj.newClassLoader = classLoader;
                AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                originalLoader = setCLPrivObj.oldClassLoader;
                resetClassLoader = setCLPrivObj.wasChanged;
                remote = PortableRemoteObject.toStub((Remote)wrapper);
                Object var7_6 = null;
                if (!resetClassLoader) break block2;
                setCLPrivObj.newClassLoader = originalLoader;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var7_7 = null;
                    if (!resetClassLoader) break block3;
                    setCLPrivObj.newClassLoader = originalLoader;
                    AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
                }
                throw throwable;
            }
            AccessController.doPrivileged((PrivilegedAction)setCLPrivObj);
        }
        return remote;
    }
}

