/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.MathUtil;
import java.io.Serializable;

final class BeanIdCache {
    private final BeanId[] buckets;
    private int ivCacheFinds = 0;
    private int ivCacheHits = 0;
    private static final TraceComponent tc = Tr.register(BeanIdCache.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.BeanIdCache";

    public BeanIdCache(int numBuckets) {
        numBuckets = MathUtil.findNextPrime((int)numBuckets);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "<init> (" + numBuckets + ")");
        }
        this.buckets = new BeanId[numBuckets];
    }

    public BeanId find(BeanId beanId) {
        BeanId element = this.buckets[(beanId.hashValue & Integer.MAX_VALUE) % this.buckets.length];
        if (element == null || !element.equals(beanId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ++this.ivCacheFinds;
                Tr.debug(tc, "BeanId not found in BeanId Cache : " + this.ivCacheHits + " / " + this.ivCacheFinds);
            }
            element = beanId;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            ++this.ivCacheFinds;
            ++this.ivCacheHits;
            Tr.debug(tc, "BeanId found in BeanId Cache : " + this.ivCacheHits + " / " + this.ivCacheFinds);
        }
        return element;
    }

    public BeanId find(EJSHome home, Serializable pkey, boolean isHome) {
        int hashValue = BeanId.computeHashValue(home.j2eeName, pkey, isHome);
        BeanId element = this.buckets[(hashValue & Integer.MAX_VALUE) % this.buckets.length];
        if (element == null || !element.equals(home, pkey, isHome)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ++this.ivCacheFinds;
                Tr.debug(tc, "BeanId not found in BeanId Cache : " + this.ivCacheHits + " / " + this.ivCacheFinds);
            }
            element = new BeanId(home, pkey, isHome);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            ++this.ivCacheFinds;
            ++this.ivCacheHits;
            Tr.debug(tc, "BeanId found in BeanId Cache : " + this.ivCacheHits + " / " + this.ivCacheFinds);
        }
        return element;
    }

    public void add(BeanId beanId) {
        this.buckets[(beanId.hashValue & Integer.MAX_VALUE) % this.buckets.length] = beanId;
    }

    public void removeAll(EJSHome home) {
        for (int i = 0; i < this.buckets.length; ++i) {
            BeanId element = this.buckets[i];
            if (element == null || element.home != home) continue;
            this.buckets[i] = null;
        }
    }
}

