/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asc.ca;

import com.ibm.asc.bridge.ws.server.ASCProject;
import com.ibm.asc.ca.IChangeAgent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.ProjectHelper;

public class ChangeAgent
implements IChangeAgent {
    private File _workingDirectory;
    private Properties globalProperties = new Properties();
    private byte[] lastLog = null;

    public void init(String initializationString) throws Exception {
        this._workingDirectory = new File(initializationString);
    }

    public void putFile(File f, InputStream in) throws Exception {
        File dir;
        File af = this.getAdjustedFile(f);
        if (af.exists()) {
            File tmp = new File(af.getPath());
            File copy = new File(af.getPath() + ".copy");
            tmp.renameTo(copy);
        }
        if ((dir = af.getParentFile()) != null) {
            dir.mkdirs();
        }
        af.createNewFile();
        FileOutputStream os = new FileOutputStream(af);
        BufferedInputStream bis = new BufferedInputStream(in);
        byte[] buff = new byte[1024];
        int read = 0;
        while ((read = bis.read(buff, 0, buff.length)) != -1) {
            os.write(buff, 0, read);
        }
        os.flush();
        os.close();
    }

    public InputStream getFile(File f) throws Exception {
        File af = this.getAdjustedFile(f);
        return new FileInputStream(af);
    }

    public void invokeAnt(File f, Properties props, String target) throws Exception {
        this.invokeAnt(f, props, target, null);
    }

    public void invokeAnt(File f, Properties props, String target, DefaultLogger[] loggers) throws Exception {
        this.lastLog = null;
        File taskFile = this.getAdjustedFile(f);
        ASCProject proj = new ASCProject();
        this.loadProperties(proj, props);
        if (loggers != null) {
            for (int i = 0; i < loggers.length; ++i) {
                proj.addBuildListener(loggers[i]);
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        DefaultLogger inMemLogger = new DefaultLogger();
        inMemLogger.setErrorPrintStream(ps);
        inMemLogger.setOutputPrintStream(ps);
        inMemLogger.setMessageOutputLevel(4);
        proj.addBuildListener(inMemLogger);
        proj.fireBuildStarted();
        proj.init();
        ProjectHelper.configureProject(proj, taskFile);
        if (target == null) {
            target = proj.getDefaultTarget();
        }
        try {
            proj.executeTarget(target);
            proj.fireBuildFinished(null);
        }
        catch (BuildException e) {
            proj.fireBuildFinished(e);
            throw e;
        }
        finally {
            ps.flush();
            this.lastLog = bos.toByteArray();
        }
    }

    public InputStream getLastLog() {
        if (this.lastLog == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.lastLog);
        return bais;
    }

    private void loadProperties(ASCProject p, Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            p.setProperty(key, props.getProperty(key));
        }
    }

    private File getAdjustedFile(File f) throws IOException {
        if (f.isAbsolute()) {
            throw new IOException("A method of " + this.getClass().getName() + " was invoked with an absolute file reference (" + f.getPath() + ").  That is not allowed:  File references must be relative.");
        }
        if (f.isDirectory()) {
            throw new IOException("A method of " + this.getClass().getName() + " was invoked with a directory in place of a file reference (" + f.getPath() + ").  That is not allowed.");
        }
        Vector<String> subdirs = new Vector<String>();
        File af = new File(this._workingDirectory.getPath());
        for (File parent = f.getParentFile(); parent != null; parent = parent.getParentFile()) {
            subdirs.add(0, parent.getName());
        }
        Enumeration e = subdirs.elements();
        while (e.hasMoreElements()) {
            String subdir = (String)e.nextElement();
            af = new File(af, subdir);
        }
        return new File(af, f.getName());
    }

    public String toString() {
        return "ChangeAgent (working directory=" + this._workingDirectory.getAbsolutePath() + ")";
    }
}

