/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.asc.bridge.ws.server;

import com.ibm.asc.ca.ChangeAgent;
import com.ibm.asc.ca.IChangeAgent;
import com.ibm.websphere.management.exception.AdminException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class WsAntAgent {
    private String workingDir;
    private IChangeAgent handler;

    public WsAntAgent(Properties initProps) throws Exception {
        String installRoot = System.getProperty("user.install.root");
        if (installRoot != null && !installRoot.equals("")) {
            this.workingDir = installRoot + File.separator + "temp";
        } else {
            installRoot = initProps.getProperty("wsant.agent.root");
            if (installRoot != null && !installRoot.equals("")) {
                this.workingDir = installRoot + File.separator + "temp";
            }
        }
        if (this.workingDir == null && (installRoot = System.getProperty("was.install.root")) != null && !installRoot.equals("")) {
            this.workingDir = installRoot + File.separator + "temp";
        }
        this.handler = new ChangeAgent();
        this.handler.init(this.workingDir);
    }

    public WsAntAgent(Properties initProps, String profilePath) throws Exception {
        this.workingDir = profilePath + File.separator + "temp";
        this.handler = new ChangeAgent();
        this.handler.init(this.workingDir);
    }

    public void invokeAnt(String[] invocationProperties, String taskFilePath, String antTarget) throws AdminException {
        try {
            Properties props = this.loadPropsFromArray(invocationProperties);
            File f = new File(taskFilePath);
            this.handler.invokeAnt(f, props, antTarget);
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage());
        }
    }

    public byte[] getScript(String filePath) throws AdminException {
        try {
            File f = new File(filePath);
            InputStream result = this.handler.getFile(f);
            byte[] data = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = result.read(data);
            while (count != -1) {
                baos.write(data, 0, count);
                count = result.read(data);
            }
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
    }

    public void putScript(String filePath, byte[] putFileContents) throws AdminException {
        try {
            File f = new File(filePath);
            ByteArrayInputStream bais = new ByteArrayInputStream(putFileContents);
            this.handler.putFile(f, bais);
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
    }

    public byte[] getLastLog() throws AdminException {
        try {
            InputStream is = this.handler.getLastLog();
            if (is == null) {
                return null;
            }
            byte[] data = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int count = is.read(data);
            while (count != -1) {
                baos.write(data, 0, count);
                count = is.read(data);
            }
            baos.flush();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new AdminException(e);
        }
    }

    private Properties loadPropsFromArray(String[] props) throws IOException {
        if (props == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < props.length; ++i) {
            String prop = props[i] + "\n";
            bos.write(prop.getBytes());
        }
        bos.flush();
        bos.close();
        byte[] content = bos.toByteArray();
        Properties p = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(content);
        p.load(bais);
        return p;
    }

    private byte[] getBytes(File f) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileInputStream is = new FileInputStream(f);
        byte[] data = new byte[1024];
        int count = is.read(data);
        while (count != -1) {
            baos.write(data, 0, count);
            count = is.read(data);
        }
        baos.close();
        byte[] content = baos.toByteArray();
        return content;
    }
}

